/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import org.jetbrains.annotations.Nullable;

public record StandardModelParameters(@Nullable ResourceLocation parent, TextureSlots.Data textures, @Nullable ItemTransforms itemTransforms, @Nullable Boolean ambientOcclusion, @Nullable UnbakedModel.GuiLight guiLight, @Nullable Transformation rootTransform, RenderTypeGroup renderTypeGroup, Map<String, Boolean> partVisibility) {
    public static StandardModelParameters parse(JsonObject jsonObject, JsonDeserializationContext context) {
        String parentName = GsonHelper.getAsString((JsonObject)jsonObject, (String)"parent", (String)"");
        ResourceLocation parent = parentName.isEmpty() ? null : ResourceLocation.parse((String)parentName);
        TextureSlots.Data textures = TextureSlots.Data.EMPTY;
        if (jsonObject.has("textures")) {
            JsonObject jsonobject = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"textures");
            textures = TextureSlots.parseTextureMap((JsonObject)jsonobject, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        }
        ItemTransforms itemTransforms = null;
        if (jsonObject.has("display")) {
            JsonObject jsonobject1 = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"display");
            itemTransforms = (ItemTransforms)context.deserialize((JsonElement)jsonobject1, ItemTransforms.class);
        }
        Boolean ambientOcclusion = null;
        if (jsonObject.has("ambientocclusion")) {
            ambientOcclusion = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"ambientocclusion");
        }
        UnbakedModel.GuiLight guiLight = null;
        if (jsonObject.has("gui_light")) {
            guiLight = UnbakedModel.GuiLight.getByName((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"gui_light"));
        }
        Transformation rootTransform = NeoForgeModelProperties.deserializeRootTransform(jsonObject, context);
        RenderTypeGroup renderTypeGroup = NeoForgeModelProperties.deserializeRenderType(jsonObject);
        Map<String, Boolean> partVisibility = NeoForgeModelProperties.deserializePartVisibility(jsonObject);
        return new StandardModelParameters(parent, textures, itemTransforms, ambientOcclusion, guiLight, rootTransform, renderTypeGroup, partVisibility);
    }
}

