/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.energy;

import java.lang.invoke.LambdaMetafactory;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public final class EnergyHandlerUtil {
    public static boolean isFull(EnergyHandler handler) {
        return handler.getAmountAsLong() >= handler.getCapacityAsLong();
    }

    public static int getRedstoneSignalFromEnergyHandler(EnergyHandler handler) {
        long amount = handler.getAmountAsLong();
        if (amount == 0L) {
            return 0;
        }
        long capacity = handler.getCapacityAsLong();
        if (capacity == 0L) {
            return 0;
        }
        return Mth.lerpDiscrete((float)Math.min(1.0f, (float)amount / (float)capacity), (int)0, (int)15);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int move(@Nullable EnergyHandler from, @Nullable EnergyHandler to, int amount, @Nullable TransactionContext transaction) {
        TransferPreconditions.checkNonNegative(amount);
        if (from == null) return 0;
        if (to == null) return 0;
        if (amount == 0) {
            return 0;
        }
        try (Transaction subTransaction = Transaction.open(transaction);){
            int maxExtracted;
            try (Transaction simulatedExtract = Transaction.open(subTransaction);){
                maxExtracted = from.extract(amount, simulatedExtract);
            }
            if (maxExtracted == 0) {
                int simulatedExtract = 0;
                return simulatedExtract;
            }
            int inserted = to.insert(maxExtracted, subTransaction);
            if (inserted != from.extract(inserted, subTransaction)) {
                int n = 0;
                return n;
            }
            subTransaction.commit();
            int n = inserted;
            return n;
        }
        catch (Exception e) {
            CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Moving energy between handlers");
            report.addCategory("Move details").setDetail("Input", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((EnergyHandler)from)).setDetail("Output", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((EnergyHandler)to)).setDetail("Amount", (Object)amount).setDetail("Transaction", (Object)transaction);
            throw new ReportedException(report);
        }
    }

    private EnergyHandlerUtil() {
    }
}

