/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

@Deprecated(since="1.21.9", forRemoval=true)
public class ComponentItemHandler
implements IItemHandlerModifiable {
    protected final MutableDataComponentHolder parent;
    protected final DataComponentType<ItemContainerContents> component;
    protected final int size;

    public ComponentItemHandler(MutableDataComponentHolder parent, DataComponentType<ItemContainerContents> component, int size) {
        this.parent = parent;
        this.component = component;
        this.size = size;
        Preconditions.checkArgument((size <= 256 ? 1 : 0) != 0, (Object)"The max size of ItemContainerContents is 256 slots.");
    }

    @Override
    public int getSlots() {
        return this.size;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        ItemContainerContents contents = this.getContents();
        return this.getStackFromContents(contents, slot);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        ItemContainerContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (!ItemStack.matches((ItemStack)stack, (ItemStack)existing)) {
            this.updateContents(contents, stack, slot);
        }
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack toInsert, boolean simulate) {
        this.validateSlotIndex(slot);
        if (toInsert.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, toInsert)) {
            return toInsert;
        }
        ItemContainerContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        int insertLimit = Math.min(this.getSlotLimit(slot), toInsert.getMaxStackSize());
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)toInsert, (ItemStack)existing)) {
                return toInsert;
            }
            insertLimit -= existing.getCount();
        }
        if (insertLimit <= 0) {
            return toInsert;
        }
        int inserted = Math.min(insertLimit, toInsert.getCount());
        if (!simulate) {
            this.updateContents(contents, toInsert.copyWithCount(existing.getCount() + inserted), slot);
        }
        return toInsert.copyWithCount(toInsert.getCount() - inserted);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemContainerContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getCount());
        if (!simulate) {
            this.updateContents(contents, existing.copyWithCount(existing.getCount() - toExtract), slot);
        }
        return existing.copyWithCount(toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 99;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.canFitInsideContainerItems();
    }

    protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
    }

    protected ItemContainerContents getContents() {
        return (ItemContainerContents)this.parent.getOrDefault(this.component, ItemContainerContents.EMPTY);
    }

    protected ItemStack getStackFromContents(ItemContainerContents contents, int slot) {
        this.validateSlotIndex(slot);
        return contents.getSlots() <= slot ? ItemStack.EMPTY : contents.getStackInSlot(slot);
    }

    protected void updateContents(ItemContainerContents contents, ItemStack stack, int slot) {
        this.validateSlotIndex(slot);
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.getSlots()), (Object)ItemStack.EMPTY);
        contents.copyInto(list);
        ItemStack oldStack = (ItemStack)list.get(slot);
        list.set(slot, (Object)stack);
        this.parent.set(this.component, ItemContainerContents.fromItems((List)list));
        this.onContentsChanged(slot, oldStack, stack);
    }

    protected final void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

