/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ExtractLevelRenderStateEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="neoforge")
public final class BlockEntityRenderBoundsDebugRenderer {
    private static final ContextKey<List<BlockEntityRenderBoundsRenderState>> DATA_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"block_entity_render_bounds"));
    private static boolean enabled = false;

    @SubscribeEvent
    public static void onExtractLevelRenderState(ExtractLevelRenderStateEvent event) {
        if (!enabled) {
            return;
        }
        ArrayList renderStates = new ArrayList();
        BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        event.getLevelRenderer().iterateVisibleBlockEntities(be -> {
            AABB aabb;
            BlockEntityRenderer renderer = dispatcher.getRenderer(be);
            if (renderer != null && !(aabb = renderer.getRenderBoundingBox(be)).isInfinite()) {
                BlockPos pos = be.getBlockPos();
                aabb = aabb.move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
                renderStates.add(new BlockEntityRenderBoundsRenderState(pos, aabb));
            }
        });
        if (!renderStates.isEmpty()) {
            event.getRenderState().setRenderData(DATA_KEY, renderStates);
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent.AfterEntities event) {
        if (!enabled) {
            return;
        }
        List renderStates = (List)event.getLevelRenderState().getRenderData(DATA_KEY);
        if (renderStates == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Vec3 camera = event.getLevelRenderState().cameraRenderState.pos;
        VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
        for (BlockEntityRenderBoundsRenderState be : renderStates) {
            Vec3 offset = Vec3.atLowerCornerOf((Vec3i)be.pos).subtract(camera);
            poseStack.pushPose();
            poseStack.translate(offset.x, offset.y, offset.z);
            ShapeRenderer.renderLineBox((PoseStack.Pose)poseStack.last(), (VertexConsumer)consumer, (AABB)be.bounds, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"neoforge").then(((LiteralArgumentBuilder)Commands.literal((String)"debug_blockentity_renderbounds").requires(src -> src.hasPermission(3))).then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            enabled = BoolArgumentType.getBool((CommandContext)ctx, (String)"enable");
            return 1;
        }))));
    }

    private BlockEntityRenderBoundsDebugRenderer() {
    }

    private record BlockEntityRenderBoundsRenderState(BlockPos pos, AABB bounds) {
    }
}

