/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.TagConventionLogWarning;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public final class NeoForgeCommonConfig {
    @ApiStatus.Internal
    public static final ModConfigSpec SPEC;
    public static final NeoForgeCommonConfig INSTANCE;
    public final ModConfigSpec.EnumValue<TagConventionLogWarning.LogWarningMode> logUntranslatedItemTagWarnings;
    public final ModConfigSpec.EnumValue<TagConventionLogWarning.LogWarningMode> logLegacyTagWarnings;
    public final ModConfigSpec.BooleanValue attributeAdvancedTooltipDebugInfo;

    private NeoForgeCommonConfig(ModConfigSpec.Builder builder) {
        this.logUntranslatedItemTagWarnings = builder.comment("A config option mainly for developers. Logs out modded item tags that do not have translations when running on integrated server. Format desired is tag.item.<namespace>.<path> for the translation key. Defaults to SILENCED.").translation("neoforge.configgui.logUntranslatedItemTagWarnings").defineEnum("logUntranslatedItemTagWarnings", TagConventionLogWarning.LogWarningMode.SILENCED);
        this.logLegacyTagWarnings = builder.comment("A config option mainly for developers. Logs out modded tags that are using the 'forge' namespace when running on integrated server. Defaults to DEV_SHORT.").translation("neoforge.configgui.logLegacyTagWarnings").defineEnum("logLegacyTagWarnings", TagConventionLogWarning.LogWarningMode.DEV_SHORT);
        this.attributeAdvancedTooltipDebugInfo = builder.comment("Set this to true to enable showing debug information about attributes on an item when advanced tooltips is on.").translation("neoforge.configgui.attributeAdvancedTooltipDebugInfo").define("attributeAdvancedTooltipDebugInfo", true);
    }

    static {
        Pair<NeoForgeCommonConfig, ModConfigSpec> specPair = new ModConfigSpec.Builder().configure(NeoForgeCommonConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (NeoForgeCommonConfig)specPair.getLeft();
    }
}

