/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.fluid;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.transfer.ItemAccessResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;

public class ItemAccessFluidHandler
extends ItemAccessResourceHandler<FluidResource> {
    protected final Item validItem;
    protected final DataComponentType<SimpleFluidContent> component;
    protected int capacity;

    public ItemAccessFluidHandler(ItemAccess itemAccess, DataComponentType<SimpleFluidContent> component, int capacity) {
        super(itemAccess, 1);
        this.validItem = itemAccess.getResource().getItem();
        this.component = component;
        this.capacity = capacity;
    }

    @Override
    protected FluidResource getResourceFrom(ItemResource accessResource, int index) {
        if (accessResource.is(this.validItem)) {
            return FluidResource.of(((SimpleFluidContent)accessResource.getOrDefault(this.component, SimpleFluidContent.EMPTY)).copy());
        }
        return FluidResource.EMPTY;
    }

    @Override
    protected int getAmountFrom(ItemResource accessResource, int index) {
        if (accessResource.is(this.validItem)) {
            return ((SimpleFluidContent)accessResource.getOrDefault(this.component, SimpleFluidContent.EMPTY)).getAmount();
        }
        return 0;
    }

    @Override
    protected ItemResource update(ItemResource accessResource, int index, FluidResource newResource, int newAmount) {
        return accessResource.with((DataComponentType)this.component, (Object)SimpleFluidContent.copyOf(newResource.toStack(newAmount)));
    }

    @Override
    public boolean isValid(int index, FluidResource resource) {
        return this.itemAccess.getResource().is(this.validItem);
    }

    @Override
    protected int getCapacity(int index, FluidResource resource) {
        return this.capacity;
    }
}

