/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.blaze3d.validation;

import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import net.neoforged.neoforge.client.blaze3d.validation.GpuDeviceUsageValidator;
import org.jetbrains.annotations.ApiStatus;

public class ValidationGpuTexture
extends GpuTexture {
    private final GpuTexture realTexture;
    private final GpuDeviceUsageValidator validator;

    public ValidationGpuTexture(GpuTexture realTexture, GpuDeviceUsageValidator validator) {
        super(realTexture.usage(), realTexture.getLabel(), realTexture.getFormat(), realTexture.getWidth(0), realTexture.getHeight(0), realTexture.getDepthOrLayers(), realTexture.getMipLevels());
        this.realTexture = realTexture;
        this.validator = validator;
    }

    @ApiStatus.Internal
    public GpuTexture getRealTexture() {
        return this.realTexture;
    }

    public void setAddressMode(AddressMode addressModeU, AddressMode addressModeV) {
        super.setAddressMode(addressModeU, addressModeV);
        this.realTexture.setAddressMode(addressModeU, addressModeV);
    }

    public void setTextureFilter(FilterMode minFilter, FilterMode magFilter, boolean useMipmaps) {
        super.setTextureFilter(minFilter, magFilter, useMipmaps);
        this.realTexture.setTextureFilter(minFilter, magFilter, useMipmaps);
    }

    public void setUseMipmaps(boolean useMipmaps) {
        super.setUseMipmaps(useMipmaps);
        this.realTexture.setUseMipmaps(useMipmaps);
    }

    public void close() {
        this.realTexture.close();
    }

    public boolean isClosed() {
        return this.realTexture.isClosed();
    }
}

