/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;

public class Tags {
    public static String getTagTranslationKey(TagKey<?> tagKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tag.");
        ResourceLocation registryIdentifier = tagKey.registry().location();
        ResourceLocation tagIdentifier = tagKey.location();
        stringBuilder.append(registryIdentifier.toShortLanguageKey().replace("/", ".")).append(".").append(tagIdentifier.getNamespace()).append(".").append(tagIdentifier.getPath().replace("/", "."));
        return stringBuilder.toString();
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> IS_MAGIC = DamageTypes.neoforgeTag("is_magic");
        public static final TagKey<DamageType> IS_POISON = DamageTypes.neoforgeTag("is_poison");
        public static final TagKey<DamageType> IS_WITHER = DamageTypes.neoforgeTag("is_wither");
        public static final TagKey<DamageType> IS_ENVIRONMENT = DamageTypes.neoforgeTag("is_environment");
        public static final TagKey<DamageType> IS_PHYSICAL = DamageTypes.neoforgeTag("is_physical");
        public static final TagKey<DamageType> IS_TECHNICAL = DamageTypes.neoforgeTag("is_technical");
        public static final TagKey<DamageType> NO_FLINCH = DamageTypes.neoforgeTag("no_flinch");

        private static TagKey<DamageType> neoforgeTag(String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)name));
        }
    }

    public static class Structures {
        public static final TagKey<Structure> HIDDEN_FROM_DISPLAYERS = Structures.tag("hidden_from_displayers");
        public static final TagKey<Structure> HIDDEN_FROM_LOCATOR_SELECTION = Structures.tag("hidden_from_locator_selection");

        private static TagKey<Structure> tag(String name) {
            return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> NO_DEFAULT_MONSTERS = Biomes.tag("no_default_monsters");
        public static final TagKey<Biome> HIDDEN_FROM_LOCATOR_SELECTION = Biomes.tag("hidden_from_locator_selection");
        public static final TagKey<Biome> IS_VOID = Biomes.tag("is_void");
        public static final TagKey<Biome> IS_HOT = Biomes.tag("is_hot");
        public static final TagKey<Biome> IS_HOT_OVERWORLD = Biomes.tag("is_hot/overworld");
        public static final TagKey<Biome> IS_HOT_NETHER = Biomes.tag("is_hot/nether");
        public static final TagKey<Biome> IS_HOT_END = Biomes.tag("is_hot/end");
        public static final TagKey<Biome> IS_TEMPERATE = Biomes.tag("is_temperate");
        public static final TagKey<Biome> IS_TEMPERATE_OVERWORLD = Biomes.tag("is_temperate/overworld");
        public static final TagKey<Biome> IS_TEMPERATE_NETHER = Biomes.tag("is_temperate/nether");
        public static final TagKey<Biome> IS_TEMPERATE_END = Biomes.tag("is_temperate/end");
        public static final TagKey<Biome> IS_COLD = Biomes.tag("is_cold");
        public static final TagKey<Biome> IS_COLD_OVERWORLD = Biomes.tag("is_cold/overworld");
        public static final TagKey<Biome> IS_COLD_NETHER = Biomes.tag("is_cold/nether");
        public static final TagKey<Biome> IS_COLD_END = Biomes.tag("is_cold/end");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION = Biomes.tag("is_sparse_vegetation");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_OVERWORLD = Biomes.tag("is_sparse_vegetation/overworld");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_NETHER = Biomes.tag("is_sparse_vegetation/nether");
        public static final TagKey<Biome> IS_SPARSE_VEGETATION_END = Biomes.tag("is_sparse_vegetation/end");
        public static final TagKey<Biome> IS_DENSE_VEGETATION = Biomes.tag("is_dense_vegetation");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_OVERWORLD = Biomes.tag("is_dense_vegetation/overworld");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_NETHER = Biomes.tag("is_dense_vegetation/nether");
        public static final TagKey<Biome> IS_DENSE_VEGETATION_END = Biomes.tag("is_dense_vegetation/end");
        public static final TagKey<Biome> IS_WET = Biomes.tag("is_wet");
        public static final TagKey<Biome> IS_WET_OVERWORLD = Biomes.tag("is_wet/overworld");
        public static final TagKey<Biome> IS_WET_NETHER = Biomes.tag("is_wet/nether");
        public static final TagKey<Biome> IS_WET_END = Biomes.tag("is_wet/end");
        public static final TagKey<Biome> IS_DRY = Biomes.tag("is_dry");
        public static final TagKey<Biome> IS_DRY_OVERWORLD = Biomes.tag("is_dry/overworld");
        public static final TagKey<Biome> IS_DRY_NETHER = Biomes.tag("is_dry/nether");
        public static final TagKey<Biome> IS_DRY_END = Biomes.tag("is_dry/end");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE = Biomes.tag("primary_wood_type");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_OAK = Biomes.tag("primary_wood_type/oak");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_BIRCH = Biomes.tag("primary_wood_type/birch");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_SPRUCE = Biomes.tag("primary_wood_type/spruce");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_JUNGLE = Biomes.tag("primary_wood_type/jungle");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_ACACIA = Biomes.tag("primary_wood_type/acacia");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_DARK_OAK = Biomes.tag("primary_wood_type/dark_oak");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_MANGROVE = Biomes.tag("primary_wood_type/mangrove");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_CHERRY = Biomes.tag("primary_wood_type/cherry");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_PALE_OAK = Biomes.tag("primary_wood_type/pale_oak");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_BAMBOO = Biomes.tag("primary_wood_type/bamboo");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_CRIMSON = Biomes.tag("primary_wood_type/crimson");
        public static final TagKey<Biome> PRIMARY_WOOD_TYPE_WARPED = Biomes.tag("primary_wood_type/warped");
        public static final TagKey<Biome> IS_OVERWORLD = Biomes.tag("is_overworld");
        public static final TagKey<Biome> IS_CONIFEROUS_TREE = Biomes.tag("is_tree/coniferous");
        public static final TagKey<Biome> IS_SAVANNA_TREE = Biomes.tag("is_tree/savanna");
        public static final TagKey<Biome> IS_JUNGLE_TREE = Biomes.tag("is_tree/jungle");
        public static final TagKey<Biome> IS_DECIDUOUS_TREE = Biomes.tag("is_tree/deciduous");
        public static final TagKey<Biome> IS_MOUNTAIN = Biomes.tag("is_mountain");
        public static final TagKey<Biome> IS_MOUNTAIN_PEAK = Biomes.tag("is_mountain/peak");
        public static final TagKey<Biome> IS_MOUNTAIN_SLOPE = Biomes.tag("is_mountain/slope");
        public static final TagKey<Biome> IS_PLAINS = Biomes.tag("is_plains");
        public static final TagKey<Biome> IS_SNOWY_PLAINS = Biomes.tag("is_snowy_plains");
        public static final TagKey<Biome> IS_FOREST = Biomes.tag("is_forest");
        public static final TagKey<Biome> IS_BIRCH_FOREST = Biomes.tag("is_birch_forest");
        public static final TagKey<Biome> IS_DARK_FOREST = Biomes.tag("is_dark_forest");
        public static final TagKey<Biome> IS_FLOWER_FOREST = Biomes.tag("is_flower_forest");
        public static final TagKey<Biome> IS_TAIGA = Biomes.tag("is_taiga");
        public static final TagKey<Biome> IS_OLD_GROWTH = Biomes.tag("is_old_growth");
        public static final TagKey<Biome> IS_HILL = Biomes.tag("is_hill");
        public static final TagKey<Biome> IS_WINDSWEPT = Biomes.tag("is_windswept");
        public static final TagKey<Biome> IS_JUNGLE = Biomes.tag("is_jungle");
        public static final TagKey<Biome> IS_SAVANNA = Biomes.tag("is_savanna");
        public static final TagKey<Biome> IS_SWAMP = Biomes.tag("is_swamp");
        public static final TagKey<Biome> IS_DESERT = Biomes.tag("is_desert");
        public static final TagKey<Biome> IS_BADLANDS = Biomes.tag("is_badlands");
        public static final TagKey<Biome> IS_BEACH = Biomes.tag("is_beach");
        public static final TagKey<Biome> IS_STONY_SHORES = Biomes.tag("is_stony_shores");
        public static final TagKey<Biome> IS_MUSHROOM = Biomes.tag("is_mushroom");
        public static final TagKey<Biome> IS_RIVER = Biomes.tag("is_river");
        public static final TagKey<Biome> IS_OCEAN = Biomes.tag("is_ocean");
        public static final TagKey<Biome> IS_DEEP_OCEAN = Biomes.tag("is_deep_ocean");
        public static final TagKey<Biome> IS_SHALLOW_OCEAN = Biomes.tag("is_shallow_ocean");
        public static final TagKey<Biome> IS_UNDERGROUND = Biomes.tag("is_underground");
        public static final TagKey<Biome> IS_CAVE = Biomes.tag("is_cave");
        public static final TagKey<Biome> IS_LUSH = Biomes.tag("is_lush");
        public static final TagKey<Biome> IS_MAGICAL = Biomes.tag("is_magical");
        public static final TagKey<Biome> IS_RARE = Biomes.tag("is_rare");
        public static final TagKey<Biome> IS_PLATEAU = Biomes.tag("is_plateau");
        public static final TagKey<Biome> IS_SPOOKY = Biomes.tag("is_spooky");
        public static final TagKey<Biome> IS_WASTELAND = Biomes.tag("is_wasteland");
        public static final TagKey<Biome> IS_DEAD = Biomes.tag("is_dead");
        public static final TagKey<Biome> IS_FLORAL = Biomes.tag("is_floral");
        public static final TagKey<Biome> IS_SANDY = Biomes.tag("is_sandy");
        public static final TagKey<Biome> IS_SNOWY = Biomes.tag("is_snowy");
        public static final TagKey<Biome> IS_ICY = Biomes.tag("is_icy");
        public static final TagKey<Biome> IS_AQUATIC = Biomes.tag("is_aquatic");
        public static final TagKey<Biome> IS_AQUATIC_ICY = Biomes.tag("is_aquatic_icy");
        public static final TagKey<Biome> IS_NETHER = Biomes.tag("is_nether");
        public static final TagKey<Biome> IS_NETHER_FOREST = Biomes.tag("is_nether_forest");
        public static final TagKey<Biome> IS_END = Biomes.tag("is_end");
        public static final TagKey<Biome> IS_OUTER_END_ISLAND = Biomes.tag("is_outer_end_island");

        private static TagKey<Biome> tag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Enchantments {
        public static final TagKey<Enchantment> INCREASE_BLOCK_DROPS = Enchantments.tag("increase_block_drops");
        public static final TagKey<Enchantment> INCREASE_ENTITY_DROPS = Enchantments.tag("increase_entity_drops");
        public static final TagKey<Enchantment> WEAPON_DAMAGE_ENHANCEMENTS = Enchantments.tag("weapon_damage_enhancements");
        public static final TagKey<Enchantment> ENTITY_SPEED_ENHANCEMENTS = Enchantments.tag("entity_speed_enhancements");
        public static final TagKey<Enchantment> ENTITY_AUXILIARY_MOVEMENT_ENHANCEMENTS = Enchantments.tag("entity_auxiliary_movement_enhancements");
        public static final TagKey<Enchantment> ENTITY_DEFENSE_ENHANCEMENTS = Enchantments.tag("entity_defense_enhancements");

        private static TagKey<Enchantment> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> WATER = Fluids.tag("water");
        public static final TagKey<Fluid> LAVA = Fluids.tag("lava");
        public static final TagKey<Fluid> MILK = Fluids.tag("milk");
        public static final TagKey<Fluid> GASEOUS = Fluids.tag("gaseous");
        public static final TagKey<Fluid> HONEY = Fluids.tag("honey");
        public static final TagKey<Fluid> EXPERIENCE = Fluids.tag("experience");
        public static final TagKey<Fluid> POTION = Fluids.tag("potion");
        public static final TagKey<Fluid> SUSPICIOUS_STEW = Fluids.tag("suspicious_stew");
        public static final TagKey<Fluid> MUSHROOM_STEW = Fluids.tag("mushroom_stew");
        public static final TagKey<Fluid> RABBIT_STEW = Fluids.tag("rabbit_stew");
        public static final TagKey<Fluid> BEETROOT_SOUP = Fluids.tag("beetroot_soup");
        public static final TagKey<Fluid> HIDDEN_FROM_RECIPE_VIEWERS = Fluids.tag("hidden_from_recipe_viewers");

        private static TagKey<Fluid> tag(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> ENCHANTING_FUELS = Items.neoforgeTag("enchanting_fuels");
        public static final TagKey<Item> PIGLIN_USABLE_CROSSBOWS = Items.neoforgeTag("piglin_usable_crossbows");
        public static final TagKey<Item> PILLAGER_USABLE_CROSSBOWS = Items.neoforgeTag("pillager_usable_crossbows");
        public static final TagKey<Item> SKELETON_USABLE_BOWS = Items.neoforgeTag("skeleton_usable_bows");
        public static final TagKey<Item> BARRELS = Items.tag("barrels");
        public static final TagKey<Item> BARRELS_WOODEN = Items.tag("barrels/wooden");
        public static final TagKey<Item> BONES = Items.tag("bones");
        public static final TagKey<Item> BOOKSHELVES = Items.tag("bookshelves");
        public static final TagKey<Item> BRICKS = Items.tag("bricks");
        public static final TagKey<Item> BRICKS_NORMAL = Items.tag("bricks/normal");
        public static final TagKey<Item> BRICKS_NETHER = Items.tag("bricks/nether");
        public static final TagKey<Item> BRICKS_RESIN = Items.tag("bricks/resin");
        public static final TagKey<Item> BUCKETS = Items.tag("buckets");
        public static final TagKey<Item> BUCKETS_EMPTY = Items.tag("buckets/empty");
        public static final TagKey<Item> BUCKETS_WATER = Items.tag("buckets/water");
        public static final TagKey<Item> BUCKETS_LAVA = Items.tag("buckets/lava");
        public static final TagKey<Item> BUCKETS_MILK = Items.tag("buckets/milk");
        public static final TagKey<Item> BUCKETS_POWDER_SNOW = Items.tag("buckets/powder_snow");
        public static final TagKey<Item> BUCKETS_ENTITY_WATER = Items.tag("buckets/entity_water");
        public static final TagKey<Item> BUDDING_BLOCKS = Items.tag("budding_blocks");
        public static final TagKey<Item> BUDS = Items.tag("buds");
        public static final TagKey<Item> CHAINS = Items.tag("chains");
        public static final TagKey<Item> CHESTS = Items.tag("chests");
        public static final TagKey<Item> CHESTS_ENDER = Items.tag("chests/ender");
        public static final TagKey<Item> CHESTS_TRAPPED = Items.tag("chests/trapped");
        public static final TagKey<Item> CHESTS_WOODEN = Items.tag("chests/wooden");
        public static final TagKey<Item> COBBLESTONES = Items.tag("cobblestones");
        public static final TagKey<Item> COBBLESTONES_NORMAL = Items.tag("cobblestones/normal");
        public static final TagKey<Item> COBBLESTONES_INFESTED = Items.tag("cobblestones/infested");
        public static final TagKey<Item> COBBLESTONES_MOSSY = Items.tag("cobblestones/mossy");
        public static final TagKey<Item> COBBLESTONES_DEEPSLATE = Items.tag("cobblestones/deepslate");
        public static final TagKey<Item> CONCRETES = Items.tag("concretes");
        public static final TagKey<Item> CONCRETE_POWDERS = Items.tag("concrete_powders");
        public static final TagKey<Item> CLUSTERS = Items.tag("clusters");
        public static final TagKey<Item> CLUMPS = Items.tag("clumps");
        public static final TagKey<Item> CLUMPS_RESIN = Items.tag("clumps/resin");
        public static final TagKey<Item> CROPS = Items.tag("crops");
        public static final TagKey<Item> CROPS_BEETROOT = Items.tag("crops/beetroot");
        public static final TagKey<Item> CROPS_CACTUS = Items.tag("crops/cactus");
        public static final TagKey<Item> CROPS_CARROT = Items.tag("crops/carrot");
        public static final TagKey<Item> CROPS_COCOA_BEAN = Items.tag("crops/cocoa_bean");
        public static final TagKey<Item> CROPS_MELON = Items.tag("crops/melon");
        public static final TagKey<Item> CROPS_NETHER_WART = Items.tag("crops/nether_wart");
        public static final TagKey<Item> CROPS_POTATO = Items.tag("crops/potato");
        public static final TagKey<Item> CROPS_PUMPKIN = Items.tag("crops/pumpkin");
        public static final TagKey<Item> CROPS_SUGAR_CANE = Items.tag("crops/sugar_cane");
        public static final TagKey<Item> CROPS_WHEAT = Items.tag("crops/wheat");
        public static final TagKey<Item> DRINKS = Items.tag("drinks");
        public static final TagKey<Item> DRINKS_WATER = Items.tag("drinks/water");
        public static final TagKey<Item> DRINKS_WATERY = Items.tag("drinks/watery");
        public static final TagKey<Item> DRINKS_MILK = Items.tag("drinks/milk");
        public static final TagKey<Item> DRINKS_HONEY = Items.tag("drinks/honey");
        public static final TagKey<Item> DRINKS_MAGIC = Items.tag("drinks/magic");
        public static final TagKey<Item> DRINKS_OMINOUS = Items.tag("drinks/ominous");
        public static final TagKey<Item> DRINKS_JUICE = Items.tag("drinks/juice");
        public static final TagKey<Item> DRINK_CONTAINING_BOTTLE = Items.tag("drink_containing/bottle");
        public static final TagKey<Item> DRINK_CONTAINING_BUCKET = Items.tag("drink_containing/bucket");
        public static final TagKey<Item> DUSTS = Items.tag("dusts");
        public static final TagKey<Item> DUSTS_REDSTONE = Items.tag("dusts/redstone");
        public static final TagKey<Item> DUSTS_GLOWSTONE = Items.tag("dusts/glowstone");
        public static final TagKey<Item> DYED = Items.tag("dyed");
        public static final TagKey<Item> DYED_BLACK = Items.tag("dyed/black");
        public static final TagKey<Item> DYED_BLUE = Items.tag("dyed/blue");
        public static final TagKey<Item> DYED_BROWN = Items.tag("dyed/brown");
        public static final TagKey<Item> DYED_CYAN = Items.tag("dyed/cyan");
        public static final TagKey<Item> DYED_GRAY = Items.tag("dyed/gray");
        public static final TagKey<Item> DYED_GREEN = Items.tag("dyed/green");
        public static final TagKey<Item> DYED_LIGHT_BLUE = Items.tag("dyed/light_blue");
        public static final TagKey<Item> DYED_LIGHT_GRAY = Items.tag("dyed/light_gray");
        public static final TagKey<Item> DYED_LIME = Items.tag("dyed/lime");
        public static final TagKey<Item> DYED_MAGENTA = Items.tag("dyed/magenta");
        public static final TagKey<Item> DYED_ORANGE = Items.tag("dyed/orange");
        public static final TagKey<Item> DYED_PINK = Items.tag("dyed/pink");
        public static final TagKey<Item> DYED_PURPLE = Items.tag("dyed/purple");
        public static final TagKey<Item> DYED_RED = Items.tag("dyed/red");
        public static final TagKey<Item> DYED_WHITE = Items.tag("dyed/white");
        public static final TagKey<Item> DYED_YELLOW = Items.tag("dyed/yellow");
        public static final TagKey<Item> DYES = Items.tag("dyes");
        public static final TagKey<Item> DYES_BLACK = DyeColor.BLACK.getTag();
        public static final TagKey<Item> DYES_RED = DyeColor.RED.getTag();
        public static final TagKey<Item> DYES_GREEN = DyeColor.GREEN.getTag();
        public static final TagKey<Item> DYES_BROWN = DyeColor.BROWN.getTag();
        public static final TagKey<Item> DYES_BLUE = DyeColor.BLUE.getTag();
        public static final TagKey<Item> DYES_PURPLE = DyeColor.PURPLE.getTag();
        public static final TagKey<Item> DYES_CYAN = DyeColor.CYAN.getTag();
        public static final TagKey<Item> DYES_LIGHT_GRAY = DyeColor.LIGHT_GRAY.getTag();
        public static final TagKey<Item> DYES_GRAY = DyeColor.GRAY.getTag();
        public static final TagKey<Item> DYES_PINK = DyeColor.PINK.getTag();
        public static final TagKey<Item> DYES_LIME = DyeColor.LIME.getTag();
        public static final TagKey<Item> DYES_YELLOW = DyeColor.YELLOW.getTag();
        public static final TagKey<Item> DYES_LIGHT_BLUE = DyeColor.LIGHT_BLUE.getTag();
        public static final TagKey<Item> DYES_MAGENTA = DyeColor.MAGENTA.getTag();
        public static final TagKey<Item> DYES_ORANGE = DyeColor.ORANGE.getTag();
        public static final TagKey<Item> DYES_WHITE = DyeColor.WHITE.getTag();
        public static final TagKey<Item> EGGS = Items.tag("eggs");
        public static final TagKey<Item> END_STONES = Items.tag("end_stones");
        public static final TagKey<Item> ENDER_PEARLS = Items.tag("ender_pearls");
        public static final TagKey<Item> FEATHERS = Items.tag("feathers");
        public static final TagKey<Item> FENCE_GATES = Items.tag("fence_gates");
        public static final TagKey<Item> FENCE_GATES_WOODEN = Items.tag("fence_gates/wooden");
        public static final TagKey<Item> FENCES = Items.tag("fences");
        public static final TagKey<Item> FENCES_NETHER_BRICK = Items.tag("fences/nether_brick");
        public static final TagKey<Item> FENCES_WOODEN = Items.tag("fences/wooden");
        public static final TagKey<Item> FERTILIZERS = Items.tag("fertilizers");
        public static final TagKey<Item> FLOWERS_SMALL = Items.tag("flowers/small");
        public static final TagKey<Item> FLOWERS_TALL = Items.tag("flowers/tall");
        public static final TagKey<Item> FLOWERS = Items.tag("flowers");
        public static final TagKey<Item> FOODS = Items.tag("foods");
        public static final TagKey<Item> FOODS_FRUIT = Items.tag("foods/fruit");
        public static final TagKey<Item> FOODS_VEGETABLE = Items.tag("foods/vegetable");
        public static final TagKey<Item> FOODS_BERRY = Items.tag("foods/berry");
        public static final TagKey<Item> FOODS_BREAD = Items.tag("foods/bread");
        public static final TagKey<Item> FOODS_COOKIE = Items.tag("foods/cookie");
        public static final TagKey<Item> FOODS_RAW_MEAT = Items.tag("foods/raw_meat");
        public static final TagKey<Item> FOODS_COOKED_MEAT = Items.tag("foods/cooked_meat");
        public static final TagKey<Item> FOODS_RAW_FISH = Items.tag("foods/raw_fish");
        public static final TagKey<Item> FOODS_COOKED_FISH = Items.tag("foods/cooked_fish");
        public static final TagKey<Item> FOODS_SOUP = Items.tag("foods/soup");
        public static final TagKey<Item> FOODS_CANDY = Items.tag("foods/candy");
        public static final TagKey<Item> FOODS_PIE = Items.tag("foods/pie");
        public static final TagKey<Item> FOODS_GOLDEN = Items.tag("foods/golden");
        public static final TagKey<Item> FOODS_EDIBLE_WHEN_PLACED = Items.tag("foods/edible_when_placed");
        public static final TagKey<Item> FOODS_FOOD_POISONING = Items.tag("foods/food_poisoning");
        public static final TagKey<Item> ANIMAL_FOODS = Items.tag("animal_foods");
        public static final TagKey<Item> GEMS = Items.tag("gems");
        public static final TagKey<Item> GEMS_DIAMOND = Items.tag("gems/diamond");
        public static final TagKey<Item> GEMS_EMERALD = Items.tag("gems/emerald");
        public static final TagKey<Item> GEMS_AMETHYST = Items.tag("gems/amethyst");
        public static final TagKey<Item> GEMS_LAPIS = Items.tag("gems/lapis");
        public static final TagKey<Item> GEMS_PRISMARINE = Items.tag("gems/prismarine");
        public static final TagKey<Item> GEMS_QUARTZ = Items.tag("gems/quartz");
        public static final TagKey<Item> GLASS_BLOCKS = Items.tag("glass_blocks");
        public static final TagKey<Item> GLASS_BLOCKS_COLORLESS = Items.tag("glass_blocks/colorless");
        public static final TagKey<Item> GLASS_BLOCKS_CHEAP = Items.tag("glass_blocks/cheap");
        public static final TagKey<Item> GLASS_BLOCKS_TINTED = Items.tag("glass_blocks/tinted");
        public static final TagKey<Item> GLASS_PANES = Items.tag("glass_panes");
        public static final TagKey<Item> GLASS_PANES_COLORLESS = Items.tag("glass_panes/colorless");
        public static final TagKey<Item> GLAZED_TERRACOTTAS = Items.tag("glazed_terracottas");
        public static final TagKey<Item> GRAVELS = Items.tag("gravels");
        public static final TagKey<Item> GUNPOWDERS = Items.tag("gunpowders");
        public static final TagKey<Item> HIDDEN_FROM_RECIPE_VIEWERS = Items.tag("hidden_from_recipe_viewers");
        public static final TagKey<Item> INGOTS = Items.tag("ingots");
        public static final TagKey<Item> INGOTS_COPPER = Items.tag("ingots/copper");
        public static final TagKey<Item> INGOTS_GOLD = Items.tag("ingots/gold");
        public static final TagKey<Item> INGOTS_IRON = Items.tag("ingots/iron");
        public static final TagKey<Item> INGOTS_NETHERITE = Items.tag("ingots/netherite");
        public static final TagKey<Item> LEATHERS = Items.tag("leathers");
        public static final TagKey<Item> MUSHROOMS = Items.tag("mushrooms");
        public static final TagKey<Item> MUSIC_DISCS = Items.tag("music_discs");
        public static final TagKey<Item> NETHER_STARS = Items.tag("nether_stars");
        public static final TagKey<Item> NETHERRACKS = Items.tag("netherracks");
        public static final TagKey<Item> NUGGETS = Items.tag("nuggets");
        public static final TagKey<Item> NUGGETS_GOLD = Items.tag("nuggets/gold");
        public static final TagKey<Item> NUGGETS_IRON = Items.tag("nuggets/iron");
        public static final TagKey<Item> NUGGETS_COPPER = Items.tag("nuggets/copper");
        public static final TagKey<Item> OBSIDIANS = Items.tag("obsidians");
        public static final TagKey<Item> OBSIDIANS_NORMAL = Items.tag("obsidians/normal");
        public static final TagKey<Item> OBSIDIANS_CRYING = Items.tag("obsidians/crying");
        public static final TagKey<Item> ORE_BEARING_GROUND_DEEPSLATE = Items.tag("ore_bearing_ground/deepslate");
        public static final TagKey<Item> ORE_BEARING_GROUND_NETHERRACK = Items.tag("ore_bearing_ground/netherrack");
        public static final TagKey<Item> ORE_BEARING_GROUND_STONE = Items.tag("ore_bearing_ground/stone");
        public static final TagKey<Item> ORE_RATES_DENSE = Items.tag("ore_rates/dense");
        public static final TagKey<Item> ORE_RATES_SINGULAR = Items.tag("ore_rates/singular");
        public static final TagKey<Item> ORE_RATES_SPARSE = Items.tag("ore_rates/sparse");
        public static final TagKey<Item> ORES = Items.tag("ores");
        public static final TagKey<Item> ORES_COAL = Items.tag("ores/coal");
        public static final TagKey<Item> ORES_COPPER = Items.tag("ores/copper");
        public static final TagKey<Item> ORES_DIAMOND = Items.tag("ores/diamond");
        public static final TagKey<Item> ORES_EMERALD = Items.tag("ores/emerald");
        public static final TagKey<Item> ORES_GOLD = Items.tag("ores/gold");
        public static final TagKey<Item> ORES_IRON = Items.tag("ores/iron");
        public static final TagKey<Item> ORES_LAPIS = Items.tag("ores/lapis");
        public static final TagKey<Item> ORES_NETHERITE_SCRAP = Items.tag("ores/netherite_scrap");
        public static final TagKey<Item> ORES_QUARTZ = Items.tag("ores/quartz");
        public static final TagKey<Item> ORES_REDSTONE = Items.tag("ores/redstone");
        public static final TagKey<Item> ORES_IN_GROUND_DEEPSLATE = Items.tag("ores_in_ground/deepslate");
        public static final TagKey<Item> ORES_IN_GROUND_NETHERRACK = Items.tag("ores_in_ground/netherrack");
        public static final TagKey<Item> ORES_IN_GROUND_STONE = Items.tag("ores_in_ground/stone");
        public static final TagKey<Item> PLAYER_WORKSTATIONS_CRAFTING_TABLES = Items.tag("player_workstations/crafting_tables");
        public static final TagKey<Item> PLAYER_WORKSTATIONS_FURNACES = Items.tag("player_workstations/furnaces");
        public static final TagKey<Item> POTIONS = Items.tag("potions");
        public static final TagKey<Item> POTIONS_BOTTLE = Items.tag("potions/bottle");
        public static final TagKey<Item> PUMPKINS = Items.tag("pumpkins");
        public static final TagKey<Item> PUMPKINS_NORMAL = Items.tag("pumpkins/normal");
        public static final TagKey<Item> PUMPKINS_CARVED = Items.tag("pumpkins/carved");
        public static final TagKey<Item> PUMPKINS_JACK_O_LANTERNS = Items.tag("pumpkins/jack_o_lanterns");
        public static final TagKey<Item> RAW_MATERIALS = Items.tag("raw_materials");
        public static final TagKey<Item> RAW_MATERIALS_COPPER = Items.tag("raw_materials/copper");
        public static final TagKey<Item> RAW_MATERIALS_GOLD = Items.tag("raw_materials/gold");
        public static final TagKey<Item> RAW_MATERIALS_IRON = Items.tag("raw_materials/iron");
        public static final TagKey<Item> RODS = Items.tag("rods");
        public static final TagKey<Item> RODS_BLAZE = Items.tag("rods/blaze");
        public static final TagKey<Item> RODS_BREEZE = Items.tag("rods/breeze");
        public static final TagKey<Item> RODS_WOODEN = Items.tag("rods/wooden");
        public static final TagKey<Item> ROPES = Items.tag("ropes");
        public static final TagKey<Item> SANDS = Items.tag("sands");
        public static final TagKey<Item> SANDS_COLORLESS = Items.tag("sands/colorless");
        public static final TagKey<Item> SANDS_RED = Items.tag("sands/red");
        public static final TagKey<Item> SANDSTONE_BLOCKS = Items.tag("sandstone/blocks");
        public static final TagKey<Item> SANDSTONE_SLABS = Items.tag("sandstone/slabs");
        public static final TagKey<Item> SANDSTONE_STAIRS = Items.tag("sandstone/stairs");
        public static final TagKey<Item> SANDSTONE_RED_BLOCKS = Items.tag("sandstone/red_blocks");
        public static final TagKey<Item> SANDSTONE_RED_SLABS = Items.tag("sandstone/red_slabs");
        public static final TagKey<Item> SANDSTONE_RED_STAIRS = Items.tag("sandstone/red_stairs");
        public static final TagKey<Item> SANDSTONE_UNCOLORED_BLOCKS = Items.tag("sandstone/uncolored_blocks");
        public static final TagKey<Item> SANDSTONE_UNCOLORED_SLABS = Items.tag("sandstone/uncolored_slabs");
        public static final TagKey<Item> SANDSTONE_UNCOLORED_STAIRS = Items.tag("sandstone/uncolored_stairs");
        public static final TagKey<Item> SEEDS = Items.tag("seeds");
        public static final TagKey<Item> SEEDS_BEETROOT = Items.tag("seeds/beetroot");
        public static final TagKey<Item> SEEDS_MELON = Items.tag("seeds/melon");
        public static final TagKey<Item> SEEDS_PUMPKIN = Items.tag("seeds/pumpkin");
        public static final TagKey<Item> SEEDS_TORCHFLOWER = Items.tag("seeds/torchflower");
        public static final TagKey<Item> SEEDS_PITCHER_PLANT = Items.tag("seeds/pitcher_plant");
        public static final TagKey<Item> SEEDS_WHEAT = Items.tag("seeds/wheat");
        public static final TagKey<Item> SHULKER_BOXES = Items.tag("shulker_boxes");
        public static final TagKey<Item> SLIME_BALLS = Items.tag("slime_balls");
        public static final TagKey<Item> STONES = Items.tag("stones");
        public static final TagKey<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
        public static final TagKey<Item> STORAGE_BLOCKS_BONE_MEAL = Items.tag("storage_blocks/bone_meal");
        public static final TagKey<Item> STORAGE_BLOCKS_COAL = Items.tag("storage_blocks/coal");
        public static final TagKey<Item> STORAGE_BLOCKS_COPPER = Items.tag("storage_blocks/copper");
        public static final TagKey<Item> STORAGE_BLOCKS_DIAMOND = Items.tag("storage_blocks/diamond");
        public static final TagKey<Item> STORAGE_BLOCKS_DRIED_KELP = Items.tag("storage_blocks/dried_kelp");
        public static final TagKey<Item> STORAGE_BLOCKS_EMERALD = Items.tag("storage_blocks/emerald");
        public static final TagKey<Item> STORAGE_BLOCKS_GOLD = Items.tag("storage_blocks/gold");
        public static final TagKey<Item> STORAGE_BLOCKS_IRON = Items.tag("storage_blocks/iron");
        public static final TagKey<Item> STORAGE_BLOCKS_LAPIS = Items.tag("storage_blocks/lapis");
        public static final TagKey<Item> STORAGE_BLOCKS_NETHERITE = Items.tag("storage_blocks/netherite");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_COPPER = Items.tag("storage_blocks/raw_copper");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_GOLD = Items.tag("storage_blocks/raw_gold");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_IRON = Items.tag("storage_blocks/raw_iron");
        public static final TagKey<Item> STORAGE_BLOCKS_REDSTONE = Items.tag("storage_blocks/redstone");
        public static final TagKey<Item> STORAGE_BLOCKS_RESIN = Items.tag("storage_blocks/resin");
        public static final TagKey<Item> STORAGE_BLOCKS_SLIME = Items.tag("storage_blocks/slime");
        public static final TagKey<Item> STORAGE_BLOCKS_WHEAT = Items.tag("storage_blocks/wheat");
        public static final TagKey<Item> STRINGS = Items.tag("strings");
        public static final TagKey<Item> STRIPPED_LOGS = Items.tag("stripped_logs");
        public static final TagKey<Item> STRIPPED_WOODS = Items.tag("stripped_woods");
        public static final TagKey<Item> VILLAGER_JOB_SITES = Items.tag("villager_job_sites");
        public static final TagKey<Item> TOOLS = Items.tag("tools");
        public static final TagKey<Item> TOOLS_SHIELD = Items.tag("tools/shield");
        public static final TagKey<Item> TOOLS_BOW = Items.tag("tools/bow");
        public static final TagKey<Item> TOOLS_CROSSBOW = Items.tag("tools/crossbow");
        public static final TagKey<Item> TOOLS_FISHING_ROD = Items.tag("tools/fishing_rod");
        public static final TagKey<Item> TOOLS_SPEAR = Items.tag("tools/spear");
        public static final TagKey<Item> TOOLS_SHEAR = Items.tag("tools/shear");
        public static final TagKey<Item> TOOLS_BRUSH = Items.tag("tools/brush");
        public static final TagKey<Item> TOOLS_IGNITER = Items.tag("tools/igniter");
        public static final TagKey<Item> TOOLS_MACE = Items.tag("tools/mace");
        public static final TagKey<Item> TOOLS_WRENCH = Items.tag("tools/wrench");
        public static final TagKey<Item> MELEE_WEAPON_TOOLS = Items.tag("tools/melee_weapon");
        public static final TagKey<Item> RANGED_WEAPON_TOOLS = Items.tag("tools/ranged_weapon");
        public static final TagKey<Item> MINING_TOOL_TOOLS = Items.tag("tools/mining_tool");
        public static final TagKey<Item> ARMORS = Items.tag("armors");
        public static final TagKey<Item> ENCHANTABLES = Items.tag("enchantables");

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Item> neoforgeTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)name));
        }
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> BOSSES = EntityTypes.tag("bosses");
        public static final TagKey<EntityType<?>> MINECARTS = EntityTypes.tag("minecarts");
        public static final TagKey<EntityType<?>> BOATS = EntityTypes.tag("boats");
        public static final TagKey<EntityType<?>> CAPTURING_NOT_SUPPORTED = EntityTypes.tag("capturing_not_supported");
        public static final TagKey<EntityType<?>> TELEPORTING_NOT_SUPPORTED = EntityTypes.tag("teleporting_not_supported");

        private static TagKey<EntityType<?>> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> ENDERMAN_PLACE_ON_BLACKLIST = Blocks.neoforgeTag("enderman_place_on_blacklist");
        public static final TagKey<Block> NEEDS_WOOD_TOOL = Blocks.neoforgeTag("needs_wood_tool");
        public static final TagKey<Block> NEEDS_GOLD_TOOL = Blocks.neoforgeTag("needs_gold_tool");
        public static final TagKey<Block> NEEDS_NETHERITE_TOOL = Blocks.neoforgeTag("needs_netherite_tool");
        public static final TagKey<Block> BARRELS = Blocks.tag("barrels");
        public static final TagKey<Block> BARRELS_WOODEN = Blocks.tag("barrels/wooden");
        public static final TagKey<Block> BOOKSHELVES = Blocks.tag("bookshelves");
        public static final TagKey<Block> BUDDING_BLOCKS = Blocks.tag("budding_blocks");
        public static final TagKey<Block> BUDS = Blocks.tag("buds");
        public static final TagKey<Block> CHAINS = Blocks.tag("chains");
        public static final TagKey<Block> CHESTS = Blocks.tag("chests");
        public static final TagKey<Block> CHESTS_ENDER = Blocks.tag("chests/ender");
        public static final TagKey<Block> CHESTS_TRAPPED = Blocks.tag("chests/trapped");
        public static final TagKey<Block> CHESTS_WOODEN = Blocks.tag("chests/wooden");
        public static final TagKey<Block> CLUSTERS = Blocks.tag("clusters");
        public static final TagKey<Block> COBBLESTONES = Blocks.tag("cobblestones");
        public static final TagKey<Block> COBBLESTONES_NORMAL = Blocks.tag("cobblestones/normal");
        public static final TagKey<Block> COBBLESTONES_INFESTED = Blocks.tag("cobblestones/infested");
        public static final TagKey<Block> COBBLESTONES_MOSSY = Blocks.tag("cobblestones/mossy");
        public static final TagKey<Block> COBBLESTONES_DEEPSLATE = Blocks.tag("cobblestones/deepslate");
        public static final TagKey<Block> CONCRETES = Blocks.tag("concretes");
        public static final TagKey<Block> DYED = Blocks.tag("dyed");
        public static final TagKey<Block> DYED_BLACK = Blocks.tag("dyed/black");
        public static final TagKey<Block> DYED_BLUE = Blocks.tag("dyed/blue");
        public static final TagKey<Block> DYED_BROWN = Blocks.tag("dyed/brown");
        public static final TagKey<Block> DYED_CYAN = Blocks.tag("dyed/cyan");
        public static final TagKey<Block> DYED_GRAY = Blocks.tag("dyed/gray");
        public static final TagKey<Block> DYED_GREEN = Blocks.tag("dyed/green");
        public static final TagKey<Block> DYED_LIGHT_BLUE = Blocks.tag("dyed/light_blue");
        public static final TagKey<Block> DYED_LIGHT_GRAY = Blocks.tag("dyed/light_gray");
        public static final TagKey<Block> DYED_LIME = Blocks.tag("dyed/lime");
        public static final TagKey<Block> DYED_MAGENTA = Blocks.tag("dyed/magenta");
        public static final TagKey<Block> DYED_ORANGE = Blocks.tag("dyed/orange");
        public static final TagKey<Block> DYED_PINK = Blocks.tag("dyed/pink");
        public static final TagKey<Block> DYED_PURPLE = Blocks.tag("dyed/purple");
        public static final TagKey<Block> DYED_RED = Blocks.tag("dyed/red");
        public static final TagKey<Block> DYED_WHITE = Blocks.tag("dyed/white");
        public static final TagKey<Block> DYED_YELLOW = Blocks.tag("dyed/yellow");
        public static final TagKey<Block> END_STONES = Blocks.tag("end_stones");
        public static final TagKey<Block> FENCE_GATES = Blocks.tag("fence_gates");
        public static final TagKey<Block> FENCE_GATES_WOODEN = Blocks.tag("fence_gates/wooden");
        public static final TagKey<Block> FENCES = Blocks.tag("fences");
        public static final TagKey<Block> FENCES_NETHER_BRICK = Blocks.tag("fences/nether_brick");
        public static final TagKey<Block> FENCES_WOODEN = Blocks.tag("fences/wooden");
        public static final TagKey<Block> FLOWERS_SMALL = Blocks.tag("flowers/small");
        public static final TagKey<Block> FLOWERS_TALL = Blocks.tag("flowers/tall");
        public static final TagKey<Block> FLOWERS = Blocks.tag("flowers");
        public static final TagKey<Block> GLASS_BLOCKS = Blocks.tag("glass_blocks");
        public static final TagKey<Block> GLASS_BLOCKS_COLORLESS = Blocks.tag("glass_blocks/colorless");
        public static final TagKey<Block> GLASS_BLOCKS_CHEAP = Blocks.tag("glass_blocks/cheap");
        public static final TagKey<Block> GLASS_BLOCKS_TINTED = Blocks.tag("glass_blocks/tinted");
        public static final TagKey<Block> GLASS_PANES = Blocks.tag("glass_panes");
        public static final TagKey<Block> GLASS_PANES_COLORLESS = Blocks.tag("glass_panes/colorless");
        public static final TagKey<Block> GLAZED_TERRACOTTAS = Blocks.tag("glazed_terracottas");
        public static final TagKey<Block> GRAVELS = Blocks.tag("gravels");
        public static final TagKey<Block> HIDDEN_FROM_RECIPE_VIEWERS = Blocks.tag("hidden_from_recipe_viewers");
        public static final TagKey<Block> NETHERRACKS = Blocks.tag("netherracks");
        public static final TagKey<Block> OBSIDIANS = Blocks.tag("obsidians");
        public static final TagKey<Block> OBSIDIANS_NORMAL = Blocks.tag("obsidians/normal");
        public static final TagKey<Block> OBSIDIANS_CRYING = Blocks.tag("obsidians/crying");
        public static final TagKey<Block> ORE_BEARING_GROUND_DEEPSLATE = Blocks.tag("ore_bearing_ground/deepslate");
        public static final TagKey<Block> ORE_BEARING_GROUND_NETHERRACK = Blocks.tag("ore_bearing_ground/netherrack");
        public static final TagKey<Block> ORE_BEARING_GROUND_STONE = Blocks.tag("ore_bearing_ground/stone");
        public static final TagKey<Block> ORE_RATES_DENSE = Blocks.tag("ore_rates/dense");
        public static final TagKey<Block> ORE_RATES_SINGULAR = Blocks.tag("ore_rates/singular");
        public static final TagKey<Block> ORE_RATES_SPARSE = Blocks.tag("ore_rates/sparse");
        public static final TagKey<Block> ORES = Blocks.tag("ores");
        public static final TagKey<Block> ORES_COAL = Blocks.tag("ores/coal");
        public static final TagKey<Block> ORES_COPPER = Blocks.tag("ores/copper");
        public static final TagKey<Block> ORES_DIAMOND = Blocks.tag("ores/diamond");
        public static final TagKey<Block> ORES_EMERALD = Blocks.tag("ores/emerald");
        public static final TagKey<Block> ORES_GOLD = Blocks.tag("ores/gold");
        public static final TagKey<Block> ORES_IRON = Blocks.tag("ores/iron");
        public static final TagKey<Block> ORES_LAPIS = Blocks.tag("ores/lapis");
        public static final TagKey<Block> ORES_NETHERITE_SCRAP = Blocks.tag("ores/netherite_scrap");
        public static final TagKey<Block> ORES_QUARTZ = Blocks.tag("ores/quartz");
        public static final TagKey<Block> ORES_REDSTONE = Blocks.tag("ores/redstone");
        public static final TagKey<Block> ORES_IN_GROUND_DEEPSLATE = Blocks.tag("ores_in_ground/deepslate");
        public static final TagKey<Block> ORES_IN_GROUND_NETHERRACK = Blocks.tag("ores_in_ground/netherrack");
        public static final TagKey<Block> ORES_IN_GROUND_STONE = Blocks.tag("ores_in_ground/stone");
        public static final TagKey<Block> PUMPKINS = Blocks.tag("pumpkins");
        public static final TagKey<Block> PUMPKINS_NORMAL = Blocks.tag("pumpkins/normal");
        public static final TagKey<Block> PUMPKINS_CARVED = Blocks.tag("pumpkins/carved");
        public static final TagKey<Block> PUMPKINS_JACK_O_LANTERNS = Blocks.tag("pumpkins/jack_o_lanterns");
        public static final TagKey<Block> PLAYER_WORKSTATIONS_CRAFTING_TABLES = Blocks.tag("player_workstations/crafting_tables");
        public static final TagKey<Block> PLAYER_WORKSTATIONS_FURNACES = Blocks.tag("player_workstations/furnaces");
        public static final TagKey<Block> RELOCATION_NOT_SUPPORTED = Blocks.tag("relocation_not_supported");
        public static final TagKey<Block> ROPES = Blocks.tag("ropes");
        public static final TagKey<Block> SANDS = Blocks.tag("sands");
        public static final TagKey<Block> SANDS_COLORLESS = Blocks.tag("sands/colorless");
        public static final TagKey<Block> SANDS_RED = Blocks.tag("sands/red");
        public static final TagKey<Block> SANDSTONE_BLOCKS = Blocks.tag("sandstone/blocks");
        public static final TagKey<Block> SANDSTONE_SLABS = Blocks.tag("sandstone/slabs");
        public static final TagKey<Block> SANDSTONE_STAIRS = Blocks.tag("sandstone/stairs");
        public static final TagKey<Block> SANDSTONE_RED_BLOCKS = Blocks.tag("sandstone/red_blocks");
        public static final TagKey<Block> SANDSTONE_RED_SLABS = Blocks.tag("sandstone/red_slabs");
        public static final TagKey<Block> SANDSTONE_RED_STAIRS = Blocks.tag("sandstone/red_stairs");
        public static final TagKey<Block> SANDSTONE_UNCOLORED_BLOCKS = Blocks.tag("sandstone/uncolored_blocks");
        public static final TagKey<Block> SANDSTONE_UNCOLORED_SLABS = Blocks.tag("sandstone/uncolored_slabs");
        public static final TagKey<Block> SANDSTONE_UNCOLORED_STAIRS = Blocks.tag("sandstone/uncolored_stairs");
        public static final TagKey<Block> SKULLS = Blocks.tag("skulls");
        public static final TagKey<Block> STONES = Blocks.tag("stones");
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.tag("storage_blocks");
        public static final TagKey<Block> STORAGE_BLOCKS_BONE_MEAL = Blocks.tag("storage_blocks/bone_meal");
        public static final TagKey<Block> STORAGE_BLOCKS_COAL = Blocks.tag("storage_blocks/coal");
        public static final TagKey<Block> STORAGE_BLOCKS_COPPER = Blocks.tag("storage_blocks/copper");
        public static final TagKey<Block> STORAGE_BLOCKS_DIAMOND = Blocks.tag("storage_blocks/diamond");
        public static final TagKey<Block> STORAGE_BLOCKS_DRIED_KELP = Blocks.tag("storage_blocks/dried_kelp");
        public static final TagKey<Block> STORAGE_BLOCKS_EMERALD = Blocks.tag("storage_blocks/emerald");
        public static final TagKey<Block> STORAGE_BLOCKS_GOLD = Blocks.tag("storage_blocks/gold");
        public static final TagKey<Block> STORAGE_BLOCKS_IRON = Blocks.tag("storage_blocks/iron");
        public static final TagKey<Block> STORAGE_BLOCKS_LAPIS = Blocks.tag("storage_blocks/lapis");
        public static final TagKey<Block> STORAGE_BLOCKS_NETHERITE = Blocks.tag("storage_blocks/netherite");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_COPPER = Blocks.tag("storage_blocks/raw_copper");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_GOLD = Blocks.tag("storage_blocks/raw_gold");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_IRON = Blocks.tag("storage_blocks/raw_iron");
        public static final TagKey<Block> STORAGE_BLOCKS_REDSTONE = Blocks.tag("storage_blocks/redstone");
        public static final TagKey<Block> STORAGE_BLOCKS_RESIN = Blocks.tag("storage_blocks/resin");
        public static final TagKey<Block> STORAGE_BLOCKS_SLIME = Blocks.tag("storage_blocks/slime");
        public static final TagKey<Block> STORAGE_BLOCKS_WHEAT = Blocks.tag("storage_blocks/wheat");
        public static final TagKey<Block> STRIPPED_LOGS = Blocks.tag("stripped_logs");
        public static final TagKey<Block> STRIPPED_WOODS = Blocks.tag("stripped_woods");
        public static final TagKey<Block> VILLAGER_JOB_SITES = Blocks.tag("villager_job_sites");
        public static final TagKey<Block> VILLAGER_FARMLANDS = Blocks.neoforgeTag("villager_farmlands");

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Block> neoforgeTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)name));
        }
    }
}

