/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package net.neoforged.neoforge.common.extensions;

import java.util.List;
import net.minecraft.data.loot.LootTableSubProvider;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.ConditionalLootTableSubProvider;

public interface LootTableSubProviderExtension {
    /**
     * Builds a wrapper around this provider that adds the provided conditions to all loot tables generated by this provider.
     */
    default LootTableSubProvider withConditions(List<ICondition> conditions) {
        return conditions.isEmpty() ? self() : new ConditionalLootTableSubProvider(self(), conditions);
    }

    private LootTableSubProvider self() {
        return (LootTableSubProvider) this;
    }
}
