/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer;

import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class EmptyResourceHandler<T extends Resource>
implements ResourceHandler<T> {
    private static final EmptyResourceHandler<?> INSTANCE = new EmptyResourceHandler();

    public static <T extends Resource> EmptyResourceHandler<T> instance() {
        return INSTANCE;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int insert(int index, T resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public int extract(int index, T resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public T getResource(int index) {
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public long getAmountAsLong(int index) {
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public long getCapacityAsLong(int index, T resource) {
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public boolean isValid(int index, T resource) {
        throw new IndexOutOfBoundsException(index);
    }

    public String toString() {
        return "EmptyResourceHandler";
    }

    private EmptyResourceHandler() {
    }
}

