/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.server.command.ModIdArgument;

public class ClientConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"config").then(ShowFile.register()));
    }

    public static class ShowFile {
        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"showfileclient").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"mod", (ArgumentType)ModIdArgument.modIdArgument()).executes(ShowFile::showFile));
        }

        private static int showFile(CommandContext<CommandSourceStack> context) {
            String modId = (String)context.getArgument("mod", String.class);
            ModConfig.Type type = ModConfig.Type.CLIENT;
            List configFileNames = ModConfigs.getConfigFileNames((String)modId, (ModConfig.Type)type);
            for (String configFileName : configFileNames) {
                File f = new File(configFileName);
                MutableComponent fileComponent = Component.literal((String)f.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath())));
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.config.getwithtype", (Object[])new Object[]{modId, type.toString(), fileComponent}), true);
            }
            if (configFileNames.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.config.noconfig", (Object[])new Object[]{modId, type.toString()}), true);
            }
            return 0;
        }
    }
}

