/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.NeoForgeEventHandler;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifierManager;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.DifficultyChangeEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.ModMismatchEvent;
import net.neoforged.neoforge.event.RegisterStructureConversionsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDrownEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingSwapItemsEvent;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEnchantItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.SweepAttackEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CommonHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker WORLDPERSISTENCE = MarkerManager.getMarker((String)"WP");
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static ThreadLocal<Player> craftingPlayer = new ThreadLocal();
    public static final int VANILLA_SERIALIZER_LIMIT = 256;
    private static final Set<String> VANILLA_DIMS = Sets.newHashSet((Object[])new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
    private static final String DIMENSIONS_KEY = "dimensions";
    private static final String SEED_KEY = "seed";
    private static final Map<EntityType<? extends LivingEntity>, AttributeSupplier> FORGE_ATTRIBUTES = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier>();
    private static final Lazy<Map<String, StructuresBecomeConfiguredFix.Conversion>> FORGE_CONVERSION_MAP = Lazy.of(() -> {
        HashMap<String, StructuresBecomeConfiguredFix.Conversion> map = new HashMap<String, StructuresBecomeConfiguredFix.Conversion>();
        NeoForge.EVENT_BUS.post((Event)new RegisterStructureConversionsEvent(map));
        return ImmutableMap.copyOf(map);
    });
    private static final Set<Class<?>> checkedComponentClasses = ConcurrentHashMap.newKeySet();

    public static boolean canContinueUsing(ItemStack from, ItemStack to) {
        if (!from.isEmpty() && !to.isEmpty()) {
            return from.getItem().canContinueUsing(from, to);
        }
        return false;
    }

    public static boolean onItemStackedOn(ItemStack carriedItem, ItemStack stackedOnItem, Slot slot, ClickAction action, Player player, SlotAccess carriedSlotAccess) {
        return ((ItemStackedOnOtherEvent)NeoForge.EVENT_BUS.post((Event)new ItemStackedOnOtherEvent(carriedItem, stackedOnItem, slot, action, player, carriedSlotAccess))).isCanceled();
    }

    public static void onDifficultyChange(Difficulty difficulty, Difficulty oldDifficulty) {
        NeoForge.EVENT_BUS.post((Event)new DifficultyChangeEvent(difficulty, oldDifficulty));
    }

    public static LivingChangeTargetEvent onLivingChangeTarget(LivingEntity entity, @Nullable LivingEntity originalTarget, LivingChangeTargetEvent.ILivingTargetType targetType) {
        LivingChangeTargetEvent event = new LivingChangeTargetEvent(entity, originalTarget, targetType);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean isEntityInvulnerableTo(Entity entity, DamageSource source, boolean isInvul) {
        return ((EntityInvulnerabilityCheckEvent)NeoForge.EVENT_BUS.post((Event)new EntityInvulnerabilityCheckEvent(entity, source, isInvul))).isInvulnerable();
    }

    public static boolean onEntityIncomingDamage(LivingEntity entity, DamageContainer container) {
        return ((LivingIncomingDamageEvent)NeoForge.EVENT_BUS.post((Event)new LivingIncomingDamageEvent(entity, container))).isCanceled();
    }

    public static LivingKnockBackEvent onLivingKnockBack(LivingEntity target, float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = new LivingKnockBackEvent(target, strength, ratioX, ratioZ);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean onLivingUseTotem(LivingEntity entity, DamageSource damageSource, ItemStack totem, InteractionHand hand) {
        return !((LivingUseTotemEvent)NeoForge.EVENT_BUS.post((Event)new LivingUseTotemEvent(entity, damageSource, totem, hand))).isCanceled();
    }

    public static float onLivingDamagePre(LivingEntity entity, DamageContainer container) {
        return ((LivingDamageEvent.Pre)NeoForge.EVENT_BUS.post((Event)new LivingDamageEvent.Pre(entity, container))).getNewDamage();
    }

    public static void onLivingDamagePost(LivingEntity entity, DamageContainer container) {
        NeoForge.EVENT_BUS.post((Event)new LivingDamageEvent.Post(entity, container));
    }

    public static void onArmorHurt(DamageSource source, EquipmentSlot[] slots, float damage, LivingEntity armoredEntity) {
        EnumMap<EquipmentSlot, ArmorHurtEvent.ArmorEntry> armorMap = new EnumMap<EquipmentSlot, ArmorHurtEvent.ArmorEntry>(EquipmentSlot.class);
        for (EquipmentSlot slot2 : slots) {
            ItemStack armorPiece = armoredEntity.getItemBySlot(slot2);
            if (armorPiece.isEmpty()) continue;
            float damageAfterFireResist = armorPiece.getItem() instanceof ArmorItem && armorPiece.canBeHurtBy(source) ? damage : 0.0f;
            armorMap.put(slot2, new ArmorHurtEvent.ArmorEntry(armorPiece, damageAfterFireResist));
        }
        ArmorHurtEvent event = (ArmorHurtEvent)NeoForge.EVENT_BUS.post((Event)new ArmorHurtEvent(armorMap, armoredEntity));
        if (event.isCanceled()) {
            return;
        }
        event.getArmorMap().forEach((slot, entry) -> entry.armorItemStack.hurtAndBreak((int)entry.newDamage, armoredEntity, slot));
    }

    public static boolean onLivingDeath(LivingEntity entity, DamageSource src) {
        return ((LivingDeathEvent)NeoForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src))).isCanceled();
    }

    public static boolean onLivingDrops(LivingEntity entity, DamageSource source, Collection<ItemEntity> drops, boolean recentlyHit) {
        return ((LivingDropsEvent)NeoForge.EVENT_BUS.post((Event)new LivingDropsEvent(entity, source, drops, recentlyHit))).isCanceled();
    }

    @Nullable
    public static float[] onLivingFall(LivingEntity entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (((LivingFallEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static double getEntityVisibilityMultiplier(LivingEntity entity, Entity lookingEntity, double originalMultiplier) {
        LivingEvent.LivingVisibilityEvent event = new LivingEvent.LivingVisibilityEvent(entity, lookingEntity, originalMultiplier);
        NeoForge.EVENT_BUS.post((Event)event);
        return Math.max(0.0, event.getVisibilityModifier());
    }

    public static Optional<BlockPos> isLivingOnLadder(BlockState state, Level level, BlockPos pos, LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof Player && entity.isSpectator();
        if (isSpectator) {
            return Optional.empty();
        }
        if (!((Boolean)NeoForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return state.isLadder((LevelReader)level, pos, entity) ? Optional.of(pos) : Optional.empty();
        }
        AABB bb = entity.getBoundingBox();
        int mX = Mth.floor((double)bb.minX);
        int mY = Mth.floor((double)bb.minY);
        int mZ = Mth.floor((double)bb.minZ);
        int y2 = mY;
        while ((double)y2 < bb.maxY) {
            int x2 = mX;
            while ((double)x2 < bb.maxX) {
                int z2 = mZ;
                while ((double)z2 < bb.maxZ) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    state = level.getBlockState(tmp);
                    if (state.isLadder((LevelReader)level, tmp, entity)) {
                        return Optional.of(tmp);
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return Optional.empty();
    }

    public static void onLivingJump(LivingEntity entity) {
        NeoForge.EVENT_BUS.post((Event)new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static ItemEntity onPlayerTossEvent(Player player, ItemStack item, boolean includeName) {
        player.captureDrops((Collection)Lists.newArrayList());
        ItemEntity ret = player.drop(item, false, includeName);
        player.captureDrops(null);
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (((ItemTossEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return null;
        }
        if (!player.level().isClientSide) {
            player.getCommandSenderWorld().addFreshEntity((Entity)event.getEntity());
        }
        return event.getEntity();
    }

    public static boolean onVanillaGameEvent(Level level, Holder<GameEvent> vanillaEvent, Vec3 pos, GameEvent.Context context) {
        return !((VanillaGameEvent)NeoForge.EVENT_BUS.post((Event)new VanillaGameEvent(level, vanillaEvent, pos, context))).isCanceled();
    }

    private static String getRawText(Component message) {
        String string;
        ComponentContents componentContents = message.getContents();
        if (componentContents instanceof PlainTextContents) {
            PlainTextContents plainTextContents = (PlainTextContents)componentContents;
            string = plainTextContents.text();
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    public static Component onServerChatSubmittedEvent(ServerPlayer player, String plain, Component decorated) {
        ServerChatEvent event = new ServerChatEvent(player, plain, decorated);
        return ((ServerChatEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    public static ChatDecorator getServerChatSubmittedDecorator() {
        return (sender, message) -> {
            if (sender == null) {
                return message;
            }
            return CommonHooks.onServerChatSubmittedEvent(sender, CommonHooks.getRawText(message), message);
        };
    }

    public static Component newChatWithLinks(String string) {
        return CommonHooks.newChatWithLinks(string, true);
    }

    public static Component newChatWithLinks(String string, boolean allowMissingHeader) {
        MutableComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            MutableComponent link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = Component.literal((String)part);
                    } else {
                        ichat.append(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = Component.literal((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = Component.literal((String)url);
                            continue;
                        }
                        ichat.append((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = Component.literal((String)url);
                        continue;
                    }
                    ichat.append((String)url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url);
            link.setStyle(link.getStyle().withClickEvent(click).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
            if (ichat == null) {
                ichat = Component.literal((String)"");
            }
            ichat.append((Component)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = Component.literal((String)end);
        } else if (end.length() > 0) {
            ichat.append((Component)Component.literal((String)string.substring(lastEnd)));
        }
        return ichat;
    }

    public static void handleBlockDrops(ServerLevel level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, List<ItemEntity> drops, @Nullable Entity breaker, ItemStack tool) {
        BlockDropsEvent event = new BlockDropsEvent(level, pos, state, blockEntity, drops, breaker, tool);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            for (ItemEntity entity : event.getDrops()) {
                level.addFreshEntity((Entity)entity);
            }
            state.spawnAfterBreak(level, pos, tool, false);
            if (event.getDroppedExperience() > 0) {
                state.getBlock().popExperience(level, pos, event.getDroppedExperience());
            }
        }
    }

    public static BlockEvent.BreakEvent fireBlockBreak(Level level, GameType gameType, ServerPlayer player, BlockPos pos, BlockState state) {
        boolean preCancelEvent = false;
        ItemStack itemstack = player.getMainHandItem();
        if (!itemstack.isEmpty() && !itemstack.getItem().canAttackBlock(state, level, pos, (Player)player)) {
            preCancelEvent = true;
        }
        if (player.blockActionRestricted(level, pos, gameType)) {
            preCancelEvent = true;
        }
        if (state.getBlock() instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            preCancelEvent = true;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)player);
        event.setCanceled(preCancelEvent);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            player.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, state));
        }
        return event;
    }

    public static InteractionResult onPlaceItemIntoWorld(UseOnContext context) {
        AdventureModePredicate adventureModePredicate;
        ItemStack itemstack = context.getItemInHand();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (!(player == null || player.getAbilities().mayBuild || (adventureModePredicate = (AdventureModePredicate)itemstack.get(DataComponents.CAN_PLACE_ON)) != null && adventureModePredicate.test(new BlockInWorld((LevelReader)level, context.getClickedPos(), false)))) {
            return InteractionResult.PASS;
        }
        Item item = itemstack.getItem();
        int size = itemstack.getCount();
        DataComponentMap components = itemstack.getComponents();
        if (!(itemstack.getItem() instanceof BucketItem)) {
            level.captureBlockSnapshots = true;
        }
        ItemStack copy = itemstack.copy();
        InteractionResult ret = itemstack.getItem().useOn(context);
        if (itemstack.isEmpty()) {
            EventHooks.onPlayerDestroyItem(player, copy, context.getHand());
        }
        level.captureBlockSnapshots = false;
        if (ret.consumesAction()) {
            int newSize = itemstack.getCount();
            DataComponentMap newComponents = itemstack.getComponents();
            List blockSnapshots = (List)level.capturedBlockSnapshots.clone();
            level.capturedBlockSnapshots.clear();
            itemstack.setCount(size);
            itemstack.applyComponents(components);
            Direction side = context.getClickedFace();
            boolean eventResult = false;
            if (blockSnapshots.size() > 1) {
                eventResult = EventHooks.onMultiBlockPlace((Entity)player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                eventResult = EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshots.get(0), side);
            }
            if (eventResult) {
                ret = InteractionResult.FAIL;
                for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                    level.restoringBlockSnapshots = true;
                    blocksnapshot.restore(blocksnapshot.getFlags() | 2);
                    level.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.setCount(newSize);
                itemstack.applyComponents(newComponents);
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlags();
                    BlockState oldBlock = snap.getState();
                    BlockState newBlock = level.getBlockState(snap.getPos());
                    newBlock.onPlace(level, snap.getPos(), oldBlock, false);
                    level.markAndNotifyBlock(snap.getPos(), level.getChunkAt(snap.getPos()), oldBlock, newBlock, updateFlag, 512);
                }
                if (player != null) {
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                }
            }
        }
        level.capturedBlockSnapshots.clear();
        return ret;
    }

    public static void onPlayerEnchantItem(Player player, ItemStack stack, List<EnchantmentInstance> instances) {
        NeoForge.EVENT_BUS.post((Event)new PlayerEnchantItemEvent(player, stack, instances));
    }

    public static boolean onAnvilChange(AnvilMenu container, ItemStack left, ItemStack right, Container outputSlot, String name, long baseCost, Player player) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost, player);
        if (((AnvilUpdateEvent)NeoForge.EVENT_BUS.post((Event)e)).isCanceled()) {
            outputSlot.setItem(0, ItemStack.EMPTY);
            container.setMaximumCost(0L);
            container.repairItemCountCost = 0;
            return false;
        }
        if (e.getOutput().isEmpty()) {
            return true;
        }
        outputSlot.setItem(0, e.getOutput());
        container.setMaximumCost(e.getCost());
        container.repairItemCountCost = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(Player player, ItemStack output, ItemStack left, ItemStack right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        NeoForge.EVENT_BUS.post((Event)e);
        return e.getBreakChance();
    }

    public static int onGrindstoneChange(ItemStack top, ItemStack bottom, Container outputSlot, int xp) {
        GrindstoneEvent.OnPlaceItem e = new GrindstoneEvent.OnPlaceItem(top, bottom, xp);
        if (((GrindstoneEvent.OnPlaceItem)NeoForge.EVENT_BUS.post((Event)e)).isCanceled()) {
            outputSlot.setItem(0, ItemStack.EMPTY);
            return -1;
        }
        if (e.getOutput().isEmpty()) {
            return Integer.MIN_VALUE;
        }
        outputSlot.setItem(0, e.getOutput());
        return e.getXp();
    }

    public static boolean onGrindstoneTake(Container inputSlots, ContainerLevelAccess access, Function<Level, Integer> xpFunction) {
        access.execute((l, p) -> {
            int xp = (Integer)xpFunction.apply((Level)l);
            GrindstoneEvent.OnTakeItem e = new GrindstoneEvent.OnTakeItem(inputSlots.getItem(0), inputSlots.getItem(1), xp);
            if (((GrindstoneEvent.OnTakeItem)NeoForge.EVENT_BUS.post((Event)e)).isCanceled()) {
                return;
            }
            if (l instanceof ServerLevel) {
                ExperienceOrb.award((ServerLevel)((ServerLevel)l), (Vec3)Vec3.atCenterOf((Vec3i)p), (int)e.getXp());
            }
            l.levelEvent(1042, p, 0);
            inputSlots.setItem(0, e.getNewTopItem());
            inputSlots.setItem(1, e.getNewBottomItem());
            inputSlots.setChanged();
        });
        return true;
    }

    public static void setCraftingPlayer(Player player) {
        craftingPlayer.set(player);
    }

    public static Player getCraftingPlayer() {
        return craftingPlayer.get();
    }

    public static ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (stack.getItem().hasCraftingRemainingItem(stack)) {
            if (!(stack = stack.getItem().getCraftingRemainingItem(stack)).isEmpty() && stack.isDamageableItem() && stack.getDamageValue() > stack.getMaxDamage()) {
                EventHooks.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean onPlayerAttackTarget(Player player, Entity target) {
        if (((AttackEntityEvent)NeoForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, target))).isCanceled()) {
            return false;
        }
        ItemStack stack = player.getMainHandItem();
        return stack.isEmpty() || !stack.getItem().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(Entity entity, ResourceKey<Level> dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    @Nullable
    public static InteractionResult onInteractEntityAt(Player player, Entity entity, HitResult ray, InteractionHand hand) {
        Vec3 vec3d = ray.getLocation().subtract(entity.position());
        return CommonHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    @Nullable
    public static InteractionResult onInteractEntityAt(Player player, Entity entity, Vec3 vec3d, InteractionHand hand) {
        PlayerInteractEvent.EntityInteractSpecific evt = new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    @Nullable
    public static InteractionResult onInteractEntity(Player player, Entity entity, InteractionHand hand) {
        PlayerInteractEvent.EntityInteract evt = new PlayerInteractEvent.EntityInteract(player, hand, entity);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    @Nullable
    public static InteractionResult onItemRightClick(Player player, InteractionHand hand) {
        PlayerInteractEvent.RightClickItem evt = new PlayerInteractEvent.RightClickItem(player, hand);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(Player player, BlockPos pos, Direction face, ServerboundPlayerActionPacket.Action action) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, PlayerInteractEvent.LeftClickBlock.Action.convert(action));
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static PlayerInteractEvent.LeftClickBlock onClientMineHold(Player player, BlockPos pos, Direction face) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, PlayerInteractEvent.LeftClickBlock.Action.CLIENT_HOLD);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, hitVec);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void onEmptyClick(Player player, InteractionHand hand) {
        NeoForge.EVENT_BUS.post((Event)new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(Player player) {
        NeoForge.EVENT_BUS.post((Event)new PlayerInteractEvent.LeftClickEmpty(player));
    }

    @Nullable
    public static GameType onChangeGameType(Player player, GameType currentGameType, GameType newGameType) {
        if (currentGameType != newGameType) {
            PlayerEvent.PlayerChangeGameModeEvent evt = new PlayerEvent.PlayerChangeGameModeEvent(player, currentGameType, newGameType);
            NeoForge.EVENT_BUS.post((Event)evt);
            return evt.isCanceled() ? null : evt.getNewGameMode();
        }
        return newGameType;
    }

    @ApiStatus.Internal
    public static Codec<List<LootPool>> lootPoolsCodec(BiConsumer<LootPool, String> nameSetter) {
        Decoder decoder = ConditionalOps.createConditionalCodec(LootPool.CODEC).listOf().map(pools -> {
            if (pools.size() == 1) {
                if (((Optional)pools.get(0)).isPresent() && ((LootPool)((Optional)pools.get(0)).get()).getName() == null) {
                    nameSetter.accept((LootPool)((Optional)pools.get(0)).get(), "main");
                }
            } else {
                for (int i = 0; i < pools.size(); ++i) {
                    if (!((Optional)pools.get(i)).isPresent() || ((LootPool)((Optional)pools.get(i)).get()).getName() != null) continue;
                    nameSetter.accept((LootPool)((Optional)pools.get(i)).get(), "pool" + i);
                }
            }
            return pools.stream().filter(Optional::isPresent).map(Optional::get).toList();
        });
        return Codec.of((Encoder)LootPool.CODEC.listOf(), (Decoder)decoder);
    }

    public static FluidType getVanillaFluidType(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            return (FluidType)NeoForgeMod.EMPTY_TYPE.value();
        }
        if (fluid == Fluids.WATER || fluid == Fluids.FLOWING_WATER) {
            return (FluidType)NeoForgeMod.WATER_TYPE.value();
        }
        if (fluid == Fluids.LAVA || fluid == Fluids.FLOWING_LAVA) {
            return (FluidType)NeoForgeMod.LAVA_TYPE.value();
        }
        if (NeoForgeMod.MILK.asOptional().filter(milk -> milk == fluid).isPresent() || NeoForgeMod.FLOWING_MILK.asOptional().filter(milk -> milk == fluid).isPresent()) {
            return NeoForgeMod.MILK_TYPE.value();
        }
        throw new RuntimeException("Mod fluids must override getFluidType.");
    }

    public static TagKey<Block> getTagFromVanillaTier(Tiers tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case Tiers.WOOD -> Tags.Blocks.NEEDS_WOOD_TOOL;
            case Tiers.GOLD -> Tags.Blocks.NEEDS_GOLD_TOOL;
            case Tiers.STONE -> BlockTags.NEEDS_STONE_TOOL;
            case Tiers.IRON -> BlockTags.NEEDS_IRON_TOOL;
            case Tiers.DIAMOND -> BlockTags.NEEDS_DIAMOND_TOOL;
            case Tiers.NETHERITE -> Tags.Blocks.NEEDS_NETHERITE_TOOL;
        };
    }

    public static Collection<CreativeModeTab> onCheckCreativeTabs(CreativeModeTab ... vanillaTabs) {
        ArrayList<CreativeModeTab> tabs = new ArrayList<CreativeModeTab>(Arrays.asList(vanillaTabs));
        return tabs;
    }

    public static boolean canCropGrow(Level level, BlockPos pos, BlockState state, boolean def) {
        CropGrowEvent.Pre ev = new CropGrowEvent.Pre(level, pos, state);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == CropGrowEvent.Pre.Result.GROW || ev.getResult() == CropGrowEvent.Pre.Result.DEFAULT && def;
    }

    public static void fireCropGrowPost(Level level, BlockPos pos, BlockState state) {
        NeoForge.EVENT_BUS.post((Event)new CropGrowEvent.Post(level, pos, state, level.getBlockState(pos)));
    }

    public static CriticalHitEvent fireCriticalHit(Player player, Entity target, boolean vanillaCritical, float damageModifier) {
        return (CriticalHitEvent)NeoForge.EVENT_BUS.post((Event)new CriticalHitEvent(player, target, damageModifier, vanillaCritical));
    }

    public static SweepAttackEvent fireSweepAttack(Player player, Entity target, boolean isVanillaSweep) {
        return (SweepAttackEvent)NeoForge.EVENT_BUS.post((Event)new SweepAttackEvent(player, target, isVanillaSweep));
    }

    public static ItemAttributeModifiers computeModifiedAttributes(ItemStack stack, ItemAttributeModifiers defaultModifiers) {
        ItemAttributeModifierEvent event = new ItemAttributeModifierEvent(stack, defaultModifiers);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.build();
    }

    public static ItemStack getProjectile(LivingEntity entity, ItemStack projectileWeaponItem, ItemStack projectile) {
        LivingGetProjectileEvent event = new LivingGetProjectileEvent(entity, projectileWeaponItem, projectile);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getProjectileItemStack();
    }

    @Nullable
    public static String getDefaultCreatorModId(ItemStack itemStack) {
        String modId;
        Item item = itemStack.getItem();
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)item);
        String string = modId = registryName == null ? null : registryName.getNamespace();
        if ("minecraft".equals(modId)) {
            SpawnEggItem spawnEggItem;
            Optional key;
            if (item instanceof EnchantedBookItem) {
                Holder enchantmentHolder;
                Optional key2;
                Set enchantments = ((ItemEnchantments)itemStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet();
                if (enchantments.size() == 1 && (key2 = (enchantmentHolder = (Holder)enchantments.iterator().next()).unwrapKey()).isPresent()) {
                    return ((ResourceKey)key2.get()).location().getNamespace();
                }
            } else if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                Optional potionType = potionContents.potion();
                Optional key3 = potionType.flatMap(Holder::unwrapKey);
                if (key3.isPresent()) {
                    return ((ResourceKey)key3.get()).location().getNamespace();
                }
            } else if (item instanceof SpawnEggItem && (key = BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)(spawnEggItem = (SpawnEggItem)item).getType(itemStack))).isPresent()) {
                return ((ResourceKey)key.get()).location().getNamespace();
            }
        }
        return modId;
    }

    public static boolean onFarmlandTrample(Level level, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
        if (entity.canTrample(state, pos, fallDistance)) {
            BlockEvent.FarmlandTrampleEvent event = new BlockEvent.FarmlandTrampleEvent(level, pos, state, fallDistance, entity);
            NeoForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static int onNoteChange(Level level, BlockPos pos, BlockState state, int old, int _new) {
        NoteBlockEvent.Change event = new NoteBlockEvent.Change(level, pos, state, old, _new);
        if (((NoteBlockEvent.Change)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return -1;
        }
        return event.getVanillaNoteId();
    }

    @Nullable
    public static EntityDataSerializer<?> getSerializer(int id, CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> vanilla) {
        EntityDataSerializer serializer = (EntityDataSerializer)vanilla.byId(id);
        if (serializer == null) {
            return (EntityDataSerializer)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS.byId(id - 256);
        }
        return serializer;
    }

    public static int getSerializerId(EntityDataSerializer<?> serializer, CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> vanilla) {
        int id = vanilla.getId(serializer);
        if (id < 0 && (id = NeoForgeRegistries.ENTITY_DATA_SERIALIZERS.getId(serializer)) >= 0) {
            return id + 256;
        }
        return id;
    }

    public static boolean canEntityDestroy(Level level, BlockPos pos, LivingEntity entity) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        return EventHooks.canEntityGrief(level, (Entity)entity) && state.canEntityDestroy((BlockGetter)level, pos, (Entity)entity) && EventHooks.onEntityDestroyBlock(entity, pos, state);
    }

    @Deprecated
    public static List<ItemStack> modifyLoot(List<ItemStack> list, LootContext context) {
        return CommonHooks.modifyLoot(LootTableIdCondition.UNKNOWN_LOOT_TABLE, (ObjectArrayList<ItemStack>)ObjectArrayList.wrap((Object[])((ItemStack[])list.toArray())), context);
    }

    public static ObjectArrayList<ItemStack> modifyLoot(ResourceLocation lootTableId, ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        context.setQueriedLootTableId(lootTableId);
        LootModifierManager man = NeoForgeEventHandler.getLootModifierManager();
        for (IGlobalLootModifier mod : man.getAllLootMods()) {
            generatedLoot = mod.apply(generatedLoot, context);
        }
        return generatedLoot;
    }

    public static List<String> getModDataPacks() {
        List<String> modpacks = ResourcePackLoader.getPackNames(PackType.SERVER_DATA);
        if (modpacks.isEmpty()) {
            throw new IllegalStateException("Attempted to retrieve mod packs before they were loaded in!");
        }
        return modpacks;
    }

    public static List<String> getModDataPacksWithVanilla() {
        List<String> modpacks = CommonHooks.getModDataPacks();
        modpacks.add("vanilla");
        return modpacks;
    }

    @Deprecated
    public static Map<EntityType<? extends LivingEntity>, AttributeSupplier> getAttributesView() {
        return Collections.unmodifiableMap(FORGE_ATTRIBUTES);
    }

    @Deprecated
    public static void modifyAttributes() {
        ModLoader.postEvent((Event)new EntityAttributeCreationEvent(FORGE_ATTRIBUTES));
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> finalMap = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        ModLoader.postEvent((Event)new EntityAttributeModificationEvent(finalMap));
        finalMap.forEach((k, v) -> {
            AttributeSupplier supplier = DefaultAttributes.getSupplier((EntityType)k);
            AttributeSupplier.Builder newBuilder = supplier != null ? new AttributeSupplier.Builder(supplier) : new AttributeSupplier.Builder();
            newBuilder.combine(v);
            FORGE_ATTRIBUTES.put((EntityType<? extends LivingEntity>)k, newBuilder.build());
        });
    }

    public static void onEntityEnterSection(Entity entity, long packedOldPos, long packedNewPos) {
        NeoForge.EVENT_BUS.post((Event)new EntityEvent.EnteringSection(entity, packedOldPos, packedNewPos));
    }

    public static LivingShieldBlockEvent onDamageBlock(LivingEntity blocker, DamageContainer container, boolean originalBlocked) {
        LivingShieldBlockEvent e = new LivingShieldBlockEvent(blocker, container, originalBlocked);
        NeoForge.EVENT_BUS.post((Event)e);
        return e;
    }

    public static LivingSwapItemsEvent.Hands onLivingSwapHandItems(LivingEntity livingEntity) {
        LivingSwapItemsEvent.Hands event = new LivingSwapItemsEvent.Hands(livingEntity);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    @ApiStatus.Internal
    public static void writeAdditionalLevelSaveData(WorldData worldData, CompoundTag levelTag) {
        CompoundTag fmlData = new CompoundTag();
        ListTag modList = new ListTag();
        ModList.get().getMods().forEach(mi -> {
            CompoundTag mod = new CompoundTag();
            mod.putString("ModId", mi.getModId());
            mod.putString("ModVersion", MavenVersionTranslator.artifactVersionToString((ArtifactVersion)mi.getVersion()));
            modList.add((Object)mod);
        });
        fmlData.put("LoadingModList", (Tag)modList);
        LOGGER.debug(WORLDPERSISTENCE, "Gathered mod list to write to world save {}", (Object)worldData.getLevelName());
        levelTag.put("fml", (Tag)fmlData);
    }

    @ApiStatus.Internal
    public static void readAdditionalLevelSaveData(CompoundTag rootTag, LevelStorageSource.LevelDirectory levelDirectory) {
        CompoundTag tag = rootTag.getCompound("fml");
        if (tag.contains("LoadingModList")) {
            ListTag modList = tag.getList("LoadingModList", 10);
            HashMap<String, ArtifactVersion> mismatchedVersions = new HashMap<String, ArtifactVersion>(modList.size());
            HashMap<String, ArtifactVersion> missingVersions = new HashMap<String, ArtifactVersion>(modList.size());
            for (int i = 0; i < modList.size(); ++i) {
                CompoundTag mod = modList.getCompound(i);
                String modId = mod.getString("ModId");
                if (Objects.equals("minecraft", modId)) continue;
                String modVersion = mod.getString("ModVersion");
                DefaultArtifactVersion previousVersion = new DefaultArtifactVersion(modVersion);
                ModList.get().getModContainerById(modId).ifPresentOrElse(container -> {
                    ArtifactVersion loadingVersion = container.getModInfo().getVersion();
                    if (!loadingVersion.equals((Object)previousVersion)) {
                        mismatchedVersions.put(modId, (ArtifactVersion)previousVersion);
                    }
                }, () -> missingVersions.put(modId, (ArtifactVersion)previousVersion));
            }
            ModMismatchEvent mismatchEvent = new ModMismatchEvent(levelDirectory, mismatchedVersions, missingVersions);
            ModLoader.postEvent((Event)mismatchEvent);
            StringBuilder resolved = new StringBuilder("The following mods have version differences that were marked resolved:");
            StringBuilder unresolved = new StringBuilder("The following mods have version differences that were not resolved:");
            mismatchEvent.getResolved().forEachOrdered(res -> {
                String modid = res.modid();
                ModMismatchEvent.MismatchedVersionInfo diff = res.versionDifference();
                if (res.wasSelfResolved()) {
                    resolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING, self-resolved)".formatted(modid, diff.oldVersion()) : "%s (version %s -> %s, self-resolved)".formatted(modid, diff.oldVersion(), diff.newVersion()));
                } else {
                    String resolver = res.resolver().getModId();
                    resolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING, resolved by %s)".formatted(modid, diff.oldVersion(), resolver) : "%s (version %s -> %s, resolved by %s)".formatted(modid, diff.oldVersion(), diff.newVersion(), resolver));
                }
            });
            mismatchEvent.getUnresolved().forEachOrdered(unres -> {
                String modid = unres.modid();
                ModMismatchEvent.MismatchedVersionInfo diff = unres.versionDifference();
                unresolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING)".formatted(modid, diff.oldVersion()) : "%s (version %s -> %s)".formatted(modid, diff.oldVersion(), diff.newVersion()));
            });
            if (mismatchEvent.anyResolved()) {
                resolved.append(System.lineSeparator()).append("Things may not work well.");
                LOGGER.debug(WORLDPERSISTENCE, resolved.toString());
            }
            if (mismatchEvent.anyUnresolved()) {
                unresolved.append(System.lineSeparator()).append("Things may not work well.");
                LOGGER.warn(WORLDPERSISTENCE, unresolved.toString());
            }
        }
    }

    public static String encodeLifecycle(Lifecycle lifecycle) {
        if (lifecycle == Lifecycle.stable()) {
            return "stable";
        }
        if (lifecycle == Lifecycle.experimental()) {
            return "experimental";
        }
        if (lifecycle instanceof Lifecycle.Deprecated) {
            Lifecycle.Deprecated dep = (Lifecycle.Deprecated)lifecycle;
            return "deprecated=" + dep.since();
        }
        throw new IllegalArgumentException("Unknown lifecycle.");
    }

    public static Lifecycle parseLifecycle(String lifecycle) {
        if (lifecycle.equals("stable")) {
            return Lifecycle.stable();
        }
        if (lifecycle.equals("experimental")) {
            return Lifecycle.experimental();
        }
        if (lifecycle.startsWith("deprecated=")) {
            return Lifecycle.deprecated((int)Integer.parseInt(lifecycle.substring(lifecycle.indexOf(61) + 1)));
        }
        throw new IllegalArgumentException("Unknown lifecycle.");
    }

    public static void saveMobEffect(CompoundTag nbt, String key, MobEffect effect) {
        ResourceLocation registryName = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
        if (registryName != null) {
            nbt.putString(key, registryName.toString());
        }
    }

    @Nullable
    public static MobEffect loadMobEffect(CompoundTag nbt, String key, @Nullable MobEffect fallback) {
        String registryName = nbt.getString(key);
        if (Strings.isNullOrEmpty((String)registryName)) {
            return fallback;
        }
        try {
            return (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)registryName));
        }
        catch (ResourceLocationException e) {
            return fallback;
        }
    }

    public static boolean shouldSuppressEnderManAnger(EnderMan enderMan, Player player, ItemStack mask) {
        return mask.isEnderMask(player, enderMan) || ((EnderManAngerEvent)NeoForge.EVENT_BUS.post((Event)new EnderManAngerEvent(enderMan, player))).isCanceled();
    }

    @Nullable
    public static StructuresBecomeConfiguredFix.Conversion getStructureConversion(String originalBiome) {
        return FORGE_CONVERSION_MAP.get().get(originalBiome);
    }

    public static boolean checkStructureNamespace(String biome) {
        @Nullable ResourceLocation biomeLocation = ResourceLocation.tryParse((String)biome);
        return biomeLocation != null && !biomeLocation.getNamespace().equals("minecraft");
    }

    public static String prefixNamespace(ResourceLocation registryKey) {
        return registryKey.getNamespace().equals("minecraft") ? registryKey.getPath() : registryKey.getNamespace() + "/" + registryKey.getPath();
    }

    public static boolean canUseEntitySelectors(SharedSuggestionProvider provider) {
        if (EntitySelectorParser.allowSelectors((Object)provider)) {
            return true;
        }
        if (provider instanceof CommandSourceStack) {
            CommandSourceStack source = (CommandSourceStack)provider;
            CommandSource commandSource = source.source;
            if (commandSource instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)commandSource;
                return PermissionAPI.getPermission(player, NeoForgeMod.USE_SELECTORS_PERMISSION, new PermissionDynamicContext[0]);
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public static <T> HolderLookup.RegistryLookup<T> wrapRegistryLookup(final HolderLookup.RegistryLookup<T> lookup) {
        return new HolderLookup.RegistryLookup.Delegate<T>(){

            public HolderLookup.RegistryLookup<T> parent() {
                return lookup;
            }

            public Stream<HolderSet.Named<T>> listTags() {
                return Stream.empty();
            }

            public Optional<HolderSet.Named<T>> get(TagKey<T> key) {
                return Optional.of(HolderSet.emptyNamed((HolderOwner)lookup, key));
            }
        };
    }

    public static void onLivingBreathe(LivingEntity entity, int consumeAirAmount, int refillAirAmount) {
        LivingDrownEvent drownEvent;
        boolean canBreathe;
        boolean isAir;
        block9: {
            block10: {
                canBreathe = isAir = entity.getEyeInFluidType().isAir() || entity.level().getBlockState(BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ())).is(Blocks.BUBBLE_COLUMN);
                if (isAir) break block9;
                if (MobEffectUtil.hasWaterBreathing((LivingEntity)entity) || !entity.canDrownInFluidType(entity.getEyeInFluidType())) break block10;
                if (!(entity instanceof Player)) break block9;
                Player player = (Player)entity;
                if (!player.getAbilities().invulnerable) break block9;
            }
            canBreathe = true;
            refillAirAmount = 0;
        }
        LivingBreatheEvent breatheEvent = new LivingBreatheEvent(entity, canBreathe, consumeAirAmount, refillAirAmount);
        NeoForge.EVENT_BUS.post((Event)breatheEvent);
        if (breatheEvent.canBreathe()) {
            entity.setAirSupply(Math.min(entity.getAirSupply() + breatheEvent.getRefillAirAmount(), entity.getMaxAirSupply()));
        } else {
            entity.setAirSupply(entity.getAirSupply() - breatheEvent.getConsumeAirAmount());
        }
        if (entity.getAirSupply() <= 0 && !((LivingDrownEvent)NeoForge.EVENT_BUS.post((Event)(drownEvent = new LivingDrownEvent(entity)))).isCanceled() && drownEvent.isDrowning()) {
            entity.setAirSupply(0);
            Vec3 vec3 = entity.getDeltaMovement();
            for (int i = 0; i < drownEvent.getBubbleCount(); ++i) {
                double d2 = entity.getRandom().nextDouble() - entity.getRandom().nextDouble();
                double d3 = entity.getRandom().nextDouble() - entity.getRandom().nextDouble();
                double d4 = entity.getRandom().nextDouble() - entity.getRandom().nextDouble();
                entity.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, entity.getX() + d2, entity.getY() + d3, entity.getZ() + d4, vec3.x, vec3.y, vec3.z);
            }
            if (drownEvent.getDamageAmount() > 0.0f) {
                entity.hurt(entity.damageSources().drown(), drownEvent.getDamageAmount());
            }
        }
        if (!isAir && !entity.level().isClientSide && entity.isPassenger() && entity.getVehicle() != null && !entity.getVehicle().canBeRiddenUnderFluidType(entity.getEyeInFluidType(), (Entity)entity)) {
            entity.stopRiding();
        }
    }

    public static void markComponentClassAsValid(Class<?> clazz) {
        if (clazz.isRecord() || clazz.isEnum()) {
            throw new IllegalArgumentException("Records and enums are always valid components");
        }
        if (CommonHooks.overridesEqualsAndHashCode(clazz)) {
            throw new IllegalArgumentException("Class " + String.valueOf(clazz) + " already overrides equals and hashCode");
        }
        checkedComponentClasses.add(clazz);
    }

    @ApiStatus.Internal
    public static void validateComponent(@Nullable Object dataComponent) {
        if (!SharedConstants.IS_RUNNING_IN_IDE || dataComponent == null) {
            return;
        }
        Class<?> clazz = dataComponent.getClass();
        if (!checkedComponentClasses.contains(clazz)) {
            if (clazz.isRecord() || clazz.isEnum()) {
                checkedComponentClasses.add(clazz);
                return;
            }
            if (CommonHooks.overridesEqualsAndHashCode(clazz)) {
                checkedComponentClasses.add(clazz);
                return;
            }
            if (CommonHooks.isPotentialRegistryObject(dataComponent)) {
                checkedComponentClasses.add(clazz);
                return;
            }
            throw new IllegalArgumentException("Data components must implement equals and hashCode. Keep in mind they must also be immutable. Problematic class: " + String.valueOf(clazz));
        }
    }

    private static boolean isPotentialRegistryObject(Object value) {
        for (Registry registry : BuiltInRegistries.REGISTRY) {
            if (!registry.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    private static boolean overridesEqualsAndHashCode(Class<?> clazz) {
        try {
            Method equals = clazz.getMethod("equals", Object.class);
            Method hashCode = clazz.getMethod("hashCode", new Class[0]);
            return equals.getDeclaringClass() != Object.class && hashCode.getDeclaringClass() != Object.class;
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Failed to check for component equals and hashCode", exception);
        }
    }

    public static void onChunkUnload(PoiManager poiManager, ChunkAccess chunkAccess) {
        ChunkPos chunkPos = chunkAccess.getPos();
        poiManager.flush(chunkPos);
        int SectionPosMinY = SectionPos.blockToSectionCoord((int)chunkAccess.getMinBuildHeight());
        for (int currentSectionY = 0; currentSectionY < chunkAccess.getSectionsCount(); ++currentSectionY) {
            long sectionPosKey = SectionPos.asLong((int)chunkPos.x, (int)(SectionPosMinY + currentSectionY), (int)chunkPos.z);
            poiManager.remove(sectionPosKey);
        }
    }

    @Deprecated(forRemoval=true)
    public static boolean canMobEffectBeApplied(LivingEntity entity, MobEffectInstance effect) {
        return CommonHooks.canMobEffectBeApplied(entity, effect, null);
    }

    public static boolean canMobEffectBeApplied(LivingEntity entity, MobEffectInstance effect, @Nullable Entity source) {
        MobEffectEvent.Applicable event = new MobEffectEvent.Applicable(entity, effect, source);
        return ((MobEffectEvent.Applicable)NeoForge.EVENT_BUS.post((Event)event)).getApplicationResult();
    }

    @Nullable
    public static <T> HolderLookup.RegistryLookup<T> resolveLookup(ResourceKey<? extends Registry<T>> key) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.registryAccess().lookup(key).orElse(null);
        }
        if (FMLEnvironment.dist.isClient()) {
            return ClientHooks.resolveLookup(key);
        }
        return null;
    }

    public static UseOnContext dispenseUseOnContext(BlockSource source, ItemStack stack) {
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos pos = source.pos().relative(facing);
        Direction blockFace = facing.getOpposite();
        BlockHitResult hitResult = new BlockHitResult(new Vec3((double)pos.getX() + 0.5 + (double)blockFace.getStepX() * 0.5, (double)pos.getY() + 0.5 + (double)blockFace.getStepY() * 0.5, (double)pos.getZ() + 0.5 + (double)blockFace.getStepZ() * 0.5), blockFace, pos, false);
        return new UseOnContext((Level)source.level(), null, InteractionHand.MAIN_HAND, stack, hitResult);
    }

    public static boolean tryDispenseShearsHarvestBlock(BlockSource source, ItemStack stack, ServerLevel level, BlockPos pos) {
        BlockState blockstate = source.state().getToolModifiedState(CommonHooks.dispenseUseOnContext(source, stack), ItemAbilities.SHEARS_HARVEST, false);
        if (blockstate == null) {
            return false;
        }
        level.setBlock(pos, blockstate, 3);
        level.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
        return true;
    }

    public static Map<RecipeBookType, Pair<String, String>> buildRecipeBookTypeTagFields(Map<RecipeBookType, Pair<String, String>> vanillaMap) {
        ExtensionInfo extInfo = RecipeBookType.getExtensionInfo();
        if (extInfo.extended()) {
            vanillaMap = new HashMap<RecipeBookType, Pair<String, String>>(vanillaMap);
            for (RecipeBookType type : RecipeBookType.values()) {
                if (type.ordinal() < extInfo.vanillaCount()) continue;
                String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.name());
                vanillaMap.put(type, (Pair<String, String>)Pair.of((Object)("is" + name + "GuiOpen"), (Object)("is" + name + "FilteringCraftable")));
            }
            vanillaMap = Map.copyOf(vanillaMap);
        }
        return vanillaMap;
    }

    public static RecipeBookType[] getFilteredRecipeBookTypeValues() {
        if (FMLEnvironment.dist.isClient()) {
            return ClientHooks.getFilteredRecipeBookTypeValues();
        }
        return RecipeBookType.values();
    }

    static {
        CommonHooks.markComponentClassAsValid(BlockState.class);
        CommonHooks.markComponentClassAsValid(FluidState.class);
        CommonHooks.markComponentClassAsValid(ResourceKey.class);
    }

    @FunctionalInterface
    public static interface BiomeCallbackFunction {
        public Biome apply(Biome.ClimateSettings var1, BiomeSpecialEffects var2, BiomeGenerationSettings var3, MobSpawnSettings var4);
    }
}

