/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.DecimalFormat;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;

class TPSCommand {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");
    private static final long[] UNLOADED = new long[]{0L};

    TPSCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tps").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> TPSCommand.sendTime((CommandSourceStack)ctx.getSource(), DimensionArgument.getDimension((CommandContext)ctx, (String)"dim"))))).executes(ctx -> {
            for (ServerLevel dim : ((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()) {
                TPSCommand.sendTime((CommandSourceStack)ctx.getSource(), dim);
            }
            long[] times = ((CommandSourceStack)ctx.getSource()).getServer().getTickTimesNanos();
            double meanTickTime = (double)TPSCommand.mean(times) * 1.0E-6;
            double meanTPS = (double)TimeUtil.MILLISECONDS_PER_SECOND / Math.max(meanTickTime, (double)((CommandSourceStack)ctx.getSource()).getServer().tickRateManager().millisecondsPerTick());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.neoforge.tps.summary.all", (Object[])new Object[]{TIME_FORMATTER.format(meanTickTime), TIME_FORMATTER.format(meanTPS)}), false);
            return 0;
        });
    }

    private static int sendTime(CommandSourceStack cs, ServerLevel dim) throws CommandSyntaxException {
        long[] times = cs.getServer().getTickTime(dim.dimension());
        if (times == null) {
            times = UNLOADED;
        }
        Registry reg = cs.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
        double worldTickTime = (double)TPSCommand.mean(times) * 1.0E-6;
        double worldTPS = (double)TimeUtil.MILLISECONDS_PER_SECOND / Math.max(worldTickTime, (double)dim.tickRateManager().millisecondsPerTick());
        cs.sendSuccess(() -> Component.translatable((String)"commands.neoforge.tps.summary.named", (Object[])new Object[]{dim.dimension().location().toString(), reg.getKey((Object)dim.dimensionType()).toString(), TIME_FORMATTER.format(worldTickTime), TIME_FORMATTER.format(worldTPS)}), false);
        return 1;
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

