/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.loading;

import java.io.File;
import java.util.List;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.ModWorkManager;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.internal.CommonModLoader;
import net.neoforged.neoforge.logging.CrashReportExtender;
import net.neoforged.neoforge.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerModLoader
extends CommonModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean hasErrors = false;

    public static void load() {
        LogicalSidedProvider.setServer(() -> {
            throw new IllegalStateException("Unable to access server yet");
        });
        LanguageHook.loadBuiltinLanguages();
        try {
            ServerModLoader.begin(() -> {}, false);
            ServerModLoader.load(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor());
            ServerModLoader.finish(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor());
        }
        catch (ModLoadingException error) {
            hasErrors = true;
            LanguageHook.loadBuiltinLanguages();
            CrashReportExtender.dumpModLoadingCrashReport(LOGGER, error.getIssues(), new File("."));
            throw error;
        }
        List<ModLoadingIssue> warnings = ModLoader.getLoadingIssues().stream().filter(i -> i.severity() == ModLoadingIssue.Severity.WARNING).toList();
        if (!warnings.isEmpty()) {
            LOGGER.warn(Logging.LOADING, "Mods loaded with {} issues", (Object)warnings.size());
            for (ModLoadingIssue issue : warnings) {
                LOGGER.warn(Logging.LOADING, "{} [{}]", (Object)issue.translationKey(), (Object)issue.translationArgs());
            }
        }
        NeoForge.EVENT_BUS.start();
    }

    public static boolean hasErrors() {
        return hasErrors;
    }
}

