/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeModifierEvent
extends Event {
    private final ItemStack stack;
    private final EquipmentSlot slotType;
    private final Multimap<Holder<Attribute>, AttributeModifier> originalModifiers;
    private Multimap<Holder<Attribute>, AttributeModifier> unmodifiableModifiers;
    @Nullable
    private Multimap<Holder<Attribute>, AttributeModifier> modifiableModifiers;

    public ItemAttributeModifierEvent(ItemStack stack, EquipmentSlot slotType, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.stack = stack;
        this.slotType = slotType;
        this.originalModifiers = modifiers;
        this.unmodifiableModifiers = this.originalModifiers;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getModifiers() {
        return this.unmodifiableModifiers;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getOriginalModifiers() {
        return this.originalModifiers;
    }

    private Multimap<Holder<Attribute>, AttributeModifier> getModifiableMap() {
        if (this.modifiableModifiers == null) {
            this.modifiableModifiers = HashMultimap.create(this.originalModifiers);
            this.unmodifiableModifiers = Multimaps.unmodifiableMultimap(this.modifiableModifiers);
        }
        return this.modifiableModifiers;
    }

    public boolean addModifier(Holder<Attribute> attribute, AttributeModifier modifier) {
        return this.getModifiableMap().put(attribute, (Object)modifier);
    }

    public boolean removeModifier(Holder<Attribute> attribute, AttributeModifier modifier) {
        return this.getModifiableMap().remove(attribute, (Object)modifier);
    }

    public Collection<AttributeModifier> removeAttribute(Holder<Attribute> attribute) {
        return this.getModifiableMap().removeAll(attribute);
    }

    public void clearModifiers() {
        this.getModifiableMap().clear();
    }

    public EquipmentSlot getSlotType() {
        return this.slotType;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }
}

