/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import com.mojang.blaze3d.vertex.Tesselator;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.fml.ModList;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.apache.commons.lang3.tuple.Pair;

public class ModMismatchDisconnectedScreen
extends Screen {
    private final Screen parent;
    private int textHeight;
    private final Path modsDir;
    private final Path logFile;
    private final int listHeight = 140;
    private final Map<ResourceLocation, Component> mismatchedChannelData;

    public ModMismatchDisconnectedScreen(Screen parentScreen, Component title, Map<ResourceLocation, Component> mismatchedChannelData) {
        super(title);
        this.parent = parentScreen;
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.mismatchedChannelData = mismatchedChannelData;
    }

    protected void init() {
        int listLeft = Math.max(8, this.width / 2 - 220);
        int listWidth = Math.min(440, this.width - 16);
        int upperButtonHeight = Math.min((this.height + this.listHeight + this.textHeight) / 2 + 10, this.height - 50);
        int lowerButtonHeight = Math.min((this.height + this.listHeight + this.textHeight) / 2 + 35, this.height - 25);
        this.addRenderableWidget((GuiEventListener)new MismatchInfoPanel(this.minecraft, listWidth, 140, (this.height - this.listHeight) / 2, listLeft));
        int buttonWidth = Math.min(210, this.width / 2 - 20);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.file", (Object[])new Object[]{this.logFile.getFileName()})), button -> Util.getPlatform().openFile(this.logFile.toFile())).bounds(Math.max(this.width / 4 - buttonWidth / 2, listLeft), upperButtonHeight, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.mods.folder", (Object[])new Object[0])), button -> Util.getPlatform().openFile(this.modsDir.toFile())).bounds(Math.min(this.width * 3 / 4 - buttonWidth / 2, listLeft + listWidth - buttonWidth), upperButtonHeight, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.toMenu"), button -> this.minecraft.setScreen(this.parent)).bounds((this.width - buttonWidth) / 2, lowerButtonHeight, buttonWidth, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int textYOffset = 18;
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, (this.height - this.listHeight - this.textHeight) / 2 - textYOffset - 18, 0xAAAAAA);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    class MismatchInfoPanel
    extends ScrollPanel {
        private final List<Pair<FormattedCharSequence, FormattedCharSequence>> lineTable;
        private final int contentSize;
        private final int nameIndent = 10;
        private final int tableWidth;
        private final int nameWidth;
        private final int versionWidth;

        public MismatchInfoPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.nameIndent = 10;
            this.tableWidth = this.width - this.border * 2 - 6 - 10;
            this.nameWidth = this.tableWidth * 3 / 5;
            this.versionWidth = (this.tableWidth - this.nameWidth) / 2;
            record Row(MutableComponent name, MutableComponent reason) {
            }
            ArrayList<Row> rows = new ArrayList<Row>();
            if (!ModMismatchDisconnectedScreen.this.mismatchedChannelData.isEmpty()) {
                rows.add(new Row(Component.translatable((String)"fml.modmismatchscreen.table.channelname"), Component.translatable((String)"fml.modmismatchscreen.table.reason")));
                int i = 0;
                for (Map.Entry<ResourceLocation, Component> modData : ModMismatchDisconnectedScreen.this.mismatchedChannelData.entrySet()) {
                    rows.add(new Row(this.toChannelNameComponent(modData.getKey()), modData.getValue().copy()));
                    if (++i < 10) continue;
                    rows.add(new Row(Component.literal((String)""), Component.translatable((String)"fml.modmismatchscreen.additional", (Object[])new Object[]{ModMismatchDisconnectedScreen.this.mismatchedChannelData.size() - i}).withStyle(ChatFormatting.ITALIC)));
                    break;
                }
                rows.add(new Row(Component.literal((String)""), Component.literal((String)"")));
            }
            this.lineTable = rows.stream().flatMap(p -> this.splitLineToWidth(p.name(), p.reason()).stream()).collect(Collectors.toList());
            this.contentSize = this.lineTable.size();
        }

        private List<Pair<FormattedCharSequence, FormattedCharSequence>> splitLineToWidth(MutableComponent name, MutableComponent reason) {
            Style style = name.getStyle();
            int versionColumns = 1;
            int adaptedNameWidth = this.nameWidth + this.versionWidth * (2 - versionColumns) - 4;
            List nameLines = ModMismatchDisconnectedScreen.this.font.split((FormattedText)name, adaptedNameWidth);
            List reasonLines = ModMismatchDisconnectedScreen.this.font.split((FormattedText)reason.setStyle(style), this.versionWidth - 4);
            ArrayList<Pair<FormattedCharSequence, FormattedCharSequence>> splitLines = new ArrayList<Pair<FormattedCharSequence, FormattedCharSequence>>();
            int rowsOccupied = Math.max(nameLines.size(), reasonLines.size());
            for (int i = 0; i < rowsOccupied; ++i) {
                splitLines.add((Pair<FormattedCharSequence, FormattedCharSequence>)Pair.of((Object)(i < nameLines.size() ? (FormattedCharSequence)nameLines.get(i) : FormattedCharSequence.EMPTY), (Object)(i < reasonLines.size() ? (FormattedCharSequence)reasonLines.get(i) : FormattedCharSequence.EMPTY)));
            }
            return splitLines;
        }

        private MutableComponent toChannelNameComponent(ResourceLocation id) {
            String modId = id.getNamespace();
            String url = ModList.get().getModContainerById(modId).flatMap(container -> container.getModInfo().getModURL()).map(URL::toString).orElse("");
            MutableComponent result = Component.literal((String)id.toString()).withStyle(ChatFormatting.YELLOW);
            if (!url.isEmpty()) {
                result = result.withStyle(s -> s.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"fml.modmismatchscreen.table.visit.mod_page", (Object[])new Object[]{id.toString()})))).withStyle(s -> s.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
            }
            return result;
        }

        @Override
        protected int getContentHeight() {
            Objects.requireNonNull(ModMismatchDisconnectedScreen.this.font);
            int height = this.contentSize * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        @Override
        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            int i = 0;
            for (Pair<FormattedCharSequence, FormattedCharSequence> line : this.lineTable) {
                FormattedCharSequence name = (FormattedCharSequence)line.getLeft();
                FormattedCharSequence reasons = (FormattedCharSequence)line.getRight();
                int color = Optional.ofNullable(ModMismatchDisconnectedScreen.this.font.getSplitter().componentStyleAtWidth(name, 0)).map(Style::getColor).map(TextColor::getValue).orElse(0xFFFFFF);
                int nameLeft = this.left + this.border + (reasons == null ? 0 : 10);
                guiGraphics.drawString(ModMismatchDisconnectedScreen.this.font, name, nameLeft, relativeY + i * 12, color, false);
                if (reasons != null) {
                    guiGraphics.drawString(ModMismatchDisconnectedScreen.this.font, reasons, this.left + this.border + 10 + this.nameWidth, relativeY + i * 12, color, false);
                }
                ++i;
            }
        }

        @Override
        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            Style style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null && style.getHoverEvent() != null) {
                guiGraphics.renderComponentHoverEffect(ModMismatchDisconnectedScreen.this.font, style, mouseX, mouseY);
            }
        }

        public Style getComponentStyleAt(double x, double y) {
            double relativeX;
            double relativeY;
            int slotIndex;
            if (this.isMouseOver(x, y) && (slotIndex = (int)((relativeY = y - (double)this.top + (double)this.scrollDistance - (double)this.border) + (double)(this.border / 2)) / 12) < this.contentSize && (relativeX = x - (double)this.left - (double)this.border - (double)(this.lineTable.get(slotIndex).getRight() == null ? 0 : 10)) >= 0.0) {
                return ModMismatchDisconnectedScreen.this.font.getSplitter().componentStyleAtWidth((FormattedCharSequence)this.lineTable.get(slotIndex).getLeft(), (int)relativeX);
            }
            return null;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            Style style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null) {
                ModMismatchDisconnectedScreen.this.handleComponentClicked(style);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput output) {
        }
    }
}

