/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.attachment.AttachmentInternals;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.payload.AdvancedAddEntityPayload;
import org.jetbrains.annotations.Nullable;

public interface IEntityExtension
extends INBTSerializable<CompoundTag> {
    private Entity self() {
        return (Entity)this;
    }

    @Override
    default public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.self().load(nbt);
    }

    @Override
    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag ret = new CompoundTag();
        String id = this.self().getEncodeId();
        if (id != null) {
            ret.putString("id", this.self().getEncodeId());
        }
        return this.self().saveWithoutId(ret);
    }

    @Nullable
    public Collection<ItemEntity> captureDrops();

    public Collection<ItemEntity> captureDrops(@Nullable Collection<ItemEntity> var1);

    public CompoundTag getPersistentData();

    default public boolean shouldRiderSit() {
        return true;
    }

    @Nullable
    default public ItemStack getPickedResult(HitResult target) {
        return this.self().getPickResult();
    }

    default public boolean canRiderInteract() {
        return false;
    }

    default public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return type.canRideVehicleUnder(this.self(), rider);
    }

    public boolean canTrample(BlockState var1, BlockPos var2, float var3);

    default public MobCategory getClassification(boolean forSpawnCount) {
        return this.self().getType().getCategory();
    }

    public boolean isAddedToWorld();

    public void onAddedToWorld();

    public void onRemovedFromWorld();

    public void revive();

    default public boolean isMultipartEntity() {
        return false;
    }

    @Nullable
    default public PartEntity<?>[] getParts() {
        return null;
    }

    public double getFluidTypeHeight(FluidType var1);

    public FluidType getMaxHeightFluidType();

    default public boolean isInFluidType(FluidState state) {
        return this.isInFluidType(state.getFluidType());
    }

    default public boolean isInFluidType(FluidType type) {
        return this.getFluidTypeHeight(type) > 0.0;
    }

    default public boolean isInFluidType(BiPredicate<FluidType, Double> predicate) {
        return this.isInFluidType(predicate, false);
    }

    public boolean isInFluidType(BiPredicate<FluidType, Double> var1, boolean var2);

    public boolean isInFluidType();

    public FluidType getEyeInFluidType();

    default public boolean isEyeInFluidType(FluidType type) {
        return type == this.getEyeInFluidType();
    }

    default public boolean canStartSwimming() {
        return !this.getEyeInFluidType().isAir() && this.canSwimInFluidType(this.getEyeInFluidType()) && this.canSwimInFluidType(this.self().level().getFluidState(this.self().blockPosition()).getFluidType());
    }

    default public double getFluidMotionScale(FluidType type) {
        return type.motionScale(this.self());
    }

    default public boolean isPushedByFluid(FluidType type) {
        return this.self().isPushedByFluid() && type.canPushEntity(this.self());
    }

    default public boolean canSwimInFluidType(FluidType type) {
        return type.canSwim(this.self());
    }

    default public boolean canFluidExtinguish(FluidType type) {
        return type.canExtinguish(this.self());
    }

    default public float getFluidFallDistanceModifier(FluidType type) {
        return type.getFallDistanceModifier(this.self());
    }

    default public boolean canHydrateInFluidType(FluidType type) {
        return type.canHydrate(this.self());
    }

    @Nullable
    default public SoundEvent getSoundFromFluidType(FluidType type, SoundAction action) {
        return type.getSound(this.self(), action);
    }

    default public boolean hasCustomOutlineRendering(Player player) {
        return false;
    }

    default public void sendPairingData(ServerPlayer serverPlayer, Consumer<CustomPacketPayload> bundleBuilder) {
        if (this instanceof IEntityWithComplexSpawn) {
            bundleBuilder.accept(new AdvancedAddEntityPayload(this.self()));
        }
    }

    default public void copyAttachmentsFrom(Entity other, boolean isDeath) {
        AttachmentInternals.copyEntityAttachments(this.self(), other, isDeath);
    }
}

