/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TagConventionLogWarning {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<TagKey<?>, TagKey<?>> LEGACY_FORGE_TAGS = Map.ofEntries(TagConventionLogWarning.createMapEntry(Registries.BLOCK, "enderman_place_on_blacklist", Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "needs_wood_tool", Tags.Blocks.NEEDS_WOOD_TOOL), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "needs_gold_tool", Tags.Blocks.NEEDS_GOLD_TOOL), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "needs_netherite_tool", Tags.Blocks.NEEDS_NETHERITE_TOOL), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "barrels", Tags.Blocks.BARRELS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "barrels/wooden", Tags.Blocks.BARRELS_WOODEN), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "bookshelves", Tags.Blocks.BOOKSHELVES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "chests", Tags.Blocks.CHESTS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "chests/ender", Tags.Blocks.CHESTS_ENDER), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "chests/trapped", Tags.Blocks.CHESTS_TRAPPED), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "chests/wooden", Tags.Blocks.CHESTS_WOODEN), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "cobblestone", Tags.Blocks.COBBLESTONES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "cobblestone/normal", Tags.Blocks.COBBLESTONES_NORMAL), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "cobblestone/infested", Tags.Blocks.COBBLESTONES_INFESTED), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "cobblestone/mossy", Tags.Blocks.COBBLESTONES_MOSSY), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "cobblestone/deepslate", Tags.Blocks.COBBLESTONES_DEEPSLATE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "crafting_table", Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "crafting_tables", Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "workbench", Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "workbenches", Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "end_stones", Tags.Blocks.END_STONES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "fence_gates", Tags.Blocks.FENCE_GATES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "fence_gates/wooden", Tags.Blocks.FENCE_GATES_WOODEN), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "fences", Tags.Blocks.FENCES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "fences/nether_brick", Tags.Blocks.FENCES_NETHER_BRICK), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "fences/wooden", Tags.Blocks.FENCES_WOODEN), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "furnace", Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "furnaces", Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/black", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/blue", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/brown", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/colorless", Tags.Blocks.GLASS_BLOCKS_COLORLESS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/cyan", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/gray", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/green", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/light_blue", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/light_gray", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/lime", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/magenta", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/orange", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/pink", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/purple", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/red", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/silica", Tags.Blocks.GLASS_BLOCKS_CHEAP), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/tinted", Tags.Blocks.GLASS_BLOCKS_TINTED), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/white", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass/yellow", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/black", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/blue", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/brown", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/colorless", Tags.Blocks.GLASS_PANES_COLORLESS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/cyan", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/gray", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/green", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/light_blue", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/light_gray", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/lime", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/magenta", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/orange", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/pink", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/purple", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/red", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/white", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "glass_panes/yellow", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "gravel", Tags.Blocks.GRAVELS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "heads", Tags.Blocks.SKULLS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "skulls", Tags.Blocks.SKULLS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "netherrack", Tags.Blocks.NETHERRACKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "obsidian", Tags.Blocks.OBSIDIANS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ore_bearing_ground/deepslate", Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ore_bearing_ground/netherrack", Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ore_bearing_ground/stone", Tags.Blocks.ORE_BEARING_GROUND_STONE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ore_rates/dense", Tags.Blocks.ORE_RATES_DENSE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ore_rates/singular", Tags.Blocks.ORE_RATES_SINGULAR), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ore_rates/sparse", Tags.Blocks.ORE_RATES_SPARSE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores", Tags.Blocks.ORES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/coal", Tags.Blocks.ORES_COAL), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/copper", Tags.Blocks.ORES_COPPER), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/diamond", Tags.Blocks.ORES_DIAMOND), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/emerald", Tags.Blocks.ORES_EMERALD), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/gold", Tags.Blocks.ORES_GOLD), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/iron", Tags.Blocks.ORES_IRON), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/lapis", Tags.Blocks.ORES_LAPIS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/netherite_scrap", Tags.Blocks.ORES_NETHERITE_SCRAP), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/quartz", Tags.Blocks.ORES_QUARTZ), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores/redstone", Tags.Blocks.ORES_REDSTONE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores_in_ground/deepslate", Tags.Blocks.ORES_IN_GROUND_DEEPSLATE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores_in_ground/netherrack", Tags.Blocks.ORES_IN_GROUND_NETHERRACK), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "ores_in_ground/stone", Tags.Blocks.ORES_IN_GROUND_STONE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "sand", Tags.Blocks.SANDS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "sand/colorless", Tags.Blocks.SANDS_COLORLESS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "sand/red", Tags.Blocks.SANDS_RED), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "sandstone", Tags.Blocks.SANDSTONE_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "stained_glass", Tags.Blocks.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "stained_glass_panes", Tags.Blocks.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "stone", Tags.Blocks.STONES), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks", Tags.Blocks.STORAGE_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/amethyst", "storage_blocks/amethyst"), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/coal", Tags.Blocks.STORAGE_BLOCKS_COAL), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/copper", Tags.Blocks.STORAGE_BLOCKS_COPPER), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/diamond", Tags.Blocks.STORAGE_BLOCKS_DIAMOND), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/emerald", Tags.Blocks.STORAGE_BLOCKS_EMERALD), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/gold", Tags.Blocks.STORAGE_BLOCKS_GOLD), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/iron", Tags.Blocks.STORAGE_BLOCKS_IRON), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/lapis", Tags.Blocks.STORAGE_BLOCKS_LAPIS), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/netherite", Tags.Blocks.STORAGE_BLOCKS_NETHERITE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/quartz", "storage_blocks/quartz"), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/raw_copper", Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/raw_gold", Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/raw_iron", Tags.Blocks.STORAGE_BLOCKS_RAW_IRON), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "storage_blocks/redstone", Tags.Blocks.STORAGE_BLOCKS_REDSTONE), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "relocation_not_supported", Tags.Blocks.RELOCATION_NOT_SUPPORTED), TagConventionLogWarning.createMapEntry(Registries.BLOCK, "immovable", Tags.Blocks.RELOCATION_NOT_SUPPORTED), TagConventionLogWarning.createMapEntry(Registries.BLOCK_PREDICATE_TYPE, "relocation_not_supported", Tags.Blocks.RELOCATION_NOT_SUPPORTED), TagConventionLogWarning.createMapEntry(Registries.BLOCK_PREDICATE_TYPE, "immovable", Tags.Blocks.RELOCATION_NOT_SUPPORTED), TagConventionLogWarning.createMapEntry(Registries.ENTITY_TYPE, "bosses", Tags.EntityTypes.BOSSES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "barrels", Tags.Items.BARRELS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "barrels/wooden", Tags.Items.BARRELS_WOODEN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "bones", Tags.Items.BONES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "bookshelves", Tags.Items.BOOKSHELVES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "bucket", Tags.Items.BUCKETS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "chests", Tags.Items.CHESTS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "chests/ender", Tags.Items.CHESTS_ENDER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "chests/trapped", Tags.Items.CHESTS_TRAPPED), TagConventionLogWarning.createMapEntry(Registries.ITEM, "chests/wooden", Tags.Items.CHESTS_WOODEN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cobblestone", Tags.Items.COBBLESTONES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cobblestone/normal", Tags.Items.COBBLESTONES_NORMAL), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cobblestone/infested", Tags.Items.COBBLESTONES_INFESTED), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cobblestone/mossy", Tags.Items.COBBLESTONES_MOSSY), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cobblestone/deepslate", Tags.Items.COBBLESTONES_DEEPSLATE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crafting_table", Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crafting_tables", Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "workbench", Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "workbenches", Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crops", Tags.Items.CROPS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crops/beetroot", Tags.Items.CROPS_BEETROOT), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crops/carrot", Tags.Items.CROPS_CARROT), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crops/nether_wart", Tags.Items.CROPS_NETHER_WART), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crops/potato", Tags.Items.CROPS_POTATO), TagConventionLogWarning.createMapEntry(Registries.ITEM, "crops/wheat", Tags.Items.CROPS_WHEAT), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dusts", Tags.Items.DUSTS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dusts/redstone", Tags.Items.DUSTS_REDSTONE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dusts/glowstone", Tags.Items.DUSTS_GLOWSTONE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes", Tags.Items.DYES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/black", Tags.Items.DYES_BLACK), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/red", Tags.Items.DYES_RED), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/green", Tags.Items.DYES_GREEN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/brown", Tags.Items.DYES_BROWN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/blue", Tags.Items.DYES_BLUE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/purple", Tags.Items.DYES_PURPLE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/cyan", Tags.Items.DYES_CYAN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/light_gray", Tags.Items.DYES_LIGHT_GRAY), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/gray", Tags.Items.DYES_GRAY), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/pink", Tags.Items.DYES_PINK), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/lime", Tags.Items.DYES_LIME), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/yellow", Tags.Items.DYES_YELLOW), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/light_blue", Tags.Items.DYES_LIGHT_BLUE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/magenta", Tags.Items.DYES_MAGENTA), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/orange", Tags.Items.DYES_ORANGE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "dyes/white", Tags.Items.DYES_WHITE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "eggs", Tags.Items.EGGS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "enchanting_fuels", Tags.Items.ENCHANTING_FUELS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "end_stones", Tags.Items.END_STONES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ender_pearls", Tags.Items.ENDER_PEARLS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "feathers", Tags.Items.FEATHERS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fence_gates", Tags.Items.FENCE_GATES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fence_gates/wooden", Tags.Items.FENCE_GATES_WOODEN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fences", Tags.Items.FENCES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fences/nether_brick", Tags.Items.FENCES_NETHER_BRICK), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fences/wooden", Tags.Items.FENCES_WOODEN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "furnace", Tags.Items.PLAYER_WORKSTATIONS_FURNACES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "furnaces", Tags.Items.PLAYER_WORKSTATIONS_FURNACES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems", Tags.Items.GEMS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems/diamond", Tags.Items.GEMS_DIAMOND), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems/emerald", Tags.Items.GEMS_EMERALD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems/amethyst", Tags.Items.GEMS_AMETHYST), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems/lapis", Tags.Items.GEMS_LAPIS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems/prismarine", Tags.Items.GEMS_PRISMARINE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gems/quartz", Tags.Items.GEMS_QUARTZ), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/black", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/blue", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/brown", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/colorless", Tags.Items.GLASS_BLOCKS_COLORLESS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/cyan", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/gray", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/green", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/light_blue", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/light_gray", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/lime", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/magenta", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/orange", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/pink", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/purple", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/red", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/silica", Tags.Items.GLASS_BLOCKS_CHEAP), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/tinted", Tags.Items.GLASS_BLOCKS_TINTED), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/white", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass/yellow", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/black", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/blue", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/brown", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/colorless", Tags.Items.GLASS_PANES_COLORLESS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/cyan", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/gray", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/green", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/light_blue", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/light_gray", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/lime", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/magenta", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/orange", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/pink", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/purple", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/red", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/white", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "glass_panes/yellow", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gravel", Tags.Items.GRAVELS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "gunpowder", Tags.Items.GUNPOWDERS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots", Tags.Items.INGOTS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots/brick", Tags.Items.BRICKS_NORMAL), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots/copper", Tags.Items.INGOTS_COPPER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots/gold", Tags.Items.INGOTS_GOLD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots/iron", Tags.Items.INGOTS_IRON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots/netherite", Tags.Items.INGOTS_NETHERITE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ingots/nether_brick", Tags.Items.BRICKS_NETHER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "leather", Tags.Items.LEATHERS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "mushrooms", Tags.Items.MUSHROOMS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "nether_stars", Tags.Items.NETHER_STARS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "netherrack", Tags.Items.NETHERRACKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "nuggets", Tags.Items.NUGGETS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "nuggets/gold", Tags.Items.NUGGETS_GOLD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "nuggets/iron", Tags.Items.NUGGETS_IRON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "obsidian", Tags.Items.OBSIDIANS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ore_bearing_ground/deepslate", Tags.Items.ORE_BEARING_GROUND_DEEPSLATE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ore_bearing_ground/netherrack", Tags.Items.ORE_BEARING_GROUND_NETHERRACK), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ore_bearing_ground/stone", Tags.Items.ORE_BEARING_GROUND_STONE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ore_rates/dense", Tags.Items.ORE_RATES_DENSE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ore_rates/singular", Tags.Items.ORE_RATES_SINGULAR), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ore_rates/sparse", Tags.Items.ORE_RATES_SPARSE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores", Tags.Items.ORES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/coal", Tags.Items.ORES_COAL), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/copper", Tags.Items.ORES_COPPER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/diamond", Tags.Items.ORES_DIAMOND), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/emerald", Tags.Items.ORES_EMERALD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/gold", Tags.Items.ORES_GOLD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/iron", Tags.Items.ORES_IRON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/lapis", Tags.Items.ORES_LAPIS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/netherite_scrap", Tags.Items.ORES_NETHERITE_SCRAP), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/quartz", Tags.Items.ORES_QUARTZ), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores/redstone", Tags.Items.ORES_REDSTONE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores_in_ground/deepslate", Tags.Items.ORES_IN_GROUND_DEEPSLATE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores_in_ground/netherrack", Tags.Items.ORES_IN_GROUND_NETHERRACK), TagConventionLogWarning.createMapEntry(Registries.ITEM, "ores_in_ground/stone", Tags.Items.ORES_IN_GROUND_STONE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_materials", Tags.Items.RAW_MATERIALS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_materials/copper", Tags.Items.RAW_MATERIALS_COPPER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_materials/gold", Tags.Items.RAW_MATERIALS_GOLD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_materials/iron", Tags.Items.RAW_MATERIALS_IRON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "rods", Tags.Items.RODS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "rods/blaze", Tags.Items.RODS_BLAZE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "rods/wooden", Tags.Items.RODS_WOODEN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "rope", Tags.Items.ROPES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "sand", Tags.Items.SANDS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "sand/colorless", Tags.Items.SANDS_COLORLESS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "sand/red", Tags.Items.SANDS_RED), TagConventionLogWarning.createMapEntry(Registries.ITEM, "sandstone", Tags.Items.SANDSTONE_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "seeds", Tags.Items.SEEDS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "seeds/beetroot", Tags.Items.SEEDS_BEETROOT), TagConventionLogWarning.createMapEntry(Registries.ITEM, "seeds/melon", Tags.Items.SEEDS_MELON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "seeds/pumpkin", Tags.Items.SEEDS_PUMPKIN), TagConventionLogWarning.createMapEntry(Registries.ITEM, "seeds/wheat", Tags.Items.SEEDS_WHEAT), TagConventionLogWarning.createMapEntry(Registries.ITEM, "shears", Tags.Items.TOOLS_SHEARS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "slimeballs", Tags.Items.SLIMEBALLS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "stained_glass", Tags.Items.GLASS_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "stained_glass_panes", Tags.Items.GLASS_PANES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "stone", Tags.Items.STONES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks", Tags.Items.STORAGE_BLOCKS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/amethyst", "storage_blocks/amethyst"), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/coal", Tags.Items.STORAGE_BLOCKS_COAL), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/copper", Tags.Items.STORAGE_BLOCKS_COPPER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/diamond", Tags.Items.STORAGE_BLOCKS_DIAMOND), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/emerald", Tags.Items.STORAGE_BLOCKS_EMERALD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/gold", Tags.Items.STORAGE_BLOCKS_GOLD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/iron", Tags.Items.STORAGE_BLOCKS_IRON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/lapis", Tags.Items.STORAGE_BLOCKS_LAPIS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/netherite", Tags.Items.STORAGE_BLOCKS_NETHERITE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/quartz", "storage_blocks/quartz"), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/raw_copper", Tags.Items.STORAGE_BLOCKS_RAW_COPPER), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/raw_gold", Tags.Items.STORAGE_BLOCKS_RAW_GOLD), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/raw_iron", Tags.Items.STORAGE_BLOCKS_RAW_IRON), TagConventionLogWarning.createMapEntry(Registries.ITEM, "storage_blocks/redstone", Tags.Items.STORAGE_BLOCKS_REDSTONE), TagConventionLogWarning.createMapEntry(Registries.ITEM, "string", Tags.Items.STRINGS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools", Tags.Items.TOOLS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/shields", Tags.Items.TOOLS_SHIELDS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/bows", Tags.Items.TOOLS_BOWS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/crossbows", Tags.Items.TOOLS_CROSSBOWS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/fishing_rods", Tags.Items.TOOLS_FISHING_RODS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/tridents", Tags.Items.TOOLS_SPEARS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/brushes", Tags.Items.TOOLS_BRUSHES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "armors", Tags.Items.ARMORS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "armors/helmets", ItemTags.HEAD_ARMOR), TagConventionLogWarning.createMapEntry(Registries.ITEM, "armors/chestplates", ItemTags.CHEST_ARMOR), TagConventionLogWarning.createMapEntry(Registries.ITEM, "armors/leggings", ItemTags.LEG_ARMOR), TagConventionLogWarning.createMapEntry(Registries.ITEM, "armors/boots", ItemTags.FOOT_ARMOR), TagConventionLogWarning.createMapEntry(Registries.ITEM, "wrench", "tools/wrenches"), TagConventionLogWarning.createMapEntry(Registries.ITEM, "wrenches", "tools/wrenches"), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/wrench", "tools/wrenches"), TagConventionLogWarning.createMapEntry(Registries.ITEM, "tools/wrenches", "tools/wrenches"), TagConventionLogWarning.createMapEntry(Registries.ITEM, "food", Tags.Items.FOODS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "foods", Tags.Items.FOODS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fruit", Tags.Items.FOODS_FRUITS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "fruits", Tags.Items.FOODS_FRUITS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "vegetable", Tags.Items.FOODS_VEGETABLES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "vegetables", Tags.Items.FOODS_VEGETABLES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "berry", Tags.Items.FOODS_BERRIES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "berries", Tags.Items.FOODS_BERRIES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "bread", Tags.Items.FOODS_BREADS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "breads", Tags.Items.FOODS_BREADS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cookie", Tags.Items.FOODS_COOKIES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cookies", Tags.Items.FOODS_COOKIES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_meat", Tags.Items.FOODS_RAW_MEATS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_meats", Tags.Items.FOODS_RAW_MEATS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_fish", Tags.Items.FOODS_RAW_FISHES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "raw_fishes", Tags.Items.FOODS_RAW_FISHES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cooked_meat", Tags.Items.FOODS_COOKED_MEATS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cooked_meats", Tags.Items.FOODS_COOKED_MEATS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cooked_fish", Tags.Items.FOODS_COOKED_FISHES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "cooked_fishes", Tags.Items.FOODS_COOKED_FISHES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "soup", Tags.Items.FOODS_SOUPS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "soups", Tags.Items.FOODS_SOUPS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "stew", Tags.Items.FOODS_SOUPS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "stews", Tags.Items.FOODS_SOUPS), TagConventionLogWarning.createMapEntry(Registries.ITEM, "candy", Tags.Items.FOODS_CANDIES), TagConventionLogWarning.createMapEntry(Registries.ITEM, "candies", Tags.Items.FOODS_CANDIES), TagConventionLogWarning.createMapEntry(Registries.FLUID, "water", Tags.Fluids.WATER), TagConventionLogWarning.createMapEntry(Registries.FLUID, "lava", Tags.Fluids.LAVA), TagConventionLogWarning.createMapEntry(Registries.FLUID, "milk", Tags.Fluids.MILK), TagConventionLogWarning.createMapEntry(Registries.FLUID, "gaseous", Tags.Fluids.GASEOUS), TagConventionLogWarning.createMapEntry(Registries.FLUID, "honey", Tags.Fluids.HONEY), TagConventionLogWarning.createMapEntry(Registries.FLUID, "potion", Tags.Fluids.POTION), TagConventionLogWarning.createMapEntry(Registries.FLUID, "plantoil", "plant_oil"), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_hot", Tags.Biomes.IS_HOT), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_hot/overworld", Tags.Biomes.IS_HOT_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_hot/nether", Tags.Biomes.IS_HOT_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_hot/end", Tags.Biomes.IS_HOT_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_cold", Tags.Biomes.IS_COLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_cold/overworld", Tags.Biomes.IS_COLD_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_cold/nether", Tags.Biomes.IS_COLD_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_cold/end", Tags.Biomes.IS_COLD_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_sparse", Tags.Biomes.IS_SPARSE_VEGETATION), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_sparse/overworld", Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_sparse/nether", Tags.Biomes.IS_SPARSE_VEGETATION_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_sparse/end", Tags.Biomes.IS_SPARSE_VEGETATION_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dense", Tags.Biomes.IS_DENSE_VEGETATION), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dense/overworld", Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dense/nether", Tags.Biomes.IS_DENSE_VEGETATION_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dense/end", Tags.Biomes.IS_DENSE_VEGETATION_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_wet", Tags.Biomes.IS_WET), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_wet/overworld", Tags.Biomes.IS_WET_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_wet/nether", Tags.Biomes.IS_WET_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_wet/end", Tags.Biomes.IS_WET_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dry", Tags.Biomes.IS_DRY), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dry/overworld", Tags.Biomes.IS_DRY_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dry/nether", Tags.Biomes.IS_DRY_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dry/end", Tags.Biomes.IS_DRY_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_coniferous", Tags.Biomes.IS_CONIFEROUS_TREE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_savanna", Tags.Biomes.IS_SAVANNA_TREE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_jungle", Tags.Biomes.IS_JUNGLE_TREE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_deciduous", Tags.Biomes.IS_DECIDUOUS_TREE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_spooky", Tags.Biomes.IS_SPOOKY), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_dead", Tags.Biomes.IS_DEAD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_lush", Tags.Biomes.IS_LUSH), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_mushroom", Tags.Biomes.IS_MUSHROOM), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_magical", Tags.Biomes.IS_MAGICAL), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_rare", Tags.Biomes.IS_RARE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_plateau", Tags.Biomes.IS_PLATEAU), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_modified", Tags.Biomes.IS_MODIFIED), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_water", Tags.Biomes.IS_AQUATIC), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_desert", Tags.Biomes.IS_DESERT), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_plains", Tags.Biomes.IS_PLAINS), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_swamp", Tags.Biomes.IS_SWAMP), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_sandy", Tags.Biomes.IS_SANDY), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_snowy", Tags.Biomes.IS_SNOWY), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_wasteland", Tags.Biomes.IS_WASTELAND), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_void", Tags.Biomes.IS_VOID), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_underground", Tags.Biomes.IS_UNDERGROUND), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_cave", Tags.Biomes.IS_CAVE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_peak", Tags.Biomes.IS_MOUNTAIN_PEAK), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_slope", Tags.Biomes.IS_MOUNTAIN_SLOPE), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_mountain", Tags.Biomes.IS_MOUNTAIN), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_end", Tags.Biomes.IS_END), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_nether", Tags.Biomes.IS_NETHER), TagConventionLogWarning.createMapEntry(Registries.BIOME, "is_overworld", Tags.Biomes.IS_OVERWORLD), TagConventionLogWarning.createMapEntry(Registries.BIOME, "no_default_monsters", Tags.Biomes.NO_DEFAULT_MONSTERS));

    private TagConventionLogWarning() {
    }

    static void init() {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        TagConventionLogWarning.setupLegacyTagWarning(forgeBus);
    }

    private static void setupLegacyTagWarning(IEventBus forgeBus) {
        forgeBus.addListener(serverStartingEvent -> {
            LogWarningMode legacyTagWarningMode = (LogWarningMode)((Object)((Object)NeoForgeConfig.COMMON.logLegacyTagWarnings.get()));
            if (legacyTagWarningMode != LogWarningMode.SILENCED) {
                boolean isConfigSetToDev = legacyTagWarningMode == LogWarningMode.DEV_SHORT || legacyTagWarningMode == LogWarningMode.DEV_VERBOSE;
                if (!FMLLoader.isProduction() == isConfigSetToDev) {
                    ObjectArrayList legacyTags = new ObjectArrayList();
                    RegistryAccess.Frozen registryAccess = serverStartingEvent.getServer().registryAccess();
                    registryAccess.registries().forEach(arg_0 -> TagConventionLogWarning.lambda$setupLegacyTagWarning$1((List)legacyTags, arg_0));
                    if (!legacyTags.isEmpty()) {
                        boolean isConfigSetToVerbose;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("\n   Dev warning - Legacy Tags detected. Please migrate your 'forge' namespace tags to the 'c' namespace! See net.neoforged.neoforge.common.Tags.java for all tags.\n   NOTE: Many tags have been moved around or renamed. Some new ones were added so please review the new tags.\n    And make sure you follow tag conventions for new tags! The convention is `c` with nouns generally being plural and adjectives being singular.\n   You can disable this message in NeoForge's common config by setting `logLegacyTagWarnings` to \"SILENCED\" or see individual tags with \"DEV_VERBOSE\".\n");
                        boolean bl = isConfigSetToVerbose = legacyTagWarningMode == LogWarningMode.DEV_VERBOSE || legacyTagWarningMode == LogWarningMode.PROD_VERBOSE;
                        if (isConfigSetToVerbose) {
                            stringBuilder.append("\nLegacy tags:");
                            for (TagKey tagKey : legacyTags) {
                                if (LEGACY_FORGE_TAGS.containsKey(tagKey)) {
                                    TagKey<?> replacementTagkey = LEGACY_FORGE_TAGS.get(tagKey);
                                    stringBuilder.append("\n     ").append(tagKey).append("  ->  ").append(replacementTagkey);
                                    continue;
                                }
                                stringBuilder.append("\n     ").append(tagKey).append("  ->  ").append("See similar `c` tags in NeoForge's Tags class");
                            }
                        }
                        LOGGER.warn((CharSequence)stringBuilder);
                    }
                }
            }
        });
    }

    private static <T> AbstractMap.SimpleEntry<TagKey<T>, TagKey<T>> createMapEntry(ResourceKey<Registry<T>> registryKey, String tagId1, String tagId2) {
        return new AbstractMap.SimpleEntry<TagKey<T>, TagKey<T>>(TagConventionLogWarning.createTagKey(registryKey, "forge", tagId1), TagConventionLogWarning.createTagKey(registryKey, "c", tagId2));
    }

    private static <T, R> AbstractMap.SimpleEntry<TagKey<T>, TagKey<R>> createMapEntry(ResourceKey<Registry<T>> registryKey, String tagId1, TagKey<R> tag2) {
        return new AbstractMap.SimpleEntry<TagKey<T>, TagKey<R>>(TagConventionLogWarning.createTagKey(registryKey, "forge", tagId1), tag2);
    }

    private static <T> TagKey<T> createTagKey(ResourceKey<Registry<T>> registryKey, String namespace, String tagId) {
        return TagKey.create(registryKey, (ResourceLocation)new ResourceLocation(namespace, tagId));
    }

    private static /* synthetic */ void lambda$setupLegacyTagWarning$1(List legacyTags, RegistryAccess.RegistryEntry registryEntry) {
        if (registryEntry.key().location().getNamespace().equals("minecraft")) {
            registryEntry.value().getTagNames().forEach(tagKey -> {
                if (LEGACY_FORGE_TAGS.containsKey(tagKey) || tagKey.location().getNamespace().equals("forge")) {
                    legacyTags.add(tagKey);
                }
            });
        }
    }

    protected static enum LogWarningMode {
        SILENCED,
        DEV_SHORT,
        DEV_VERBOSE,
        PROD_SHORT,
        PROD_VERBOSE;

    }
}

