/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.capabilities;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ItemCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<ItemCapability<?, ?>> registry = new CapabilityRegistry<ItemCapability>(ItemCapability::new);
    final Map<Item, List<ICapabilityProvider<ItemStack, C, T>>> providers = new IdentityHashMap<Item, List<ICapabilityProvider<ItemStack, C, T>>>();

    public static <T, C> ItemCapability<T, C> create(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        return registry.create(name, typeClass, contextClass);
    }

    public static <T> ItemCapability<T, Void> createVoid(ResourceLocation name, Class<T> typeClass) {
        return ItemCapability.create(name, typeClass, Void.TYPE);
    }

    public static synchronized List<ItemCapability<?, ?>> getAll() {
        return registry.getAll();
    }

    private ItemCapability(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    @ApiStatus.Internal
    @Nullable
    public T getCapability(ItemStack stack, C context) {
        if (stack.isEmpty()) {
            return null;
        }
        for (ICapabilityProvider provider : this.providers.getOrDefault(stack.getItem(), List.of())) {
            Object ret = provider.getCapability(stack, context);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

