/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMaps;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.BaseMappedRegistry;

public class RegistrySnapshot {
    private static final Comparator<ResourceLocation> SORTER = ResourceLocation::compareNamespaced;
    public static final StreamCodec<FriendlyByteBuf, RegistrySnapshot> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, RegistrySnapshot>(){

        public RegistrySnapshot decode(FriendlyByteBuf buf) {
            RegistrySnapshot snapshot = new RegistrySnapshot();
            buf.readMap(size -> snapshot.ids, FriendlyByteBuf::readVarInt, FriendlyByteBuf::readResourceLocation);
            buf.readMap(size -> snapshot.aliases, FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readResourceLocation);
            return snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void encode(FriendlyByteBuf buf, RegistrySnapshot snapshot) {
            if (snapshot.binary == null) {
                FriendlyByteBuf pkt = new FriendlyByteBuf(Unpooled.buffer());
                try {
                    pkt.writeMap(snapshot.ids, FriendlyByteBuf::writeVarInt, FriendlyByteBuf::writeResourceLocation);
                    pkt.writeMap(snapshot.aliases, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeResourceLocation);
                    snapshot.binary = new byte[pkt.readableBytes()];
                    pkt.readBytes(snapshot.binary);
                }
                finally {
                    pkt.release();
                }
            }
            buf.writeBytes(snapshot.binary);
        }
    };
    private final Int2ObjectSortedMap<ResourceLocation> ids = new Int2ObjectRBTreeMap();
    private final Int2ObjectSortedMap<ResourceLocation> idsView = Int2ObjectSortedMaps.unmodifiable(this.ids);
    private final Map<ResourceLocation, ResourceLocation> aliases = new TreeMap<ResourceLocation, ResourceLocation>(SORTER);
    private final Map<ResourceLocation, ResourceLocation> aliasesView = Collections.unmodifiableMap(this.aliases);
    @Nullable
    private final Registry<?> fullBackup;
    @Nullable
    private byte[] binary = null;

    private RegistrySnapshot() {
        this.fullBackup = null;
    }

    public <T> RegistrySnapshot(Registry<T> registry, boolean full) {
        registry.keySet().forEach(key -> this.ids.put(registry.getId(key), key));
        this.aliases.putAll(((BaseMappedRegistry)registry).aliases);
        if (full) {
            MappedRegistry backup = new MappedRegistry(registry.key(), registry.registryLifecycle());
            for (Map.Entry entry : registry.entrySet()) {
                ResourceKey key2 = (ResourceKey)entry.getKey();
                Object value = entry.getValue();
                backup.register(registry.getId(key2), key2, value, registry.registrationInfo(key2).orElse(RegistrationInfo.BUILT_IN));
            }
            backup.freeze();
            this.fullBackup = backup;
        } else {
            this.fullBackup = null;
        }
    }

    public Int2ObjectSortedMap<ResourceLocation> getIds() {
        return this.idsView;
    }

    public Map<ResourceLocation, ResourceLocation> getAliases() {
        return this.aliasesView;
    }

    @Nullable
    public <T> Registry<T> getFullBackup() {
        return this.fullBackup;
    }
}

