/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ClientConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.filters.NetworkFilters;
import net.neoforged.neoforge.network.handling.ClientPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.ServerPayloadContext;
import net.neoforged.neoforge.network.negotiation.NegotiableNetworkComponent;
import net.neoforged.neoforge.network.negotiation.NegotiationResult;
import net.neoforged.neoforge.network.negotiation.NetworkComponentNegotiator;
import net.neoforged.neoforge.network.payload.MinecraftRegisterPayload;
import net.neoforged.neoforge.network.payload.MinecraftUnregisterPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkQueryComponent;
import net.neoforged.neoforge.network.payload.ModdedNetworkQueryPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkSetupFailedPayload;
import net.neoforged.neoforge.network.registration.NetworkChannel;
import net.neoforged.neoforge.network.registration.NetworkPayloadSetup;
import net.neoforged.neoforge.network.registration.PayloadRegistration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class NetworkRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<NetworkPayloadSetup> ATTRIBUTE_PAYLOAD_SETUP = AttributeKey.valueOf((String)"neoforge:payload_setup");
    private static final AttributeKey<Set<ResourceLocation>> ATTRIBUTE_ADHOC_CHANNELS = AttributeKey.valueOf((String)"neoforge:adhoc_channels");
    private static final AttributeKey<ConnectionType> ATTRIBUTE_CONNECTION_TYPE = AttributeKey.valueOf((String)"neoforge:connection_type");
    private static final AttributeKey<PacketFlow> ATTRIBUTE_FLOW = AttributeKey.valueOf((String)"neoforge:flow");
    private static final Map<ResourceLocation, StreamCodec<FriendlyByteBuf, ? extends CustomPacketPayload>> BUILTIN_PAYLOADS = ImmutableMap.of((Object)MinecraftRegisterPayload.ID, MinecraftRegisterPayload.STREAM_CODEC, (Object)MinecraftUnregisterPayload.ID, MinecraftUnregisterPayload.STREAM_CODEC, (Object)ModdedNetworkQueryPayload.ID, ModdedNetworkQueryPayload.STREAM_CODEC, (Object)ModdedNetworkPayload.ID, ModdedNetworkPayload.STREAM_CODEC, (Object)ModdedNetworkSetupFailedPayload.ID, ModdedNetworkSetupFailedPayload.STREAM_CODEC);
    private static final Map<ConnectionProtocol, Map<ResourceLocation, PayloadRegistration<?>>> PAYLOAD_REGISTRATIONS = ImmutableMap.of((Object)ConnectionProtocol.CONFIGURATION, new HashMap(), (Object)ConnectionProtocol.PLAY, new HashMap());
    private static boolean setup = false;

    private NetworkRegistry() {
    }

    public static void setup() {
        if (setup) {
            throw new IllegalStateException("The network registry can only be setup once.");
        }
        ModLoader.postEvent((Event)new RegisterPayloadHandlersEvent());
        setup = true;
    }

    public static <T extends CustomPacketPayload, B extends FriendlyByteBuf> void register(CustomPacketPayload.Type<T> type, StreamCodec<? super B, T> codec, IPayloadHandler<T> handler, List<ConnectionProtocol> protocols, Optional<PacketFlow> flow, String version, boolean optional) {
        if (setup) {
            throw new UnsupportedOperationException("Cannot register payload " + String.valueOf(type.id()) + " after registration phase.");
        }
        if (protocols.isEmpty()) {
            throw new UnsupportedOperationException("Cannot register payload " + String.valueOf(type.id()) + " with no protocols.");
        }
        if (version.isBlank()) {
            throw new UnsupportedOperationException("Cannot register payload " + String.valueOf(type.id()) + " with a blank version.");
        }
        if ("minecraft".equals(type.id().getNamespace())) {
            throw new UnsupportedOperationException("Cannot register payload " + String.valueOf(type.id()) + " using the domain \"minecraft\".");
        }
        PayloadRegistration<T> reg = new PayloadRegistration<T>(type, codec, handler, protocols, flow, version.strip(), optional);
        for (ConnectionProtocol protocol : protocols) {
            Map<ResourceLocation, PayloadRegistration<?>> byProtocol = PAYLOAD_REGISTRATIONS.get(protocol);
            if (byProtocol == null) {
                throw new UnsupportedOperationException("Cannot register payload " + String.valueOf(type.id()) + " for unsupported protocol: " + protocol.name());
            }
            if (byProtocol.containsKey(type.id())) {
                throw new UnsupportedOperationException("Cannot register payload " + String.valueOf(type.id()) + " as it is already registered.");
            }
            byProtocol.put(type.id(), reg);
        }
    }

    @Nullable
    public static StreamCodec<? super FriendlyByteBuf, ? extends CustomPacketPayload> getCodec(ResourceLocation id, ConnectionProtocol protocol, PacketFlow flow) {
        if (BUILTIN_PAYLOADS.containsKey(id)) {
            return BUILTIN_PAYLOADS.get(id);
        }
        if (PAYLOAD_REGISTRATIONS.containsKey(protocol)) {
            PayloadRegistration<?> registration = PAYLOAD_REGISTRATIONS.get(protocol).get(id);
            if (registration == null) {
                LOGGER.warn("No registration for payload {}; refusing to decode.", (Object)id);
                return null;
            }
            if (registration.flow().isPresent() && registration.flow().get() != flow) {
                LOGGER.warn("Received {} on the {}, expected to receive on the {}; refusing to decode.", new Object[]{id, flow.getReceptionSide(), registration.flow().get().getReceptionSide()});
                return null;
            }
            return registration.codec();
        }
        LOGGER.error("A packet was received while not in the configuration or play phase.");
        NetworkRegistry.dumpStackToLog();
        return null;
    }

    public static void handleModdedPayload(ServerCommonPacketListener listener, ServerboundCustomPayloadPacket packet) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.warn("Received a modded payload before channel negotiation; disconnecting.");
            listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (No Payload Setup)".formatted(NeoForgeVersion.getVersion())}));
            return;
        }
        ServerPayloadContext context = new ServerPayloadContext(listener, packet.payload().type().id());
        if (PAYLOAD_REGISTRATIONS.containsKey(listener.protocol())) {
            NetworkChannel channel = payloadSetup.getChannel(listener.protocol(), context.payloadId());
            if (channel == null && !NetworkRegistry.hasAdhocChannel(listener.protocol(), context.payloadId(), PacketFlow.SERVERBOUND)) {
                LOGGER.warn("Received a modded payload {} with an unknown or unaccepted channel; disconnecting.", (Object)context.payloadId());
                listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (No Channel for %s)".formatted(NeoForgeVersion.getVersion(), context.payloadId())}));
                return;
            }
            PayloadRegistration<?> registration = PAYLOAD_REGISTRATIONS.get(listener.protocol()).get(context.payloadId());
            if (registration == null) {
                LOGGER.error("Received a modded payload {} with no registration; disconnecting.", (Object)context.payloadId());
                listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (No Handler for %s)".formatted(NeoForgeVersion.getVersion(), context.payloadId())}));
                NetworkRegistry.dumpStackToLog();
                return;
            }
            registration.handler().handle(packet.payload(), context);
        } else {
            LOGGER.error("Received a modded payload {} while not in the configuration or play phase; disconnecting.", (Object)context.payloadId());
            listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (Invalid Protocol %s)".formatted(NeoForgeVersion.getVersion(), listener.protocol().name())}));
        }
    }

    public static void handleModdedPayload(ClientCommonPacketListener listener, ClientboundCustomPayloadPacket packet) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.warn("Received a modded payload before channel negotiation; disconnecting.");
            listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (No Payload Setup)".formatted(NeoForgeVersion.getVersion())}));
            return;
        }
        ClientPayloadContext context = new ClientPayloadContext(listener, packet.payload().type().id());
        if (PAYLOAD_REGISTRATIONS.containsKey(listener.protocol())) {
            NetworkChannel channel = payloadSetup.getChannel(listener.protocol(), context.payloadId());
            if (channel == null && !NetworkRegistry.hasAdhocChannel(listener.protocol(), packet.payload().type().id(), PacketFlow.CLIENTBOUND)) {
                LOGGER.warn("Received a modded payload with an unknown or unaccepted channel; disconnecting.");
                listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (No Channel for %s)".formatted(NeoForgeVersion.getVersion(), context.payloadId())}));
                return;
            }
            PayloadRegistration<?> registration = PAYLOAD_REGISTRATIONS.get(listener.protocol()).get(context.payloadId());
            if (registration == null) {
                LOGGER.error("Received a modded payload with no registration; disconnecting.");
                listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (No Handler for %s)".formatted(NeoForgeVersion.getVersion(), context.payloadId())}));
                NetworkRegistry.dumpStackToLog();
                return;
            }
            registration.handler().handle(packet.payload(), context);
        } else {
            LOGGER.error("Received a modded payload while not in the configuration or play phase. Disconnecting.");
            listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s (Invalid Protocol %s)".formatted(NeoForgeVersion.getVersion(), listener.protocol().name())}));
        }
    }

    public static void initializeModdedConnection(ServerConfigurationPacketListener sender, Map<ConnectionProtocol, Set<ModdedNetworkQueryComponent>> clientChannels) {
        sender.getConnection().channel().attr(ATTRIBUTE_CONNECTION_TYPE).set((Object)sender.getConnectionType());
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.empty());
        sender.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.SERVERBOUND);
        IdentityHashMap<ConnectionProtocol, NegotiationResult> results = new IdentityHashMap<ConnectionProtocol, NegotiationResult>();
        for (ConnectionProtocol protocol : PAYLOAD_REGISTRATIONS.keySet()) {
            NegotiationResult negotiationResult = NetworkComponentNegotiator.negotiate(PAYLOAD_REGISTRATIONS.get(protocol).values().stream().map(NegotiableNetworkComponent::new).toList(), clientChannels.getOrDefault(protocol, Collections.emptySet()).stream().map(NegotiableNetworkComponent::new).toList());
            if (!negotiationResult.success()) {
                if (!negotiationResult.failureReasons().isEmpty()) {
                    sender.send((CustomPacketPayload)new ModdedNetworkSetupFailedPayload(negotiationResult.failureReasons()));
                }
                sender.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
                return;
            }
            results.put(protocol, negotiationResult);
        }
        NetworkPayloadSetup setup = NetworkPayloadSetup.from(results);
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)setup);
        NetworkFilters.injectIfNecessary(sender.getConnection());
        sender.send((CustomPacketPayload)new ModdedNetworkPayload(setup));
        ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
        nowListeningOn.addAll(NetworkRegistry.getInitialServerListeningChannels());
        nowListeningOn.addAll(setup.getChannels(ConnectionProtocol.CONFIGURATION).keySet());
        sender.send((CustomPacketPayload)new MinecraftRegisterPayload((Set<ResourceLocation>)nowListeningOn.build()));
    }

    public static boolean initializeNonModdedConnection(ServerConfigurationPacketListener sender) {
        NetworkFilters.cleanIfNecessary(sender.getConnection());
        sender.getConnection().channel().attr(ATTRIBUTE_CONNECTION_TYPE).set((Object)sender.getConnectionType());
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.empty());
        sender.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.SERVERBOUND);
        for (ConnectionProtocol protocol : PAYLOAD_REGISTRATIONS.keySet()) {
            NegotiationResult negotiationResult = NetworkComponentNegotiator.negotiate(PAYLOAD_REGISTRATIONS.get(protocol).entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((PayloadRegistration)entry.getValue()).version(), ((PayloadRegistration)entry.getValue()).flow(), ((PayloadRegistration)entry.getValue()).optional())).toList(), List.of());
            if (negotiationResult.success()) continue;
            sender.disconnect((Component)Component.translatableWithFallback((String)"neoforge.network.negotiation.failure.vanilla.client.not_supported", (String)"You are trying to connect to a server that is running NeoForge, but you are not. Please install NeoForge Version: %s to connect to this server.", (Object[])new Object[]{NeoForgeVersion.getVersion()}));
            return false;
        }
        NetworkFilters.injectIfNecessary(sender.getConnection());
        ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
        nowListeningOn.addAll(NetworkRegistry.getInitialClientListeningChannels());
        PAYLOAD_REGISTRATIONS.get(ConnectionProtocol.CONFIGURATION).entrySet().stream().filter(registration -> ((PayloadRegistration)registration.getValue()).flow().isEmpty() || ((PayloadRegistration)registration.getValue()).flow().get() == PacketFlow.SERVERBOUND).filter(registration -> ((PayloadRegistration)registration.getValue()).optional()).forEach(registration -> nowListeningOn.add((Object)((ResourceLocation)registration.getKey())));
        sender.send((CustomPacketPayload)new MinecraftRegisterPayload((Set<ResourceLocation>)nowListeningOn.build()));
        return true;
    }

    public static void checkPacket(Packet<?> packet, ServerCommonPacketListener listener) {
        if (packet instanceof ClientboundCustomPayloadPacket) {
            ClientboundCustomPayloadPacket customPayloadPacket = (ClientboundCustomPayloadPacket)packet;
            ResourceLocation id = customPayloadPacket.payload().type().id();
            if (BUILTIN_PAYLOADS.containsKey(id) || "minecraft".equals(id.getNamespace())) {
                return;
            }
            if (NetworkRegistry.hasChannel(listener, customPayloadPacket.payload().type().id())) {
                return;
            }
            throw new UnsupportedOperationException("Payload {} may not be sent to the client!".formatted(customPayloadPacket.payload().type().id()));
        }
    }

    public static void checkPacket(Packet<?> packet, ClientCommonPacketListener listener) {
        if (packet instanceof ServerboundCustomPayloadPacket) {
            ServerboundCustomPayloadPacket customPayloadPacket = (ServerboundCustomPayloadPacket)packet;
            ResourceLocation id = customPayloadPacket.payload().type().id();
            if (BUILTIN_PAYLOADS.containsKey(id) || "minecraft".equals(id.getNamespace())) {
                return;
            }
            if (NetworkRegistry.hasChannel(listener, customPayloadPacket.payload().type().id())) {
                return;
            }
            throw new UnsupportedOperationException("Payload {} may not be sent to the server!".formatted(customPayloadPacket.payload().type().id()));
        }
    }

    private static Set<ResourceLocation> getKnownAdHocChannelsOfOtherEnd(Connection connection) {
        HashSet map = (HashSet)connection.channel().attr(ATTRIBUTE_ADHOC_CHANNELS).get();
        if (map == null) {
            map = new HashSet();
            connection.channel().attr(ATTRIBUTE_ADHOC_CHANNELS).set(map);
        }
        return map;
    }

    private static boolean hasAdhocChannel(ConnectionProtocol protocol, ResourceLocation id, PacketFlow flow) {
        PayloadRegistration reg = (PayloadRegistration)PAYLOAD_REGISTRATIONS.getOrDefault(protocol, Collections.emptyMap()).get(id);
        return reg != null && reg.optional() && (reg.flow().isEmpty() || reg.flow().get() == flow);
    }

    public static void onNetworkQuery(ClientConfigurationPacketListener listener) {
        listener.send((CustomPacketPayload)ModdedNetworkQueryPayload.fromRegistry(PAYLOAD_REGISTRATIONS));
    }

    public static void onModdedNetworkConnectionEstablished(ClientConfigurationPacketListener listener, NetworkPayloadSetup setup) {
        listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)setup);
        listener.getConnection().channel().attr(ATTRIBUTE_CONNECTION_TYPE).set((Object)listener.getConnectionType());
        listener.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.CLIENTBOUND);
        NetworkFilters.injectIfNecessary(listener.getConnection());
        ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
        nowListeningOn.addAll(NetworkRegistry.getInitialClientListeningChannels());
        nowListeningOn.addAll(setup.getChannels(ConnectionProtocol.CONFIGURATION).keySet());
        listener.send((CustomPacketPayload)new MinecraftRegisterPayload((Set<ResourceLocation>)nowListeningOn.build()));
    }

    public static void initializeNonModdedConnection(ClientConfigurationPacketListener sender) {
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.empty());
        sender.getConnection().channel().attr(ATTRIBUTE_CONNECTION_TYPE).set((Object)sender.getConnectionType());
        sender.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.CLIENTBOUND);
        for (ConnectionProtocol protocol : PAYLOAD_REGISTRATIONS.keySet()) {
            NegotiationResult negotiationResult = NetworkComponentNegotiator.negotiate(List.of(), PAYLOAD_REGISTRATIONS.get(protocol).entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((PayloadRegistration)entry.getValue()).version(), ((PayloadRegistration)entry.getValue()).flow(), ((PayloadRegistration)entry.getValue()).optional())).toList());
            if (negotiationResult.success()) continue;
            sender.getConnection().disconnect((Component)Component.translatableWithFallback((String)"neoforge.network.negotiation.failure.vanilla.server.not_supported", (String)"You are trying to connect to a server that is not running NeoForge, but you have mods that require it. A connection could not be established.", (Object[])new Object[]{NeoForgeVersion.getVersion()}));
            return;
        }
        ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        NetworkFilters.injectIfNecessary(sender.getConnection());
        ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
        nowListeningOn.addAll(NetworkRegistry.getInitialClientListeningChannels());
        PAYLOAD_REGISTRATIONS.get(ConnectionProtocol.CONFIGURATION).entrySet().stream().filter(registration -> ((PayloadRegistration)registration.getValue()).flow().isEmpty() || ((PayloadRegistration)registration.getValue()).flow().get() == PacketFlow.CLIENTBOUND).filter(registration -> ((PayloadRegistration)registration.getValue()).optional()).forEach(registration -> nowListeningOn.add((Object)((ResourceLocation)registration.getKey())));
        sender.send((CustomPacketPayload)new MinecraftRegisterPayload((Set<ResourceLocation>)nowListeningOn.build()));
    }

    public static boolean hasChannel(ServerCommonPacketListener listener, ResourceLocation payloadId) {
        return NetworkRegistry.hasChannel(listener.getConnection(), listener.protocol(), payloadId);
    }

    public static boolean hasChannel(ClientCommonPacketListener listener, ResourceLocation payloadId) {
        return NetworkRegistry.hasChannel(listener.getConnection(), listener.protocol(), payloadId);
    }

    public static boolean hasChannel(Connection connection, @Nullable ConnectionProtocol protocol, ResourceLocation payloadId) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)connection.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            return NetworkRegistry.getKnownAdHocChannelsOfOtherEnd(connection).contains(payloadId);
        }
        if (protocol != null && payloadSetup.getChannels(protocol).containsKey(payloadId)) {
            return true;
        }
        if (protocol == null && payloadSetup.channels().values().stream().anyMatch(map -> map.containsKey(payloadId))) {
            return true;
        }
        return NetworkRegistry.getKnownAdHocChannelsOfOtherEnd(connection).contains(payloadId);
    }

    public static <T extends PacketListener> List<Packet<?>> filterGameBundlePackets(ChannelHandlerContext context, Iterable<Packet<? super T>> packets) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)context.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.trace("Somebody tried to filter bundled packets to a client that has not negotiated with the server. Not filtering.");
            return Lists.newArrayList(packets.iterator());
        }
        ArrayList toSend = new ArrayList();
        packets.forEach(packet -> {
            if (!(packet instanceof ClientboundCustomPayloadPacket)) {
                toSend.add((Packet<?>)packet);
                return;
            }
            ClientboundCustomPayloadPacket customPayloadPacket = (ClientboundCustomPayloadPacket)packet;
            ResourceLocation id = customPayloadPacket.payload().type().id();
            if (BUILTIN_PAYLOADS.containsKey(id) || "minecraft".equals(id.getNamespace())) {
                toSend.add((Packet<?>)packet);
                return;
            }
            NetworkChannel channel = payloadSetup.getChannel(ConnectionProtocol.PLAY, customPayloadPacket.payload().type().id());
            if (channel == null) {
                LOGGER.trace("Somebody tried to send: {} to a client which cannot accept it. Not sending packet.", (Object)customPayloadPacket.payload().type().id());
                return;
            }
            toSend.add((Packet<?>)packet);
        });
        return toSend;
    }

    public static void configureMockConnection(Connection connection) {
        connection.channel().attr(ATTRIBUTE_CONNECTION_TYPE).set((Object)ConnectionType.NEOFORGE);
        connection.channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.SERVERBOUND);
        connection.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.empty());
        NetworkPayloadSetup setup = new NetworkPayloadSetup(PAYLOAD_REGISTRATIONS.entrySet().stream().map(entry -> Map.entry((ConnectionProtocol)entry.getKey(), ((Map)entry.getValue()).values().stream().map(reg -> new NetworkChannel(reg.id(), reg.version())).collect(Collectors.toMap(NetworkChannel::id, Function.identity())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        connection.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)setup);
        NetworkFilters.injectIfNecessary(connection);
    }

    public static void onMinecraftRegister(Connection connection, Set<ResourceLocation> resourceLocations) {
        NetworkRegistry.getKnownAdHocChannelsOfOtherEnd(connection).addAll(resourceLocations);
    }

    public static void onMinecraftUnregister(Connection connection, Set<ResourceLocation> resourceLocations) {
        NetworkRegistry.getKnownAdHocChannelsOfOtherEnd(connection).removeAll(resourceLocations);
    }

    public static Set<ResourceLocation> getInitialServerListeningChannels() {
        return BUILTIN_PAYLOADS.keySet();
    }

    public static Set<ResourceLocation> getInitialServerUnregisterChannels() {
        ImmutableSet.Builder nowForgottenChannels = ImmutableSet.builder();
        nowForgottenChannels.add((Object)MinecraftRegisterPayload.ID);
        nowForgottenChannels.add((Object)MinecraftUnregisterPayload.ID);
        PAYLOAD_REGISTRATIONS.get(ConnectionProtocol.PLAY).entrySet().stream().filter(registration -> ((PayloadRegistration)registration.getValue()).flow().isEmpty() || ((PayloadRegistration)registration.getValue()).flow().get() == PacketFlow.SERVERBOUND).filter(registration -> ((PayloadRegistration)registration.getValue()).optional()).forEach(registration -> nowForgottenChannels.add((Object)((ResourceLocation)registration.getKey())));
        return nowForgottenChannels.build();
    }

    private static Set<ResourceLocation> getInitialClientListeningChannels() {
        return BUILTIN_PAYLOADS.keySet();
    }

    public static void onConfigurationFinished(ServerConfigurationPacketListener serverConfigurationPacketListener) {
        NetworkPayloadSetup setup = (NetworkPayloadSetup)serverConfigurationPacketListener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (setup == null) {
            LOGGER.error("Somebody tried to finish the configuration phase of a connection that has not negotiated with the client. Not finishing configuration.");
            return;
        }
        ImmutableSet.Builder notListeningAnymoreOn = ImmutableSet.builder();
        notListeningAnymoreOn.addAll(NetworkRegistry.getInitialServerListeningChannels());
        notListeningAnymoreOn.addAll(setup.getChannels(ConnectionProtocol.CONFIGURATION).keySet());
        serverConfigurationPacketListener.send((CustomPacketPayload)new MinecraftUnregisterPayload((Set<ResourceLocation>)notListeningAnymoreOn.build()));
        ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
        nowListeningOn.add((Object)MinecraftRegisterPayload.ID);
        nowListeningOn.add((Object)MinecraftUnregisterPayload.ID);
        if (serverConfigurationPacketListener.getConnectionType().isNotVanilla()) {
            nowListeningOn.add((Object)ModdedNetworkQueryPayload.ID);
        } else {
            PAYLOAD_REGISTRATIONS.get(ConnectionProtocol.PLAY).entrySet().stream().filter(registration -> ((PayloadRegistration)registration.getValue()).flow().isEmpty() || ((PayloadRegistration)registration.getValue()).flow().get() == PacketFlow.SERVERBOUND).filter(registration -> ((PayloadRegistration)registration.getValue()).optional()).forEach(registration -> nowListeningOn.add((Object)((ResourceLocation)registration.getKey())));
        }
        serverConfigurationPacketListener.send((CustomPacketPayload)new MinecraftRegisterPayload((Set<ResourceLocation>)nowListeningOn.build()));
    }

    public static void onConfigurationFinished(ClientConfigurationPacketListener listener) {
        NetworkPayloadSetup setup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (setup == null) {
            LOGGER.error("Somebody tried to finish the configuration phase of a connection that has not negotiated with the server. Not finishing configuration.");
            return;
        }
        ImmutableSet.Builder notListeningAnymoreOn = ImmutableSet.builder();
        notListeningAnymoreOn.addAll(NetworkRegistry.getInitialClientListeningChannels());
        notListeningAnymoreOn.addAll(setup.getChannels(ConnectionProtocol.CONFIGURATION).keySet());
        listener.send((CustomPacketPayload)new MinecraftUnregisterPayload((Set<ResourceLocation>)notListeningAnymoreOn.build()));
        ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
        nowListeningOn.add((Object)MinecraftRegisterPayload.ID);
        nowListeningOn.add((Object)MinecraftUnregisterPayload.ID);
        if (listener.getConnectionType().isNotVanilla()) {
            nowListeningOn.add((Object)ModdedNetworkQueryPayload.ID);
        } else {
            PAYLOAD_REGISTRATIONS.get(ConnectionProtocol.PLAY).entrySet().stream().filter(registration -> ((PayloadRegistration)registration.getValue()).flow().isEmpty() || ((PayloadRegistration)registration.getValue()).flow().get() == PacketFlow.CLIENTBOUND).filter(registration -> ((PayloadRegistration)registration.getValue()).optional()).forEach(registration -> nowListeningOn.add((Object)((ResourceLocation)registration.getKey())));
        }
        listener.send((CustomPacketPayload)new MinecraftRegisterPayload((Set<ResourceLocation>)nowListeningOn.build()));
    }

    public static ConnectionType getConnectionType(Connection connection) {
        return Objects.requireNonNull((ConnectionType)((Object)connection.channel().attr(ATTRIBUTE_CONNECTION_TYPE).get()), "no connection type on connection!");
    }

    public static <T> CompletableFuture<T> guard(CompletableFuture<T> future, ResourceLocation payloadId) {
        return future.exceptionally(ex -> {
            LOGGER.error("Failed to process a synchronized task of the payload: %s".formatted(payloadId), ex);
            return null;
        });
    }

    public static <T extends PacketListener> void handlePacketUnchecked(Packet<T> packet, PacketListener listener) {
        try {
            packet.handle(listener);
        }
        catch (ClassCastException exception) {
            throw new IllegalStateException("Attempted to handle a packet in a listener that does not support it.", exception);
        }
    }

    private static void dumpStackToLog() {
        LOGGER.error("", (Throwable)new Exception("Stack Trace"));
    }
}

