/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.handling;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerPlayerConnection;
import net.neoforged.neoforge.common.extensions.IServerConfigurationPacketListenerExtension;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record ServerPayloadContext(ServerCommonPacketListener listener, ResourceLocation payloadId) implements IPayloadContext
{
    @Override
    public void reply(CustomPacketPayload payload) {
        this.listener.send(payload);
    }

    @Override
    public void disconnect(Component reason) {
        this.listener.disconnect(reason);
    }

    @Override
    public void handle(Packet<?> packet) {
        NetworkRegistry.handlePacketUnchecked(packet, (PacketListener)this.listener);
    }

    @Override
    public void handle(CustomPacketPayload payload) {
        this.handle((Packet<?>)new ServerboundCustomPayloadPacket(payload));
    }

    @Override
    public CompletableFuture<Void> enqueueWork(Runnable task) {
        if (this.listener.getMainThreadEventLoop().isSameThread()) {
            task.run();
            return CompletableFuture.completedFuture(null);
        }
        return NetworkRegistry.guard(this.listener.getMainThreadEventLoop().submit(task), this.payloadId);
    }

    @Override
    public <T> CompletableFuture<T> enqueueWork(Supplier<T> task) {
        if (this.listener.getMainThreadEventLoop().isSameThread()) {
            return CompletableFuture.completedFuture(task.get());
        }
        return NetworkRegistry.guard(this.listener.getMainThreadEventLoop().submit(task), this.payloadId);
    }

    @Override
    public void finishCurrentTask(ConfigurationTask.Type type) {
        ServerCommonPacketListener serverCommonPacketListener = this.listener;
        if (!(serverCommonPacketListener instanceof IServerConfigurationPacketListenerExtension)) {
            throw new UnsupportedOperationException("Attempted to complete a configuration task outside of the configuration phase!");
        }
        IServerConfigurationPacketListenerExtension ext = (IServerConfigurationPacketListenerExtension)serverCommonPacketListener;
        ext.finishCurrentTask(type);
    }

    @Override
    public ProtocolInfo<?> protocolInfo() {
        return this.listener.getConnection().getInboundProtocol();
    }

    @Override
    public PacketFlow flow() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public ConnectionProtocol protocol() {
        return this.listener.protocol();
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.listener.getConnection().channel().pipeline().lastContext();
    }

    public ServerPlayer player() {
        ServerCommonPacketListener serverCommonPacketListener = this.listener;
        if (serverCommonPacketListener instanceof ServerPlayerConnection) {
            ServerPlayerConnection spc = (ServerPlayerConnection)serverCommonPacketListener;
            return spc.getPlayer();
        }
        throw new UnsupportedOperationException("Cannot retrieve a sending player during the configuration phase.");
    }

    @Override
    public Connection connection() {
        return this.listener.getConnection();
    }
}

