/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.loading;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.DataPackConfig;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.LoadingFailedException;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingWarning;
import net.neoforged.fml.ModWorkManager;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.neoforge.client.gui.LoadingErrorScreen;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.internal.BrandingControl;
import net.neoforged.neoforge.internal.CommonModLoader;
import net.neoforged.neoforge.logging.CrashReportExtender;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforge.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientModLoader
extends CommonModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static boolean loadingComplete;
    @Nullable
    private static LoadingFailedException error;

    public static void begin(Minecraft minecraft, PackRepository defaultResourcePacks, ReloadableResourceManager mcResourceManager) {
        Runtime.getRuntime().addShutdownHook(new Thread(LogManager::shutdown));
        ImmediateWindowHandler.updateProgress((String)"Loading mods");
        loading = true;
        mc = minecraft;
        LogicalSidedProvider.setClient(() -> minecraft);
        LanguageHook.loadBuiltinLanguages();
        try {
            ClientModLoader.begin(ImmediateWindowHandler::renderTick);
        }
        catch (LoadingFailedException e) {
            error = e;
        }
        if (error == null) {
            ResourcePackLoader.populatePackRepository(defaultResourcePacks, PackType.CLIENT_RESOURCES);
            DataPackConfig.DEFAULT.addModPacks(ResourcePackLoader.getDataPackNames());
            mcResourceManager.registerReloadListener(ClientModLoader::onResourceReload);
            mcResourceManager.registerReloadListener((PreparableReloadListener)BrandingControl.resourceManagerReloadListener());
        }
    }

    private static CompletableFuture<Void> onResourceReload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller executeProfiler, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> ClientModLoader.startModLoading(syncExecutor, asyncExecutor), ModWorkManager.parallelExecutor()).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(syncExecutor, asyncExecutor), ModWorkManager.parallelExecutor());
    }

    private static void catchLoadingException(Runnable r) {
        block4: {
            if (loadingComplete) {
                return;
            }
            if (!ModLoader.isLoadingStateValid()) {
                return;
            }
            try {
                r.run();
            }
            catch (LoadingFailedException e) {
                if (error != null) break block4;
                error = e;
            }
        }
    }

    private static void startModLoading(Executor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.catchLoadingException(() -> ClientModLoader.load(syncExecutor, parallelExecutor));
    }

    private static void finishModLoading(Executor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.catchLoadingException(() -> ClientModLoader.finish(syncExecutor, parallelExecutor));
        loading = false;
        loadingComplete = true;
        syncExecutor.execute(() -> ClientModLoader.mc.options.load(true));
    }

    public static VersionChecker.Status checkForUpdates() {
        boolean anyOutdated = ModList.get().getMods().stream().map(VersionChecker::getResult).map(result -> result.status()).anyMatch(status -> status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED);
        return anyOutdated ? VersionChecker.Status.OUTDATED : null;
    }

    public static boolean completeModLoading() {
        List<ModLoadingWarning> warnings = ModLoader.getWarnings();
        boolean showWarnings = true;
        try {
            showWarnings = (Boolean)NeoForgeConfig.CLIENT.showLoadWarnings.get();
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (!showWarnings) {
            if (!warnings.isEmpty()) {
                LOGGER.warn(Logging.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
                warnings.forEach(warning -> LOGGER.warn(Logging.LOADING, warning.formatToString()));
            }
            warnings = Collections.emptyList();
        }
        File dumpedLocation = null;
        if (error == null) {
            NeoForge.EVENT_BUS.start();
        } else {
            LanguageHook.loadBuiltinLanguages();
            dumpedLocation = CrashReportExtender.dumpModLoadingCrashReport(LOGGER, error, ClientModLoader.mc.gameDirectory);
        }
        if (error != null || !warnings.isEmpty()) {
            mc.setScreen((Screen)new LoadingErrorScreen(error, warnings, dumpedLocation));
            return true;
        }
        return false;
    }

    public static boolean isLoading() {
        return loading;
    }
}

