/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CraftingHelper {
    public static Codec<Ingredient> makeIngredientCodec(boolean allowEmpty) {
        Codec compoundIngredientCodec = Codec.lazyInitialized(() -> allowEmpty ? CompoundIngredient.DIRECT_CODEC : CompoundIngredient.DIRECT_CODEC_NONEMPTY);
        return Codec.either((Codec)compoundIngredientCodec, (Codec)CraftingHelper.makeIngredientMapCodec().codec()).xmap(either -> (Ingredient)either.map(ICustomIngredient::toVanilla, i -> i), ingredient -> {
            ICustomIngredient patt0$temp = CraftingHelper.convertToCompoundIngredient(ingredient).getCustomIngredient();
            if (patt0$temp instanceof CompoundIngredient) {
                CompoundIngredient compound = (CompoundIngredient)patt0$temp;
                return Either.left((Object)compound);
            }
            return Either.right((Object)ingredient);
        });
    }

    private static Ingredient convertToCompoundIngredient(Ingredient ingredient) {
        if (!ingredient.isCustom() && ingredient.getValues().length != 1) {
            return CompoundIngredient.of((Ingredient[])Stream.of(ingredient.getValues()).map(v -> Ingredient.fromValues(Stream.of(v))).toArray(Ingredient[]::new));
        }
        return ingredient;
    }

    public static MapCodec<Ingredient> makeIngredientMapCodec() {
        return NeoForgeExtraCodecs.dispatchMapOrElse(NeoForgeRegistries.INGREDIENT_TYPES.byNameCodec(), ICustomIngredient::getType, IngredientType::codec, Ingredient.Value.MAP_CODEC).xmap(either -> (Ingredient)either.map(ICustomIngredient::toVanilla, v -> Ingredient.fromValues(Stream.of(v))), ingredient -> {
            ICustomIngredient customIngredient = CraftingHelper.convertToCompoundIngredient(ingredient).getCustomIngredient();
            if (customIngredient == null) {
                return Either.right((Object)ingredient.getValues()[0]);
            }
            return Either.left((Object)customIngredient);
        }).validate(ingredient -> {
            if (!ingredient.isCustom() && ingredient.getValues().length == 0) {
                return DataResult.error(() -> "Cannot serialize empty ingredient using the map codec");
            }
            return DataResult.success((Object)ingredient);
        });
    }
}

