/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.ModLoadingWarning;
import net.neoforged.neoforge.resource.EmptyPackResources;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ResourcePackLoader {
    public static final String MOD_DATA_ID = "mod_data";
    public static final String MOD_RESOURCES_ID = "mod_resources";
    private static Map<IModFile, Pack.ResourcesSupplier> modResourcePacks;
    private static final Logger LOGGER;
    public static final MetadataSectionType<PackMetadataSection> OPTIONAL_FORMAT;

    public static Optional<Pack.ResourcesSupplier> getPackFor(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(IModFileInfo::getFile).map(mf -> modResourcePacks.get(mf));
    }

    public static void loadResourcePacks(PackRepository resourcePacks, Function<Map<IModFile, Pack.ResourcesSupplier>, RepositorySource> packFinder) {
        ResourcePackLoader.findResourcePacks();
        resourcePacks.addPackFinder(packFinder.apply(modResourcePacks));
    }

    private static synchronized void findResourcePacks() {
        if (modResourcePacks == null) {
            modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(mf -> Pair.of((Object)mf, (Object)ResourcePackLoader.createPackForMod(mf))).collect(Collectors.toMap(p -> ((IModFileInfo)p.getFirst()).getFile(), Pair::getSecond, (u, v) -> {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Duplicate key %s", u));
            }, LinkedHashMap::new));
        }
    }

    public static RepositorySource buildPackFinder(Map<IModFile, Pack.ResourcesSupplier> modResourcePacks, PackType packType) {
        return packAcceptor -> ResourcePackLoader.packFinder(modResourcePacks, packAcceptor, packType);
    }

    private static void packFinder(Map<IModFile, Pack.ResourcesSupplier> modResourcePacks, Consumer<Pack> packAcceptor, PackType packType) {
        ArrayList<Pack> hiddenPacks = new ArrayList<Pack>();
        for (Map.Entry<IModFile, Pack.ResourcesSupplier> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if ("minecraft".equals(mod.getModId())) continue;
            String name = "mod:" + mod.getModId();
            String packName = mod.getOwningFile().getFile().getFileName();
            try {
                Pack modPack;
                boolean isRequired;
                boolean bl = isRequired = packType == PackType.CLIENT_RESOURCES && mod.getOwningFile().showAsResourcePack() || packType == PackType.SERVER_DATA && mod.getOwningFile().showAsDataPack();
                if (isRequired) {
                    modPack = Pack.readMetaAndCreate((String)name, (Component)Component.literal((String)(packName.isEmpty() ? "[unnamed]" : packName)), (boolean)false, (Pack.ResourcesSupplier)e.getValue(), (PackType)packType, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT);
                    if (modPack == null) {
                        ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                        continue;
                    }
                } else {
                    modPack = ResourcePackLoader.readWithOptionalMeta(name, (Component)Component.literal((String)(packName.isEmpty() ? "[unnamed]" : packName)), false, e.getValue(), packType, Pack.Position.BOTTOM, PackSource.DEFAULT);
                }
                if (isRequired) {
                    packAcceptor.accept(modPack);
                    continue;
                }
                hiddenPacks.add(modPack.hidden());
            }
            catch (IOException exception) {
                LOGGER.error("Failed to read pack.mcmeta file of mod {}", (Object)mod.getModId(), (Object)exception);
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
            }
        }
        packAcceptor.accept(ResourcePackLoader.makePack(packType, hiddenPacks));
    }

    public static Pack readWithOptionalMeta(String id, Component title, boolean required, Pack.ResourcesSupplier resources, PackType type, Pack.Position position, PackSource source) throws IOException {
        Pack.Info packInfo = ResourcePackLoader.readInfo(type, resources, id, title);
        return Pack.create((String)id, (Component)title, (boolean)required, (Pack.ResourcesSupplier)resources, (Pack.Info)packInfo, (Pack.Position)position, (boolean)false, (PackSource)source);
    }

    private static Pack.Info readInfo(PackType type, Pack.ResourcesSupplier resources, String id, Component title) throws IOException {
        int currentVersion = SharedConstants.getCurrentVersion().getPackVersion(type);
        try (PackResources primaryResources = resources.openPrimary(id);){
            PackMetadataSection metadata = (PackMetadataSection)primaryResources.getMetadataSection(OPTIONAL_FORMAT);
            FeatureFlagSet flags = Optional.ofNullable((FeatureFlagsMetadataSection)primaryResources.getMetadataSection((MetadataSectionSerializer)FeatureFlagsMetadataSection.TYPE)).map(FeatureFlagsMetadataSection::flags).orElse(FeatureFlagSet.of());
            List overlays = Optional.ofNullable((OverlayMetadataSection)primaryResources.getMetadataSection((MetadataSectionSerializer)OverlayMetadataSection.TYPE)).map(section -> section.overlaysForVersion(currentVersion)).orElse(List.of());
            if (metadata == null) {
                Pack.Info info = new Pack.Info(title, PackCompatibility.COMPATIBLE, flags, overlays, primaryResources.isHidden());
                return info;
            }
            PackCompatibility compatibility = metadata.packFormat() == -1 && metadata.supportedFormats().isEmpty() ? PackCompatibility.COMPATIBLE : PackCompatibility.forVersion((InclusiveRange)Pack.getDeclaredPackVersions((String)id, (PackMetadataSection)metadata), (int)currentVersion);
            Pack.Info info = new Pack.Info(metadata.description(), compatibility, flags, overlays, primaryResources.isHidden());
            return info;
        }
    }

    private static Pack makePack(PackType packType, ArrayList<Pack> hiddenPacks) {
        String id = packType == PackType.CLIENT_RESOURCES ? MOD_RESOURCES_ID : MOD_DATA_ID;
        String name = packType == PackType.CLIENT_RESOURCES ? "Mod Resources" : "Mod Data";
        String descriptionKey = packType == PackType.CLIENT_RESOURCES ? "fml.resources.modresources" : "fml.resources.moddata";
        return Pack.readMetaAndCreate((String)id, (Component)Component.literal((String)name), (boolean)true, (Pack.ResourcesSupplier)new EmptyPackResources.EmptyResourcesSupplier(new PackMetadataSection((Component)Component.translatable((String)descriptionKey, (Object[])new Object[]{hiddenPacks.size()}), SharedConstants.getCurrentVersion().getPackVersion(packType)), false), (PackType)packType, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT).withChildren(hiddenPacks);
    }

    @NotNull
    public static Pack.ResourcesSupplier createPackForMod(IModFileInfo mf) {
        return new PathPackResources.PathResourcesSupplier(mf.getFile().getSecureJar().getRootPath(), true);
    }

    public static List<String> getDataPackNames() {
        ArrayList<String> ids = new ArrayList<String>(ModList.get().getModFiles().stream().filter(IModFileInfo::showAsDataPack).map(IModFileInfo::getFile).map(mf -> "mod:" + ((IModInfo)mf.getModInfos().get(0)).getModId()).filter(n -> !n.equals("mod:minecraft")).toList());
        ids.add(MOD_DATA_ID);
        return ids;
    }

    public static <V> Comparator<Map.Entry<String, V>> getSorter(PackType packType) {
        ArrayList<String> order = new ArrayList<String>();
        order.add("vanilla");
        if (packType == PackType.CLIENT_RESOURCES) {
            order.add(MOD_RESOURCES_ID);
        } else {
            order.add(MOD_DATA_ID);
        }
        ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(e -> ((IModInfo)e.getMods().get(0)).getModId()).map(e -> "mod:" + e).forEach(order::add);
        Object2IntOpenHashMap order_f = new Object2IntOpenHashMap(order.size());
        for (int x = 0; x < order.size(); ++x) {
            order_f.put((Object)((String)order.get(x)), x);
        }
        return (arg_0, arg_1) -> ResourcePackLoader.lambda$getSorter$15((Object2IntMap)order_f, arg_0, arg_1);
    }

    private static /* synthetic */ int lambda$getSorter$15(Object2IntMap order_f, Map.Entry e1, Map.Entry e2) {
        int i2;
        String s1 = (String)e1.getKey();
        String s2 = (String)e2.getKey();
        int i1 = order_f.getOrDefault((Object)s1, -1);
        if (i1 == (i2 = order_f.getOrDefault((Object)s2, -1)) && i1 == -1) {
            return s1.compareTo(s2);
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return i2 - i1;
    }

    static {
        LOGGER = LogManager.getLogger();
        OPTIONAL_FORMAT = MetadataSectionType.fromCodec((String)"pack", (Codec)RecordCodecBuilder.create(in -> in.group((App)ExtraCodecs.strictOptionalField((Codec)ComponentSerialization.CODEC, (String)"description", (Object)Component.empty()).forGetter(PackMetadataSection::description), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"pack_format", (Object)-1).forGetter(PackMetadataSection::packFormat), (App)ExtraCodecs.strictOptionalField((Codec)InclusiveRange.codec((Codec)Codec.INT), (String)"supported_formats").forGetter(PackMetadataSection::supportedFormats)).apply((Applicative)in, PackMetadataSection::new)));
    }
}

