/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import java.util.Optional;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class PlayPayloadHandler<T extends CustomPacketPayload>
implements IPlayPayloadHandler<T> {
    @Nullable
    private final IPlayPayloadHandler<T> clientSide;
    @Nullable
    private final IPlayPayloadHandler<T> serverSide;

    private PlayPayloadHandler(@Nullable IPlayPayloadHandler<T> clientSide, @Nullable IPlayPayloadHandler<T> serverSide) {
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    @Override
    public void handle(T payload, PlayPayloadContext context) {
        if (context.flow().isClientbound()) {
            if (this.clientSide != null) {
                this.clientSide.handle(payload, context);
            }
        } else if (context.flow().isServerbound() && this.serverSide != null) {
            this.serverSide.handle(payload, context);
        }
    }

    Optional<PacketFlow> flow() {
        if (this.clientSide == null && this.serverSide == null) {
            return Optional.empty();
        }
        if (this.clientSide == null) {
            return Optional.of(PacketFlow.SERVERBOUND);
        }
        if (this.serverSide == null) {
            return Optional.of(PacketFlow.CLIENTBOUND);
        }
        return Optional.empty();
    }

    static class Builder<T extends CustomPacketPayload>
    implements IDirectionAwarePayloadHandlerBuilder<T, IPlayPayloadHandler<T>> {
        @Nullable
        private IPlayPayloadHandler<T> clientSide;
        @Nullable
        private IPlayPayloadHandler<T> serverSide;

        Builder() {
        }

        public Builder<T> client(@NotNull IPlayPayloadHandler<T> clientSide) {
            this.clientSide = clientSide;
            return this;
        }

        public Builder<T> server(@NotNull IPlayPayloadHandler<T> serverSide) {
            this.serverSide = serverSide;
            return this;
        }

        PlayPayloadHandler<T> create() {
            return new PlayPayloadHandler<T>(this.clientSide, this.serverSide);
        }
    }
}

