/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ClientConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import net.neoforged.neoforge.network.connection.ConnectionUtils;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.filters.NetworkFilters;
import net.neoforged.neoforge.network.handling.ConfigurationPayloadContext;
import net.neoforged.neoforge.network.handling.IPacketHandler;
import net.neoforged.neoforge.network.handling.IReplyHandler;
import net.neoforged.neoforge.network.handling.ISynchronizedWorkHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.negotiation.NegotiableNetworkComponent;
import net.neoforged.neoforge.network.negotiation.NegotiationResult;
import net.neoforged.neoforge.network.negotiation.NetworkComponentNegotiator;
import net.neoforged.neoforge.network.payload.ModdedNetworkComponent;
import net.neoforged.neoforge.network.payload.ModdedNetworkPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkQueryComponent;
import net.neoforged.neoforge.network.payload.ModdedNetworkQueryPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkSetupFailedPayload;
import net.neoforged.neoforge.network.registration.ConfigurationRegistration;
import net.neoforged.neoforge.network.registration.ModdedPacketRegistrar;
import net.neoforged.neoforge.network.registration.NetworkChannel;
import net.neoforged.neoforge.network.registration.NetworkPayloadSetup;
import net.neoforged.neoforge.network.registration.PlayRegistration;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class NetworkRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<NetworkPayloadSetup> ATTRIBUTE_PAYLOAD_SETUP = AttributeKey.valueOf((String)"neoforge:payload_setup");
    private static final AttributeKey<Boolean> ATTRIBUTE_IS_MODDED_CONNECTION = AttributeKey.valueOf((String)"neoforge:is_modded_connection");
    private static final AttributeKey<PacketFlow> ATTRIBUTE_FLOW = AttributeKey.valueOf((String)"neoforge:flow");
    private static final NetworkRegistry INSTANCE = new NetworkRegistry();
    private boolean setup = false;
    private final Map<ResourceLocation, ConfigurationRegistration<?>> knownConfigurationRegistrations = new HashMap();
    private final Map<ResourceLocation, PlayRegistration<?>> knownPlayRegistrations = new HashMap();

    public static NetworkRegistry getInstance() {
        return INSTANCE;
    }

    private NetworkRegistry() {
    }

    public void setup() {
        if (this.setup) {
            throw new IllegalStateException("The network registry can only be setup once.");
        }
        this.setup = true;
        Map registrarsByNamespace = Collections.synchronizedMap(new HashMap());
        ModLoader.get().postEvent((Event)new RegisterPayloadHandlerEvent(namespace -> registrarsByNamespace.computeIfAbsent(namespace, ModdedPacketRegistrar::new)));
        registrarsByNamespace.values().forEach(ModdedPacketRegistrar::invalidate);
        ImmutableMap.Builder configurationBuilder = ImmutableMap.builder();
        registrarsByNamespace.values().forEach(registrar -> registrar.getConfigurationRegistrations().forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)configurationBuilder).put(arg_0, arg_1)));
        ImmutableMap.Builder playBuilder = ImmutableMap.builder();
        registrarsByNamespace.values().forEach(registrar -> registrar.getPlayRegistrations().forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)playBuilder).put(arg_0, arg_1)));
        this.knownConfigurationRegistrations.clear();
        this.knownPlayRegistrations.clear();
        this.knownConfigurationRegistrations.putAll((Map<ResourceLocation, ConfigurationRegistration<?>>)configurationBuilder.build());
        this.knownPlayRegistrations.putAll((Map<ResourceLocation, PlayRegistration<?>>)playBuilder.build());
    }

    public FriendlyByteBuf.Reader<? extends CustomPacketPayload> getReader(ResourceLocation id, ChannelHandlerContext context, ConnectionProtocol protocol, Map<ResourceLocation, FriendlyByteBuf.Reader<? extends CustomPacketPayload>> knownTypes) {
        if (knownTypes.containsKey(id)) {
            return knownTypes.get(id);
        }
        if (id.equals((Object)ModdedNetworkQueryPayload.ID)) {
            return ModdedNetworkQueryPayload.READER;
        }
        if (id.equals((Object)ModdedNetworkPayload.ID)) {
            return ModdedNetworkPayload.READER;
        }
        if (id.equals((Object)ModdedNetworkSetupFailedPayload.ID)) {
            return ModdedNetworkSetupFailedPayload.READER;
        }
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)context.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        PacketFlow flow = (PacketFlow)context.channel().attr(ATTRIBUTE_FLOW).get();
        if (payloadSetup == null || flow == null) {
            LOGGER.warn("Received a modded custom payload packet {} that has not been negotiated with the server. Not parsing packet.", (Object)id);
            return null;
        }
        if (protocol.isPlay()) {
            NetworkChannel channel = payloadSetup.play().get(id);
            if (channel == null) {
                LOGGER.warn("Received a modded custom payload packet {} with an unknown or not accepted channel. Not parsing packet.", (Object)id);
                return null;
            }
            PlayRegistration<?> registration = this.knownPlayRegistrations.get(channel.id());
            if (registration == null) {
                LOGGER.error("Received a modded custom payload packet {} with an unknown or not accepted channel. Not parsing packet.", (Object)channel.id());
                throw new IllegalStateException("A client sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
            }
            if (registration.flow().isPresent() && registration.flow().get() != flow) {
                LOGGER.warn("Received a modded custom payload packet {} that is not supposed to be sent to the server. Disconnecting client.", (Object)channel.id());
                Connection connection = ConnectionUtils.getConnection(context);
                PacketListener listener = connection.getPacketListener();
                if (listener instanceof ServerGamePacketListener) {
                    ServerGamePacketListener serverListener = (ServerGamePacketListener)listener;
                    serverListener.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{flow}));
                } else if (listener instanceof ClientGamePacketListener) {
                    ClientGamePacketListener clientListener = (ClientGamePacketListener)listener;
                    clientListener.getConnection().disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{flow}));
                } else {
                    LOGGER.error("Received a modded custom payload packet {} that is not supposed to be sent to the server. Disconnecting client, but the listener is not a game listener. This should not happen.", (Object)channel.id());
                    throw new IllegalStateException("A client sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
                }
            }
            return registration;
        }
        if (protocol.isConfiguration()) {
            NetworkChannel channel = payloadSetup.configuration().get(id);
            if (channel == null) {
                LOGGER.warn("Received a modded custom payload packet {} with an unknown or not accepted channel. Not parsing packet.", (Object)id);
                return null;
            }
            ConfigurationRegistration<?> registration = this.knownConfigurationRegistrations.get(channel.id());
            if (registration == null) {
                LOGGER.error("Received a modded custom payload packet {} with an unknown or not accepted channel. Not parsing packet.", (Object)channel.id());
                throw new IllegalStateException("A client sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
            }
            if (registration.flow().isPresent() && registration.flow().get() != flow) {
                LOGGER.warn("Received a modded custom payload packet {} that is not supposed to be sent to the server. Disconnecting client.", (Object)channel.id());
                Connection connection = ConnectionUtils.getConnection(context);
                PacketListener listener = connection.getPacketListener();
                if (listener instanceof ServerGamePacketListener) {
                    ServerGamePacketListener serverListener = (ServerGamePacketListener)listener;
                    serverListener.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{flow}));
                } else if (listener instanceof ClientGamePacketListener) {
                    ClientGamePacketListener clientListener = (ClientGamePacketListener)listener;
                    clientListener.getConnection().disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{flow}));
                } else {
                    LOGGER.error("Received a modded custom payload packet {} that is not supposed to be sent to the server. Disconnecting client, but the listener is not a game listener. This should not happen.", (Object)channel.id());
                    throw new IllegalStateException("A client sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
                }
            }
            return registration;
        }
        LOGGER.error("Received a modded custom payload packet from a client that is not in the configuration or play phase. Not parsing packet.");
        throw new IllegalStateException("A client sent a packet while not in the configuration or play phase. Somebody changed the phases known to NeoForge!");
    }

    public void onModdedPacketAtServer(ServerCommonPacketListener listener, ServerboundCustomPayloadPacket packet) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.warn("Received a modded custom payload packet from a client that has not negotiated with the server. Disconnecting client.");
            listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
            return;
        }
        if (listener instanceof ServerConfigurationPacketListener) {
            ServerConfigurationPacketListener configurationPacketListener = (ServerConfigurationPacketListener)listener;
            NetworkChannel channel = payloadSetup.configuration().get(packet.payload().id());
            if (channel == null) {
                LOGGER.warn("Received a modded custom payload packet from a client with an unknown or not accepted channel. Disconnecting client.");
                listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
                return;
            }
            ConfigurationRegistration<?> registration = this.knownConfigurationRegistrations.get(channel.id());
            if (registration == null) {
                LOGGER.error("Received a modded custom payload packet from a client with an unknown or not accepted channel. Disconnecting client.");
                throw new IllegalStateException("A client sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
            }
            registration.handle(packet.payload(), new ConfigurationPayloadContext(arg_0 -> configurationPacketListener.send(arg_0), new ServerPacketHandler((ServerCommonPacketListener)configurationPacketListener), arg_0 -> configurationPacketListener.finishCurrentTask(arg_0), new EventLoopSynchronizedWorkHandler<CustomPacketPayload>(configurationPacketListener.getMainThreadEventLoop(), packet.payload()), PacketFlow.SERVERBOUND, listener.getConnection().channel().pipeline().lastContext(), Optional.empty()));
        } else if (listener instanceof ServerGamePacketListener) {
            Optional<Player> optional;
            ServerGamePacketListener playPacketListener = (ServerGamePacketListener)listener;
            NetworkChannel channel = payloadSetup.play().get(packet.payload().id());
            if (channel == null) {
                LOGGER.warn("Received a modded custom payload packet from a client with an unknown or not accepted channel. Disconnecting client.");
                listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
                return;
            }
            PlayRegistration<?> registration = this.knownPlayRegistrations.get(channel.id());
            if (registration == null) {
                LOGGER.error("Received a modded custom payload packet from a client with an unknown or not accepted channel. Disconnecting client.");
                throw new IllegalStateException("A client sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
            }
            CustomPacketPayload customPacketPayload = packet.payload();
            IReplyHandler iReplyHandler = arg_0 -> playPacketListener.send(arg_0);
            ServerPacketHandler serverPacketHandler = new ServerPacketHandler((ServerCommonPacketListener)playPacketListener);
            EventLoopSynchronizedWorkHandler<CustomPacketPayload> eventLoopSynchronizedWorkHandler = new EventLoopSynchronizedWorkHandler<CustomPacketPayload>(playPacketListener.getMainThreadEventLoop(), packet.payload());
            ChannelHandlerContext channelHandlerContext = listener.getConnection().channel().pipeline().lastContext();
            if (listener instanceof ServerPlayerConnection) {
                ServerPlayerConnection connection = (ServerPlayerConnection)listener;
                optional = Optional.of(connection.getPlayer());
            } else {
                optional = Optional.empty();
            }
            registration.handle(customPacketPayload, new PlayPayloadContext(iReplyHandler, serverPacketHandler, eventLoopSynchronizedWorkHandler, PacketFlow.SERVERBOUND, channelHandlerContext, optional));
        } else {
            LOGGER.error("Received a modded custom payload packet from a client that is not in the configuration or play phase. Disconnecting client.");
            throw new IllegalStateException("A client sent a packet while not in the configuration or play phase. Somebody changed the phases known to NeoForge!");
        }
    }

    public boolean onModdedPacketAtClient(ClientCommonPacketListener listener, ClientboundCustomPayloadPacket packet) {
        if (packet.payload().id().getNamespace().equals("minecraft")) {
            return false;
        }
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.warn("Received a modded custom payload packet from a server that has not negotiated with the client. Disconnecting server.");
            listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
            return false;
        }
        if (listener instanceof ClientConfigurationPacketListener) {
            ClientConfigurationPacketListener configurationPacketListener = (ClientConfigurationPacketListener)listener;
            NetworkChannel channel = payloadSetup.configuration().get(packet.payload().id());
            if (channel == null) {
                LOGGER.warn("Received a modded custom payload packet from a server with an unknown or not accepted channel. Disconnecting server.");
                listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
                return false;
            }
            ConfigurationRegistration<?> registration = this.knownConfigurationRegistrations.get(channel.id());
            if (registration == null) {
                LOGGER.error("Received a modded custom payload packet from a server with an unknown or not accepted channel. Disconnecting server.");
                throw new IllegalStateException("A server sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
            }
            registration.handle(packet.payload(), new ConfigurationPayloadContext(arg_0 -> configurationPacketListener.send(arg_0), new ClientPacketHandler((ClientCommonPacketListener)configurationPacketListener), task -> LOGGER.warn("Tried to finish a task on the client. This should not happen. Ignoring. Task: {}", (Object)task), new EventLoopSynchronizedWorkHandler<CustomPacketPayload>(configurationPacketListener.getMainThreadEventLoop(), packet.payload()), PacketFlow.CLIENTBOUND, listener.getConnection().channel().pipeline().lastContext(), Optional.ofNullable(configurationPacketListener.getMinecraft().player)));
        } else if (listener instanceof ClientGamePacketListener) {
            ClientGamePacketListener playPacketListener = (ClientGamePacketListener)listener;
            NetworkChannel channel = payloadSetup.play().get(packet.payload().id());
            if (channel == null) {
                LOGGER.warn("Received a modded custom payload packet from a server with an unknown or not accepted channel. Disconnecting server.");
                listener.getConnection().disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
                return false;
            }
            PlayRegistration<?> registration = this.knownPlayRegistrations.get(channel.id());
            if (registration == null) {
                LOGGER.error("Received a modded custom payload packet from a server with an unknown or not accepted channel. Disconnecting server.");
                throw new IllegalStateException("A server sent a packet with an unknown or not accepted channel, while negotiation succeeded. Somebody changed the channels known to NeoForge!");
            }
            registration.handle(packet.payload(), new PlayPayloadContext(arg_0 -> playPacketListener.send(arg_0), new ClientPacketHandler((ClientCommonPacketListener)playPacketListener), new EventLoopSynchronizedWorkHandler<CustomPacketPayload>(playPacketListener.getMainThreadEventLoop(), packet.payload()), PacketFlow.CLIENTBOUND, listener.getConnection().channel().pipeline().lastContext(), Optional.ofNullable(playPacketListener.getMinecraft().player)));
        } else {
            LOGGER.error("Received a modded custom payload packet from a server that is not in the configuration or play phase. Disconnecting server.");
            throw new IllegalStateException("A server sent a packet while not in the configuration or play phase. Somebody changed the phases known to NeoForge!");
        }
        return true;
    }

    public void onModdedConnectionDetectedAtServer(ServerConfigurationPacketListener sender, Set<ModdedNetworkQueryComponent> configuration, Set<ModdedNetworkQueryComponent> play) {
        NegotiationResult configurationNegotiationResult = NetworkComponentNegotiator.negotiate(this.knownConfigurationRegistrations.entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((ConfigurationRegistration)entry.getValue()).version(), ((ConfigurationRegistration)entry.getValue()).flow(), ((ConfigurationRegistration)entry.getValue()).optional())).toList(), configuration.stream().map(entry -> new NegotiableNetworkComponent(entry.id(), entry.version(), entry.flow(), entry.optional())).toList());
        sender.getConnection().channel().attr(ATTRIBUTE_IS_MODDED_CONNECTION).set((Object)true);
        sender.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.SERVERBOUND);
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.emptyModded());
        if (!configurationNegotiationResult.success()) {
            if (!configurationNegotiationResult.failureReasons().isEmpty()) {
                sender.send((CustomPacketPayload)new ModdedNetworkSetupFailedPayload(configurationNegotiationResult.failureReasons()));
            }
            sender.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
            return;
        }
        NegotiationResult playNegotiationResult = NetworkComponentNegotiator.negotiate(this.knownPlayRegistrations.entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((PlayRegistration)entry.getValue()).version(), ((PlayRegistration)entry.getValue()).flow(), ((PlayRegistration)entry.getValue()).optional())).toList(), play.stream().map(entry -> new NegotiableNetworkComponent(entry.id(), entry.version(), entry.flow(), entry.optional())).toList());
        if (!playNegotiationResult.success()) {
            if (!playNegotiationResult.failureReasons().isEmpty()) {
                sender.send((CustomPacketPayload)new ModdedNetworkSetupFailedPayload(playNegotiationResult.failureReasons()));
            }
            sender.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
        }
        NetworkPayloadSetup setup = NetworkPayloadSetup.from(configurationNegotiationResult.components().stream().map(entry -> new NetworkChannel(entry.id(), entry.version())).collect(Collectors.toSet()), playNegotiationResult.components().stream().map(entry -> new NetworkChannel(entry.id(), entry.version())).collect(Collectors.toSet()));
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)setup);
        NetworkFilters.injectIfNecessary(sender.getConnection());
        sender.send((CustomPacketPayload)new ModdedNetworkPayload(setup.configuration().values().stream().map(channel -> new ModdedNetworkComponent(channel.id(), channel.chosenVersion())).collect(Collectors.toSet()), setup.play().values().stream().map(channel -> new ModdedNetworkComponent(channel.id(), channel.chosenVersion())).collect(Collectors.toSet())));
    }

    public boolean onVanillaConnectionDetectedAtServer(ServerConfigurationPacketListener sender) {
        NetworkFilters.cleanIfNecessary(sender.getConnection());
        NegotiationResult configurationNegotiationResult = NetworkComponentNegotiator.negotiate(this.knownConfigurationRegistrations.entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((ConfigurationRegistration)entry.getValue()).version(), ((ConfigurationRegistration)entry.getValue()).flow(), ((ConfigurationRegistration)entry.getValue()).optional())).toList(), List.of());
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.emptyVanilla());
        sender.getConnection().channel().attr(ATTRIBUTE_IS_MODDED_CONNECTION).set((Object)false);
        sender.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.SERVERBOUND);
        if (!configurationNegotiationResult.success()) {
            sender.disconnect((Component)Component.translatable((String)"neoforge.network.negotiation.failure.vanilla.client.not_supported", (Object[])new Object[]{NeoForgeVersion.getVersion()}));
            return false;
        }
        NegotiationResult playNegotiationResult = NetworkComponentNegotiator.negotiate(this.knownPlayRegistrations.entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((PlayRegistration)entry.getValue()).version(), ((PlayRegistration)entry.getValue()).flow(), ((PlayRegistration)entry.getValue()).optional())).toList(), List.of());
        if (!playNegotiationResult.success()) {
            sender.disconnect((Component)Component.translatable((String)"neoforge.network.negotiation.failure.vanilla.client.not_supported", (Object[])new Object[]{NeoForgeVersion.getVersion()}));
            return false;
        }
        NetworkFilters.injectIfNecessary(sender.getConnection());
        return true;
    }

    public boolean canSendPacket(Packet<?> packet, ServerCommonPacketListener listener) {
        if (!(packet instanceof ClientboundCustomPayloadPacket)) {
            return true;
        }
        ClientboundCustomPayloadPacket customPayloadPacket = (ClientboundCustomPayloadPacket)packet;
        if (this.shouldSendPacketRaw(packet)) {
            return true;
        }
        return this.isConnected(listener, customPayloadPacket.payload().id());
    }

    public boolean shouldSendPacketRaw(Packet<?> packet) {
        if (!(packet instanceof ClientboundCustomPayloadPacket)) {
            return true;
        }
        ClientboundCustomPayloadPacket customPayloadPacket = (ClientboundCustomPayloadPacket)packet;
        if (customPayloadPacket.payload() instanceof ModdedNetworkQueryPayload) {
            return true;
        }
        if (customPayloadPacket.payload() instanceof ModdedNetworkSetupFailedPayload) {
            return true;
        }
        if (customPayloadPacket.payload() instanceof ModdedNetworkPayload) {
            return true;
        }
        return ClientboundCustomPayloadPacket.KNOWN_TYPES.containsKey(customPayloadPacket.payload().id());
    }

    public boolean canSendPacket(Packet<?> packet, ClientCommonPacketListener listener) {
        if (!(packet instanceof ServerboundCustomPayloadPacket)) {
            return true;
        }
        ServerboundCustomPayloadPacket customPayloadPacket = (ServerboundCustomPayloadPacket)packet;
        if (customPayloadPacket.payload() instanceof ModdedNetworkQueryPayload) {
            return true;
        }
        if (ServerboundCustomPayloadPacket.KNOWN_TYPES.containsKey(customPayloadPacket.payload().id())) {
            return true;
        }
        return this.isConnected(listener, customPayloadPacket.payload().id());
    }

    public void onNetworkQuery(ClientConfigurationPacketListener listener) {
        ModdedNetworkQueryPayload payload = new ModdedNetworkQueryPayload(this.knownConfigurationRegistrations.entrySet().stream().map(entry -> new ModdedNetworkQueryComponent((ResourceLocation)entry.getKey(), ((ConfigurationRegistration)entry.getValue()).version(), ((ConfigurationRegistration)entry.getValue()).flow(), ((ConfigurationRegistration)entry.getValue()).optional())).collect(Collectors.toSet()), this.knownPlayRegistrations.entrySet().stream().map(entry -> new ModdedNetworkQueryComponent((ResourceLocation)entry.getKey(), ((PlayRegistration)entry.getValue()).version(), ((PlayRegistration)entry.getValue()).flow(), ((PlayRegistration)entry.getValue()).optional())).collect(Collectors.toSet()));
        listener.send((CustomPacketPayload)payload);
    }

    public void onModdedNetworkConnectionEstablished(ClientConfigurationPacketListener listener, Set<ModdedNetworkComponent> configuration, Set<ModdedNetworkComponent> play) {
        NetworkPayloadSetup setup = NetworkPayloadSetup.from(configuration.stream().map(entry -> new NetworkChannel(entry.id(), entry.version())).collect(Collectors.toSet()), play.stream().map(entry -> new NetworkChannel(entry.id(), entry.version())).collect(Collectors.toSet()));
        NetworkFilters.injectIfNecessary(listener.getConnection());
        listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)setup);
        listener.getConnection().channel().attr(ATTRIBUTE_IS_MODDED_CONNECTION).set((Object)true);
        listener.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.CLIENTBOUND);
    }

    public boolean onVanillaNetworkConnectionEstablished(ClientConfigurationPacketListener sender) {
        NetworkFilters.cleanIfNecessary(sender.getConnection());
        NegotiationResult configurationNegotiationResult = NetworkComponentNegotiator.negotiate(List.of(), this.knownConfigurationRegistrations.entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((ConfigurationRegistration)entry.getValue()).version(), ((ConfigurationRegistration)entry.getValue()).flow(), ((ConfigurationRegistration)entry.getValue()).optional())).toList());
        sender.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.emptyVanilla());
        sender.getConnection().channel().attr(ATTRIBUTE_IS_MODDED_CONNECTION).set((Object)false);
        sender.getConnection().channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.CLIENTBOUND);
        if (!configurationNegotiationResult.success()) {
            sender.getConnection().disconnect((Component)Component.translatable((String)"neoforge.network.negotiation.failure.vanilla.client.not_supported", (Object[])new Object[]{NeoForgeVersion.getVersion()}));
            return false;
        }
        NegotiationResult playNegotiationResult = NetworkComponentNegotiator.negotiate(List.of(), this.knownPlayRegistrations.entrySet().stream().map(entry -> new NegotiableNetworkComponent((ResourceLocation)entry.getKey(), ((PlayRegistration)entry.getValue()).version(), ((PlayRegistration)entry.getValue()).flow(), ((PlayRegistration)entry.getValue()).optional())).toList());
        if (!playNegotiationResult.success()) {
            sender.getConnection().disconnect((Component)Component.translatable((String)"neoforge.network.negotiation.failure.vanilla.client.not_supported", (Object[])new Object[]{NeoForgeVersion.getVersion()}));
            return false;
        }
        ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        NetworkFilters.injectIfNecessary(sender.getConnection());
        return true;
    }

    public boolean isVanillaConnection(Connection connection) {
        return connection.channel().attr(ATTRIBUTE_IS_MODDED_CONNECTION).get() == Boolean.FALSE;
    }

    public boolean isConnected(ServerCommonPacketListener listener, ResourceLocation payloadId) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.warn("Somebody tried to send: {} to a client that has not negotiated with the client. Not sending packet.", (Object)payloadId);
            return false;
        }
        if (listener instanceof ServerConfigurationPacketListener) {
            NetworkChannel channel = payloadSetup.configuration().get(payloadId);
            if (channel == null) {
                LOGGER.trace("Somebody tried to send: {} to a client which cannot accept it. Not sending packet.", (Object)payloadId);
                return false;
            }
            return true;
        }
        if (listener instanceof ServerGamePacketListener) {
            NetworkChannel channel = payloadSetup.play().get(payloadId);
            if (channel == null) {
                LOGGER.trace("Somebody tried to send: {} to a client which cannot accept it. Not sending packet.", (Object)payloadId);
                return false;
            }
            return true;
        }
        LOGGER.error("Somebody tried to send: {} to a client that is not in the configuration or play phase. Not sending packet.", (Object)payloadId);
        throw new IllegalStateException("Somebody tried to send a packet while not in the configuration or play phase. Somebody changed the phases known to NeoForge!");
    }

    public boolean isConnected(ClientCommonPacketListener listener, ResourceLocation payloadId) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)listener.getConnection().channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.warn("Somebody tried to send: {} to a server that has not negotiated with the client. Not sending packet.", (Object)payloadId);
            return false;
        }
        if (listener instanceof ClientConfigurationPacketListener) {
            NetworkChannel channel = payloadSetup.configuration().get(payloadId);
            if (channel == null) {
                LOGGER.trace("Somebody tried to send: {} to a server which cannot accept it. Not sending packet.", (Object)payloadId);
                return false;
            }
            return true;
        }
        if (listener instanceof ClientGamePacketListener) {
            NetworkChannel channel = payloadSetup.play().get(payloadId);
            if (channel == null) {
                LOGGER.trace("Somebody tried to send: {} to a server which cannot accept it. Not sending packet.", (Object)payloadId);
                return false;
            }
            return true;
        }
        LOGGER.error("Somebody tried to send: {} to a server that is not in the configuration or play phase. Not sending packet.", (Object)payloadId);
        throw new IllegalStateException("Somebody tried to send a packet while not in the configuration or play phase. Somebody changed the phases known to NeoForge!");
    }

    public <T extends PacketListener> List<Packet<?>> filterGameBundlePackets(ChannelHandlerContext context, Iterable<Packet<? super T>> packets) {
        NetworkPayloadSetup payloadSetup = (NetworkPayloadSetup)context.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).get();
        if (payloadSetup == null) {
            LOGGER.trace("Somebody tried to filter bundled packets to a client that has not negotiated with the server. Not filtering.");
            return Lists.newArrayList(packets.iterator());
        }
        ArrayList toSend = new ArrayList();
        packets.forEach(packet -> {
            if (!(packet instanceof ClientboundCustomPayloadPacket)) {
                toSend.add((Packet<?>)packet);
                return;
            }
            ClientboundCustomPayloadPacket customPayloadPacket = (ClientboundCustomPayloadPacket)packet;
            if (this.shouldSendPacketRaw((Packet<?>)packet)) {
                toSend.add((Packet<?>)packet);
                return;
            }
            NetworkChannel channel = payloadSetup.play().get(customPayloadPacket.payload().id());
            if (channel == null) {
                LOGGER.trace("Somebody tried to send: {} to a client which cannot accept it. Not sending packet.", (Object)customPayloadPacket.payload().id());
                return;
            }
            toSend.add((Packet<?>)packet);
        });
        return toSend;
    }

    public void configureMockConnection(Connection connection) {
        connection.channel().attr(ATTRIBUTE_IS_MODDED_CONNECTION).set((Object)true);
        connection.channel().attr(ATTRIBUTE_FLOW).set((Object)PacketFlow.SERVERBOUND);
        connection.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)NetworkPayloadSetup.emptyModded());
        NetworkPayloadSetup setup = NetworkPayloadSetup.from(this.knownConfigurationRegistrations.entrySet().stream().map(entry -> new NetworkChannel((ResourceLocation)entry.getKey(), ((ConfigurationRegistration)entry.getValue()).version())).collect(Collectors.toSet()), this.knownPlayRegistrations.entrySet().stream().map(entry -> new NetworkChannel((ResourceLocation)entry.getKey(), ((PlayRegistration)entry.getValue()).version())).collect(Collectors.toSet()));
        connection.channel().attr(ATTRIBUTE_PAYLOAD_SETUP).set((Object)setup);
        NetworkFilters.injectIfNecessary(connection);
    }

    private record ServerPacketHandler(ServerCommonPacketListener listener) implements IPacketHandler
    {
        @Override
        public void handle(Packet<?> packet) {
            ServerPacketHandler.resolvePacketGenerics(packet, this.listener());
        }

        @Override
        public void handle(CustomPacketPayload payload) {
            this.handle((Packet<?>)new ServerboundCustomPayloadPacket(payload));
        }

        @Override
        public void disconnect(Component reason) {
            this.listener().disconnect(reason);
        }

        private static <T extends PacketListener> void resolvePacketGenerics(Packet<T> packet, ServerCommonPacketListener listener) {
            try {
                packet.handle((PacketListener)listener);
            }
            catch (ClassCastException exception) {
                throw new IllegalStateException("Somebody tried to handle a packet in a listener that does not support it.", exception);
            }
        }
    }

    private record EventLoopSynchronizedWorkHandler<T>(ReentrantBlockableEventLoop<?> eventLoop, T payload) implements ISynchronizedWorkHandler
    {
        private static final Logger LOGGER = LogUtils.getLogger();

        @Override
        public void execute(Runnable task) {
            this.submitAsync(task).exceptionally(ex -> {
                LOGGER.error("Failed to process a synchronized task of the payload: %s".formatted(this.payload()), ex);
                return null;
            });
        }

        @Override
        public CompletableFuture<Void> submitAsync(Runnable task) {
            return this.eventLoop().submit(task);
        }

        public <R> CompletableFuture<R> submitAsync(Supplier<R> task) {
            return this.eventLoop().submit(task);
        }
    }

    private record ClientPacketHandler(ClientCommonPacketListener listener) implements IPacketHandler
    {
        @Override
        public void handle(Packet<?> packet) {
            ClientPacketHandler.resolvePacketGenerics(packet, this.listener());
        }

        @Override
        public void handle(CustomPacketPayload payload) {
            this.handle((Packet<?>)new ClientboundCustomPayloadPacket(payload));
        }

        @Override
        public void disconnect(Component reason) {
            this.listener().getConnection().disconnect(reason);
        }

        private static <T extends PacketListener> void resolvePacketGenerics(Packet<T> packet, ClientCommonPacketListener listener) {
            try {
                packet.handle((PacketListener)listener);
            }
            catch (ClassCastException exception) {
                throw new IllegalStateException("Somebody tried to handle a packet in a listener that does not support it.", exception);
            }
        }
    }
}

