/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record AdvancedAddEntityPayload(int entityId, byte[] customPayload) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("neoforge", "advanced_add_entity");

    public AdvancedAddEntityPayload(FriendlyByteBuf buf) {
        this(buf.readVarInt(), buf.readByteArray());
    }

    public AdvancedAddEntityPayload(Entity e) {
        this(e.getId(), AdvancedAddEntityPayload.writeCustomData(e));
    }

    private static byte[] writeCustomData(Entity entity) {
        if (!(entity instanceof IEntityWithComplexSpawn)) {
            return new byte[0];
        }
        IEntityWithComplexSpawn additionalSpawnData = (IEntityWithComplexSpawn)entity;
        return FriendlyByteBufUtil.writeCustomData(additionalSpawnData::writeSpawnData);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entityId());
        buffer.writeByteArray(this.customPayload());
    }

    public ResourceLocation id() {
        return ID;
    }
}

