/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.filters;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.Connection;
import net.neoforged.neoforge.network.filters.DynamicChannelHandler;
import net.neoforged.neoforge.network.filters.GenericPacketSplitter;
import net.neoforged.neoforge.network.filters.VanillaConnectionNetworkFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NetworkFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Function<Connection, DynamicChannelHandler>> instances = ImmutableMap.of((Object)"neoforge:vanilla_filter", manager -> new VanillaConnectionNetworkFilter(), (Object)"neoforge:forge_fixes", GenericPacketSplitter::new);

    public static void injectIfNecessary(Connection manager) {
        NetworkFilters.cleanIfNecessary(manager);
        ChannelPipeline pipeline = manager.channel().pipeline();
        if (pipeline.get("packet_handler") == null) {
            return;
        }
        instances.forEach((key, filterFactory) -> {
            DynamicChannelHandler filter = (DynamicChannelHandler)filterFactory.apply(manager);
            if (filter.isNecessary(manager)) {
                pipeline.addBefore("packet_handler", key, (ChannelHandler)filter);
                LOGGER.debug("Injected {} into {}", (Object)filter, (Object)manager);
            }
        });
    }

    public static void cleanIfNecessary(Connection manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        if (pipeline.get("packet_handler") == null) {
            return;
        }
        List<DynamicChannelHandler> toRemove = pipeline.names().stream().map(arg_0 -> ((ChannelPipeline)pipeline).get(arg_0)).filter(DynamicChannelHandler.class::isInstance).map(DynamicChannelHandler.class::cast).toList();
        toRemove.forEach(arg_0 -> ((ChannelPipeline)pipeline).remove(arg_0));
    }

    private NetworkFilters() {
    }
}

