/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.filters;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.filters.DynamicChannelHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.SplitPacketPayload;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="neoforge", bus=Mod.EventBusSubscriber.Bus.MOD)
@ApiStatus.Internal
public class GenericPacketSplitter
extends MessageToMessageEncoder<Packet<?>>
implements DynamicChannelHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_PACKET_SIZE = 0x800000;
    private static final int MAX_PART_SIZE = GenericPacketSplitter.determineMaxPayloadSize(ConnectionProtocol.CONFIGURATION, PacketFlow.SERVERBOUND);
    private static final byte STATE_FIRST = 1;
    private static final byte STATE_LAST = 2;
    private final AttributeKey<ConnectionProtocol.CodecData<?>> codecKey;
    private static final List<byte[]> receivedBuffers = new ArrayList<byte[]>();

    public GenericPacketSplitter(Connection connection) {
        this(GenericPacketSplitter.getProtocolKey(connection.getDirection().getOpposite()));
    }

    public GenericPacketSplitter(AttributeKey<ConnectionProtocol.CodecData<?>> codecKey) {
        this.codecKey = codecKey;
    }

    @SubscribeEvent
    private static void register(RegisterPayloadHandlerEvent event) {
        event.registrar("neoforge").versioned(NeoForgeVersion.getSpec()).optional().common(SplitPacketPayload.ID, SplitPacketPayload::new, GenericPacketSplitter::receivedPacket);
    }

    protected void encode(ChannelHandlerContext ctx, Packet<?> packet, List<Object> out) throws Exception {
        ServerboundCustomPayloadPacket serverboundCustomPayloadPacket;
        ClientboundCustomPayloadPacket clientboundCustomPayloadPacket;
        if (packet instanceof ClientboundCustomPayloadPacket && (clientboundCustomPayloadPacket = (ClientboundCustomPayloadPacket)packet).payload() instanceof SplitPacketPayload) {
            out.add(packet);
            return;
        }
        if (packet instanceof ServerboundCustomPayloadPacket && (serverboundCustomPayloadPacket = (ServerboundCustomPayloadPacket)packet).payload() instanceof SplitPacketPayload) {
            out.add(packet);
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        packet.write(buf);
        if (buf.readableBytes() <= 0x800000) {
            buf.release();
            out.add(packet);
        } else {
            int parts = (int)Math.ceil((double)buf.readableBytes() / (double)MAX_PART_SIZE);
            if (parts == 1) {
                buf.release();
                out.add(packet);
            } else {
                Attribute attribute = ctx.channel().attr(this.codecKey);
                ConnectionProtocol.CodecData codecdata = (ConnectionProtocol.CodecData)attribute.get();
                byte[] packetData = buf.array();
                for (int part = 0; part < parts; ++part) {
                    ByteBuf partPrefix;
                    if (part == 0) {
                        partPrefix = Unpooled.buffer((int)5);
                        partPrefix.writeByte(1);
                        VarInt.write((ByteBuf)partPrefix, (int)codecdata.packetId(packet));
                    } else {
                        partPrefix = Unpooled.buffer((int)1);
                        partPrefix.writeByte(part == parts - 1 ? 2 : 0);
                    }
                    int partSize = Math.min(MAX_PART_SIZE, packetData.length - part * MAX_PART_SIZE);
                    int prefixSize = partPrefix.readableBytes();
                    byte[] payloadSlice = new byte[partSize + prefixSize];
                    partPrefix.readBytes(payloadSlice, 0, prefixSize);
                    System.arraycopy(packetData, part * MAX_PART_SIZE, payloadSlice, prefixSize, partSize);
                    out.add(GenericPacketSplitter.createPacket(codecdata.flow(), payloadSlice));
                    partPrefix.release();
                }
                buf.release();
            }
        }
    }

    private static void receivedPacket(SplitPacketPayload payload, IPayloadContext context) {
        ConnectionProtocol protocol = context.protocol();
        PacketFlow flow = context.flow();
        ChannelHandlerContext channelHandlerContext = context.channelHandlerContext();
        byte state = payload.payload()[0];
        if (state == 1 && !receivedBuffers.isEmpty()) {
            LOGGER.warn("neoforge:split received out of order - inbound buffer not empty when receiving first");
            receivedBuffers.clear();
        }
        int contentSize = payload.payload().length - 1;
        byte[] buffer = new byte[contentSize];
        System.arraycopy(payload.payload(), 1, buffer, 0, contentSize);
        receivedBuffers.add(buffer);
        if (state == 2) {
            byte[][] buffers = (byte[][])receivedBuffers.toArray((T[])new byte[0][]);
            FriendlyByteBuf full = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[][])buffers));
            int packetId = full.readVarInt();
            Packet packet = protocol.codec(flow).createPacket(packetId, full, channelHandlerContext);
            if (packet == null) {
                LOGGER.error("Received invalid packet ID {} in neoforge:split", (Object)packetId);
            } else {
                receivedBuffers.clear();
                full.release();
                context.workHandler().submitAsync(() -> context.packetHandler().handle(packet)).exceptionally(throwable -> {
                    LOGGER.error("Error handling packet", throwable);
                    return null;
                });
            }
        }
    }

    private static Packet<?> createPacket(PacketFlow flow, byte[] payload) {
        return switch (flow) {
            default -> throw new IncompatibleClassChangeError();
            case PacketFlow.SERVERBOUND -> new ServerboundCustomPayloadPacket((CustomPacketPayload)new SplitPacketPayload(payload));
            case PacketFlow.CLIENTBOUND -> new ClientboundCustomPayloadPacket((CustomPacketPayload)new SplitPacketPayload(payload));
        };
    }

    @Override
    public boolean isNecessary(Connection manager) {
        return !manager.isMemoryConnection() && GenericPacketSplitter.isRemoteCompatible(manager);
    }

    public static RemoteCompatibility getRemoteCompatibility(Connection manager) {
        return NetworkRegistry.getInstance().isVanillaConnection(manager) ? RemoteCompatibility.ABSENT : RemoteCompatibility.PRESENT;
    }

    public static boolean isRemoteCompatible(Connection manager) {
        return GenericPacketSplitter.getRemoteCompatibility(manager) != RemoteCompatibility.ABSENT;
    }

    public static int determineMaxPayloadSize(ConnectionProtocol protocol, PacketFlow flow) {
        FriendlyByteBuf temporaryBuf = new FriendlyByteBuf(Unpooled.buffer());
        int packetId = switch (flow) {
            default -> throw new IncompatibleClassChangeError();
            case PacketFlow.SERVERBOUND -> protocol.codec(flow).packetId((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new SplitPacketPayload(new byte[0])));
            case PacketFlow.CLIENTBOUND -> protocol.codec(flow).packetId((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SplitPacketPayload(new byte[0])));
        };
        temporaryBuf.writeVarInt(packetId);
        temporaryBuf.writeResourceLocation(SplitPacketPayload.ID);
        temporaryBuf.writeByte(1);
        temporaryBuf.writeVarInt(Integer.MAX_VALUE);
        temporaryBuf.writeInt(Integer.MAX_VALUE);
        int prefixSize = temporaryBuf.readableBytes();
        return 0x800000 - prefixSize;
    }

    private static AttributeKey<ConnectionProtocol.CodecData<?>> getProtocolKey(PacketFlow flow) {
        return switch (flow) {
            default -> throw new IncompatibleClassChangeError();
            case PacketFlow.CLIENTBOUND -> Connection.ATTRIBUTE_CLIENTBOUND_PROTOCOL;
            case PacketFlow.SERVERBOUND -> Connection.ATTRIBUTE_SERVERBOUND_PROTOCOL;
        };
    }

    public static enum RemoteCompatibility {
        ABSENT,
        PRESENT;

    }
}

