/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.AttachmentInternals;
import net.neoforged.neoforge.fluids.FluidStack;

public interface IFriendlyByteBufExtension {
    private FriendlyByteBuf self() {
        return (FriendlyByteBuf)this;
    }

    default public void writeFluidStack(FluidStack stack) {
        if (stack.isEmpty()) {
            this.self().writeBoolean(false);
        } else {
            this.self().writeBoolean(true);
            stack.writeToPacket(this.self());
        }
    }

    default public FluidStack readFluidStack() {
        return !this.self().readBoolean() ? FluidStack.EMPTY : FluidStack.readFromPacket(this.self());
    }

    default public <T> void writeObjectCollection(Collection<T> set, BiConsumer<T, FriendlyByteBuf> writer) {
        this.self().writeCollection(set, (buf, t) -> writer.accept((Object)t, (FriendlyByteBuf)buf));
    }

    default public ItemStack readItemWithLargeCount() {
        if (!this.self().readBoolean()) {
            return ItemStack.EMPTY;
        }
        Item item = (Item)this.self().readById((IdMap)BuiltInRegistries.ITEM);
        int i = this.self().readVarInt();
        return AttachmentInternals.reconstructItemStack(item, i, this.self().readNbt());
    }

    default public FriendlyByteBuf writeItemWithLargeCount(ItemStack stack) {
        if (stack.isEmpty()) {
            this.self().writeBoolean(false);
        } else {
            this.self().writeBoolean(true);
            Item item = stack.getItem();
            this.self().writeId((IdMap)BuiltInRegistries.ITEM, (Object)item);
            this.self().writeVarInt(stack.getCount());
            CompoundTag compoundtag = new CompoundTag();
            if (item.isDamageable(stack) || item.shouldOverrideMultiplayerNbt()) {
                compoundtag = stack.getTag();
            }
            compoundtag = AttachmentInternals.addAttachmentsToTag(compoundtag, stack, false);
            this.self().writeNbt((Tag)compoundtag);
        }
        return this.self();
    }

    default public <T> T[] readArray(IntFunction<T[]> builder, FriendlyByteBuf.Reader<T> reader) {
        int size = this.self().readVarInt();
        T[] array = builder.apply(size);
        for (int i = 0; i < size; ++i) {
            array[i] = reader.apply((Object)this.self());
        }
        return array;
    }

    default public <T> FriendlyByteBuf writeArray(T[] array, FriendlyByteBuf.Writer<T> writer) {
        this.self().writeVarInt(array.length);
        for (T t : array) {
            writer.accept((Object)this.self(), t);
        }
        return this.self();
    }
}

