/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

public class IntersectionIngredient
extends Ingredient {
    public static final Codec<IntersectionIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.LIST_CODEC.fieldOf("children").forGetter(IntersectionIngredient::getChildren)).apply((Applicative)builder, IntersectionIngredient::new));
    public static final Codec<IntersectionIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("children").forGetter(IntersectionIngredient::getChildren)).apply((Applicative)builder, IntersectionIngredient::new));
    private final List<Ingredient> children;

    protected IntersectionIngredient(List<Ingredient> children) {
        super(children.stream().flatMap(ingredient -> Arrays.stream(ingredient.getValues()).map(value -> {
            ArrayList<Ingredient> matchers = new ArrayList<Ingredient>(children);
            matchers.remove(ingredient);
            return new IntersectionValue((Ingredient.Value)value, (List<Ingredient>)matchers);
        })), NeoForgeMod.INTERSECTION_INGREDIENT_TYPE);
        this.children = Collections.unmodifiableList(children);
    }

    public List<Ingredient> getChildren() {
        return this.children;
    }

    public static Ingredient of(Ingredient ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IntersectionIngredient(Arrays.asList(ingredients));
    }

    public ItemStack[] getItems() {
        if (this.synchronizeWithContents()) {
            return super.getItems();
        }
        ArrayList list = Lists.newArrayList();
        for (Ingredient child : this.children) {
            ItemStack[] stacks = child.getItems();
            Arrays.stream(stacks).filter((Predicate<ItemStack>)((Object)this)).forEach(list::add);
        }
        return (ItemStack[])list.toArray(ItemStack[]::new);
    }

    public boolean test(@Nullable ItemStack p_43914_) {
        if (this.synchronizeWithContents()) {
            return super.test(p_43914_);
        }
        return this.children.stream().allMatch(c -> c.test(p_43914_));
    }

    public boolean synchronizeWithContents() {
        return this.children.stream().allMatch(Ingredient::synchronizeWithContents);
    }

    public boolean isSimple() {
        return false;
    }

    public record IntersectionValue(Ingredient.Value inner, List<Ingredient> other) implements Ingredient.Value
    {
        public Collection<ItemStack> getItems() {
            ArrayList<ItemStack> inner = new ArrayList<ItemStack>(this.inner().getItems());
            inner.removeIf(stack -> !this.other().stream().allMatch(ingredient -> ingredient.test(stack)));
            return inner;
        }
    }
}

