/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.toposort.TopologicalSort;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import net.neoforged.neoforge.network.configuration.SyncTierSortingRegistry;
import net.neoforged.neoforge.network.handling.ConfigurationPayloadContext;
import net.neoforged.neoforge.network.payload.TierSortingRegistryPayload;
import net.neoforged.neoforge.network.payload.TierSortingRegistrySyncCompletePayload;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TierSortingRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ITEM_TIER_ORDERING_JSON = new ResourceLocation("neoforge", "item_tier_ordering.json");
    private static boolean hasCustomTiers = false;
    private static final BiMap<ResourceLocation, Tier> tiers = HashBiMap.create();
    private static final Multimap<ResourceLocation, ResourceLocation> edges = HashMultimap.create();
    private static final Multimap<ResourceLocation, ResourceLocation> vanillaEdges = HashMultimap.create();
    private static final List<Tier> sortedTiers;
    private static final List<Tier> sortedTiersUnmodifiable;

    public static synchronized Tier registerTier(Tier tier, ResourceLocation name, List<Object> after, List<Object> before) {
        if (tiers.containsKey((Object)name)) {
            throw new IllegalStateException("Duplicate tier name " + name);
        }
        TierSortingRegistry.processTier(tier, name, after, before);
        hasCustomTiers = true;
        return tier;
    }

    public static List<Tier> getSortedTiers() {
        return sortedTiersUnmodifiable;
    }

    @Nullable
    public static Tier byName(ResourceLocation name) {
        return (Tier)tiers.get((Object)name);
    }

    @Nullable
    public static ResourceLocation getName(Tier tier) {
        return (ResourceLocation)tiers.inverse().get((Object)tier);
    }

    public static boolean isTierSorted(Tier tier) {
        return TierSortingRegistry.getName(tier) != null;
    }

    public static boolean isCorrectTierForDrops(Tier tier, BlockState state) {
        if (!TierSortingRegistry.isTierSorted(tier)) {
            return TierSortingRegistry.isCorrectTierVanilla(tier, state);
        }
        for (int x = sortedTiers.indexOf(tier) + 1; x < sortedTiers.size(); ++x) {
            TagKey tag = sortedTiers.get(x).getTag();
            if (tag == null || !state.is(tag)) continue;
            return false;
        }
        return true;
    }

    public static List<Tier> getTiersLowerThan(Tier tier) {
        if (!TierSortingRegistry.isTierSorted(tier)) {
            return List.of();
        }
        return sortedTiers.stream().takeWhile(t -> t != tier).toList();
    }

    private static boolean isCorrectTierVanilla(Tier tier, BlockState state) {
        int i = tier.getLevel();
        if (i < 3 && state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return false;
        }
        if (i < 2 && state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return false;
        }
        return i >= 1 || !state.is(BlockTags.NEEDS_STONE_TOOL);
    }

    private static void processTier(Tier tier, ResourceLocation name, List<Object> afters, List<Object> befores) {
        ResourceLocation other;
        tiers.put((Object)name, (Object)tier);
        for (Object after : afters) {
            other = TierSortingRegistry.getTierName(after);
            edges.put((Object)other, (Object)name);
        }
        for (Object before : befores) {
            other = TierSortingRegistry.getTierName(before);
            edges.put((Object)name, (Object)other);
        }
    }

    private static ResourceLocation getTierName(Object entry) {
        if (entry instanceof String) {
            String s = (String)entry;
            return new ResourceLocation(s);
        }
        if (entry instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)entry;
            return rl;
        }
        if (entry instanceof Tier) {
            Tier t = (Tier)entry;
            return Objects.requireNonNull(TierSortingRegistry.getName(t), "Can't have sorting dependencies for tiers not registered in the TierSortingRegistry");
        }
        throw new IllegalStateException("Invalid object type passed into the tier dependencies " + entry.getClass());
    }

    static boolean allowVanilla() {
        return !hasCustomTiers;
    }

    static void init() {
        if (FMLEnvironment.dist.isClient()) {
            ClientEvents.init();
        }
    }

    static PreparableReloadListener getReloadListener() {
        return new SimplePreparableReloadListener<JsonObject>(){
            final Gson gson = new GsonBuilder().create();

            @NotNull
            protected JsonObject prepare(@NotNull ResourceManager resourceManager, ProfilerFiller p) {
                JsonObject jsonObject;
                block9: {
                    Optional res = resourceManager.getResource(ITEM_TIER_ORDERING_JSON);
                    if (res.isEmpty()) {
                        return new JsonObject();
                    }
                    BufferedReader reader = ((Resource)res.get()).openAsReader();
                    try {
                        jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.error("Could not read Tier sorting file " + ITEM_TIER_ORDERING_JSON, (Throwable)e);
                            return new JsonObject();
                        }
                    }
                    ((Reader)reader).close();
                }
                return jsonObject;
            }

            protected void apply(@NotNull JsonObject data, @NotNull ResourceManager resourceManager, ProfilerFiller p) {
                try {
                    if (data.size() > 0) {
                        JsonArray order = GsonHelper.getAsJsonArray((JsonObject)data, (String)"order");
                        ArrayList<Tier> customOrder = new ArrayList<Tier>();
                        for (JsonElement entry : order) {
                            ResourceLocation id = new ResourceLocation(entry.getAsString());
                            Tier tier2 = TierSortingRegistry.byName(id);
                            if (tier2 == null) {
                                throw new IllegalStateException("Tier not found with name " + id);
                            }
                            customOrder.add(tier2);
                        }
                        List<Tier> missingTiers = tiers.values().stream().filter(tier -> !customOrder.contains(tier)).toList();
                        if (!missingTiers.isEmpty()) {
                            throw new IllegalStateException("Tiers missing from the ordered list: " + missingTiers.stream().map(tier -> Objects.toString(TierSortingRegistry.getName(tier))).collect(Collectors.joining(", ")));
                        }
                        TierSortingRegistry.setTierOrder(customOrder);
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing Tier sorting file " + ITEM_TIER_ORDERING_JSON, (Throwable)e);
                }
                TierSortingRegistry.recalculateItemTiers();
            }
        };
    }

    private static void recalculateItemTiers() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        for (Tier tier : tiers.values()) {
            graph.addNode((Object)tier);
        }
        edges.forEach((key, value) -> {
            if (tiers.containsKey(key) && tiers.containsKey(value)) {
                graph.putEdge((Object)((Tier)tiers.get(key)), (Object)((Tier)tiers.get(value)));
            }
        });
        List tierList = TopologicalSort.topologicalSort((Graph)graph, null);
        TierSortingRegistry.setTierOrder(tierList);
    }

    private static void setTierOrder(List<Tier> tierList) {
        TierSortingRegistry.runInServerThreadIfPossible(hasServer -> {
            sortedTiers.clear();
            sortedTiers.addAll(tierList);
        });
    }

    private static void runInServerThreadIfPossible(BooleanConsumer runnable) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> runnable.accept(true));
        } else {
            runnable.accept(false);
        }
    }

    public static void handleSync(TierSortingRegistryPayload payload, ConfigurationPayloadContext context) {
        TierSortingRegistry.setTierOrder(payload.tiers().stream().map(TierSortingRegistry::byName).toList());
        context.replyHandler().send(new TierSortingRegistrySyncCompletePayload());
    }

    public static void sync(ServerConfigurationPacketListener listener, Consumer<CustomPacketPayload> sender) {
        if (listener.isVanillaConnection()) {
            if (TierSortingRegistry.allowVanilla()) {
                listener.finishCurrentTask(SyncTierSortingRegistry.TYPE);
            } else {
                listener.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.incompatible", (Object[])new Object[]{"NeoForge %s".formatted(NeoForgeVersion.getVersion())}));
            }
            return;
        }
        sender.accept(new TierSortingRegistryPayload(TierSortingRegistry.getSortedTiers().stream().map(TierSortingRegistry::getName).toList()));
    }

    static {
        ResourceLocation wood = new ResourceLocation("wood");
        ResourceLocation stone = new ResourceLocation("stone");
        ResourceLocation iron = new ResourceLocation("iron");
        ResourceLocation diamond = new ResourceLocation("diamond");
        ResourceLocation netherite = new ResourceLocation("netherite");
        ResourceLocation gold = new ResourceLocation("gold");
        TierSortingRegistry.processTier((Tier)Tiers.WOOD, wood, List.of(), List.of());
        TierSortingRegistry.processTier((Tier)Tiers.GOLD, gold, List.of(wood), List.of(stone));
        TierSortingRegistry.processTier((Tier)Tiers.STONE, stone, List.of(wood), List.of(iron));
        TierSortingRegistry.processTier((Tier)Tiers.IRON, iron, List.of(stone), List.of(diamond));
        TierSortingRegistry.processTier((Tier)Tiers.DIAMOND, diamond, List.of(iron), List.of(netherite));
        TierSortingRegistry.processTier((Tier)Tiers.NETHERITE, netherite, List.of(diamond), List.of());
        vanillaEdges.putAll(edges);
        sortedTiers = new ArrayList<Tier>();
        sortedTiersUnmodifiable = Collections.unmodifiableList(sortedTiers);
    }

    private static class ClientEvents {
        private ClientEvents() {
        }

        public static void init() {
            NeoForge.EVENT_BUS.addListener(ClientEvents::clientLogInToServer);
        }

        private static void clientLogInToServer(ClientPlayerNetworkEvent.LoggingIn event) {
            if (!event.getConnection().isMemoryConnection()) {
                TierSortingRegistry.recalculateItemTiers();
            }
        }
    }
}

