/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.attachment.IAttachmentComparator;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class AttachmentType<T> {
    final Supplier<T> defaultValueSupplier;
    @Nullable
    final IAttachmentSerializer<?, T> serializer;
    final boolean copyOnDeath;
    final IAttachmentComparator<T> comparator;

    private AttachmentType(Builder<T> builder) {
        this.defaultValueSupplier = builder.defaultValueSupplier;
        this.serializer = builder.serializer;
        this.copyOnDeath = builder.copyOnDeath;
        this.comparator = builder.comparator != null ? builder.comparator : AttachmentType.defaultComparator(this.serializer);
    }

    private static <T> IAttachmentComparator<T> defaultComparator(IAttachmentSerializer<?, T> serializer) {
        if (serializer == null) {
            return (first, second) -> {
                throw new UnsupportedOperationException("Cannot compare non-serializable attachments");
            };
        }
        return (first, second) -> Objects.equals(serializer.write(first), serializer.write(second));
    }

    public static <T> Builder<T> builder(Supplier<T> defaultValueSupplier) {
        return new Builder<T>(defaultValueSupplier);
    }

    public static <S extends Tag, T extends INBTSerializable<S>> Builder<T> serializable(final Supplier<T> defaultValueSupplier) {
        return AttachmentType.builder(defaultValueSupplier).serialize(new IAttachmentSerializer<S, T>(){

            @Override
            public T read(S tag) {
                INBTSerializable ret = (INBTSerializable)defaultValueSupplier.get();
                ret.deserializeNBT(tag);
                return ret;
            }

            @Override
            public S write(T attachment) {
                return attachment.serializeNBT();
            }
        });
    }

    public static class Builder<T> {
        private final Supplier<T> defaultValueSupplier;
        @Nullable
        private IAttachmentSerializer<?, T> serializer;
        private boolean copyOnDeath;
        @Nullable
        private IAttachmentComparator<T> comparator;

        private Builder(Supplier<T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
        }

        public Builder<T> serialize(IAttachmentSerializer<?, T> serializer) {
            Objects.requireNonNull(serializer);
            if (this.serializer != null) {
                throw new IllegalStateException("Serializer already set");
            }
            this.serializer = serializer;
            return this;
        }

        public Builder<T> serialize(final Codec<T> codec) {
            Objects.requireNonNull(codec);
            return this.serialize(new IAttachmentSerializer<Tag, T>(){

                @Override
                public T read(Tag tag) {
                    return codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().get();
                }

                @Override
                public Tag write(T attachment) {
                    return (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, attachment).result().get();
                }
            });
        }

        public Builder<T> copyOnDeath() {
            if (this.serializer == null) {
                throw new IllegalStateException("copyOnDeath requires a serializer");
            }
            this.copyOnDeath = true;
            return this;
        }

        public Builder<T> comparator(IAttachmentComparator<T> comparator) {
            Objects.requireNonNull(comparator);
            if (this.serializer == null) {
                throw new IllegalStateException("comparator requires a serializer");
            }
            this.comparator = comparator;
            return this;
        }

        public AttachmentType<T> build() {
            return new AttachmentType(this);
        }
    }
}

