/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class AttachmentHolder
implements IAttachmentHolder {
    public static final String ATTACHMENTS_NBT_KEY = "neoforge:attachments";
    private static final boolean IN_DEV = !FMLLoader.isProduction();
    final Map<AttachmentType<?>, Object> attachments = new IdentityHashMap();

    private static void validateAttachmentType(AttachmentType<?> type) {
        Objects.requireNonNull(type);
        if (!IN_DEV) {
            return;
        }
        if (!NeoForgeRegistries.ATTACHMENT_TYPES.containsValue(type)) {
            throw new IllegalArgumentException("Data attachment type with default value " + type.defaultValueSupplier.get() + " must be registered!");
        }
    }

    @Override
    public final boolean hasData(AttachmentType<?> type) {
        AttachmentHolder.validateAttachmentType(type);
        return this.attachments.containsKey(type);
    }

    @Override
    public final <T> T getData(AttachmentType<T> type) {
        AttachmentHolder.validateAttachmentType(type);
        return (T)this.attachments.computeIfAbsent(type, t -> Objects.requireNonNull(t.defaultValueSupplier.get()));
    }

    @Override
    @MustBeInvokedByOverriders
    @Nullable
    public <T> T setData(AttachmentType<T> type, T data) {
        AttachmentHolder.validateAttachmentType(type);
        Objects.requireNonNull(data);
        return (T)this.attachments.put(type, data);
    }

    @Nullable
    public final CompoundTag serializeAttachments() {
        CompoundTag tag = null;
        for (Map.Entry<AttachmentType<?>, Object> entry : this.attachments.entrySet()) {
            AttachmentType<?> type = entry.getKey();
            if (type.serializer == null) continue;
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.put(NeoForgeRegistries.ATTACHMENT_TYPES.getKey(type).toString(), type.serializer.write(entry.getValue()));
        }
        return tag;
    }

    protected final void deserializeAttachments(CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            AttachmentType type;
            ResourceLocation keyLocation = ResourceLocation.tryParse((String)key);
            if (keyLocation == null || (type = (AttachmentType)NeoForgeRegistries.ATTACHMENT_TYPES.get(keyLocation)) == null || type.serializer == null) continue;
            this.attachments.put(type, type.serializer.read(tag.get(key)));
        }
    }

    public static <H extends AttachmentHolder> boolean areAttachmentsCompatible(H first, H second) {
        AttachmentType<?> type;
        for (Map.Entry<AttachmentType<?>, Object> entry : first.attachments.entrySet()) {
            type = entry.getKey();
            if (type.serializer == null) continue;
            Object otherData = second.attachments.get(type);
            if (otherData == null) {
                otherData = type.defaultValueSupplier.get();
            }
            if (type.comparator.areCompatible(entry.getValue(), otherData)) continue;
            return false;
        }
        for (Map.Entry<AttachmentType<?>, Object> entry : second.attachments.entrySet()) {
            Object data;
            type = entry.getKey();
            if (type.serializer == null || (data = first.attachments.get(type)) != null) continue;
            data = type.defaultValueSupplier.get();
            if (type.comparator.areCompatible(entry.getValue(), data)) continue;
            return false;
        }
        return true;
    }

    public static class AsField
    extends AttachmentHolder {
        public void deserializeInternal(CompoundTag tag) {
            this.deserializeAttachments(tag);
        }
    }
}

