/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.ICustomQueryPayloadWithBuffer;
import net.neoforged.neoforge.network.INetworkDirection;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.custom.payload.SimpleQueryPayload;

public enum LoginNetworkDirection implements INetworkDirection<LoginNetworkDirection>
{
    LOGIN_TO_SERVER(NetworkEvent.ClientCustomPayloadLoginEvent::new, LogicalSide.CLIENT, ServerboundCustomQueryAnswerPacket.class, 1, (d, i, n) -> new ServerboundCustomQueryAnswerPacket(i, (CustomQueryAnswerPayload)SimpleQueryPayload.outbound(d, i, n))),
    LOGIN_TO_CLIENT(NetworkEvent.ServerCustomPayloadLoginEvent::new, LogicalSide.SERVER, ClientboundCustomQueryPacket.class, 0, (d, i, n) -> new ClientboundCustomQueryPacket(i, (CustomQueryPayload)SimpleQueryPayload.outbound(d, i, n)));

    private final BiFunction<ICustomQueryPayloadWithBuffer, NetworkEvent.Context, NetworkEvent> eventSupplier;
    private final LogicalSide logicalSide;
    private final Class<? extends Packet<?>> packetClass;
    private final int otherWay;
    private final Factory<?> factory;
    private static final Reference2ReferenceArrayMap<Class<? extends Packet<?>>, LoginNetworkDirection> PACKET_LOOKUP;

    private LoginNetworkDirection(BiFunction<ICustomQueryPayloadWithBuffer, NetworkEvent.Context, NetworkEvent> eventSupplier, LogicalSide logicalSide, Class<? extends Packet<?>> clazz, int i, Factory<?> factory) {
        this.eventSupplier = eventSupplier;
        this.logicalSide = logicalSide;
        this.packetClass = clazz;
        this.otherWay = i;
        this.factory = factory;
    }

    private Class<? extends Packet<?>> getPacketClass() {
        return this.packetClass;
    }

    public static <T extends Packet<?>> LoginNetworkDirection directionForPayload(Class<T> customPacket) {
        return (LoginNetworkDirection)PACKET_LOOKUP.get(customPacket);
    }

    @Override
    public LoginNetworkDirection reply() {
        return LoginNetworkDirection.values()[this.otherWay];
    }

    public NetworkEvent getEvent(ICustomQueryPayloadWithBuffer buffer, NetworkEvent.Context context) {
        return this.eventSupplier.apply(buffer, context);
    }

    @Override
    public LogicalSide getOriginationSide() {
        return this.logicalSide;
    }

    @Override
    public LogicalSide getReceptionSide() {
        return this.reply().logicalSide;
    }

    @Override
    public Packet<?> buildPacket(INetworkDirection.PacketData packetData, ResourceLocation channelName) {
        return this.factory.create(packetData.buffer(), packetData.index(), channelName);
    }

    static {
        PACKET_LOOKUP = Stream.of(LoginNetworkDirection.values()).collect(Collectors.toMap(LoginNetworkDirection::getPacketClass, Function.identity(), (m1, m2) -> m1, Reference2ReferenceArrayMap::new));
    }

    private static interface Factory<T extends Packet<?>> {
        public T create(FriendlyByteBuf var1, int var2, ResourceLocation var3);
    }
}

