/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CraftingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CRAFTHELPER = MarkerManager.getMarker((String)"CRAFTHELPER");
    public static final Codec<CompoundTag> TAG_CODEC = ExtraCodecs.withAlternative((Codec)TagParser.AS_CODEC, (Codec)CompoundTag.CODEC);

    @ApiStatus.Internal
    public static Codec<ItemStack> smeltingResultCodec() {
        return ExtraCodecs.either((Codec)BuiltInRegistries.ITEM.byNameCodec(), (Codec)ItemStack.ITEM_WITH_COUNT_CODEC).xmap(either -> (ItemStack)either.map(ItemStack::new, Function.identity()), stack -> {
            if (stack.getCount() != 1) {
                return Either.right((Object)stack);
            }
            CompoundTag tagForWriting = CraftingHelper.getTagForWriting(stack);
            return tagForWriting == null ? Either.left((Object)stack.getItem()) : Either.right((Object)stack);
        });
    }

    @Nullable
    public static CompoundTag getTagForWriting(ItemStack stack) {
        if (ItemStack.matches((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)stack.getItem(), stack.getCount()))) {
            return null;
        }
        return stack.getTag();
    }

    @ApiStatus.Internal
    public static Codec<Ingredient> makeIngredientCodec(boolean allowEmpty, Codec<Ingredient> vanillaCodec) {
        Codec compoundIngredientCodec = ExtraCodecs.lazyInitializedCodec(() -> allowEmpty ? CompoundIngredient.DIRECT_CODEC : CompoundIngredient.DIRECT_CODEC_NONEMPTY);
        return NeoForgeExtraCodecs.withAlternative(compoundIngredientCodec.flatComapMap(Function.identity(), i -> {
            DataResult dataResult;
            if (i instanceof CompoundIngredient) {
                CompoundIngredient c = (CompoundIngredient)((Object)i);
                dataResult = DataResult.success((Object)((Object)c));
            } else {
                dataResult = DataResult.error(() -> "Not a compound ingredient");
            }
            return dataResult;
        }), CraftingHelper.makeIngredientCodec0(allowEmpty, vanillaCodec));
    }

    private static Codec<Ingredient> makeIngredientCodec0(boolean allowEmpty, Codec<Ingredient> vanillaCodec) {
        Codec dispatchCodec = NeoForgeRegistries.INGREDIENT_TYPES.byNameCodec().dispatch(Ingredient::getType, ingredientType -> ingredientType.codec(allowEmpty));
        ExtraCodecs.EitherCodec eitherCodec = ExtraCodecs.either((Codec)dispatchCodec, vanillaCodec);
        return eitherCodec.xmap(either -> (Ingredient)either.map(i -> i, i -> i), ingredient -> {
            if (ingredient.getType() == NeoForgeMod.VANILLA_INGREDIENT_TYPE.get()) {
                return Either.right((Object)ingredient);
            }
            return Either.left((Object)ingredient);
        });
    }
}

