/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class ConditionalOps<T>
extends RegistryOps<T> {
    private final ICondition.IContext context;
    public static final String DEFAULT_CONDITIONS_KEY = "neoforge:conditions";
    public static final String CONDITIONAL_VALUE_KEY = "neoforge:value";

    public static <T> ConditionalOps<T> create(RegistryOps<T> ops, ICondition.IContext context) {
        return new ConditionalOps<T>(ops, context);
    }

    private ConditionalOps(RegistryOps<T> ops, ICondition.IContext context) {
        super(ops);
        this.context = context;
    }

    public static MapCodec<ICondition.IContext> retrieveContext() {
        return ExtraCodecs.retrieveContext(ops -> {
            if (!(ops instanceof ConditionalOps)) {
                return DataResult.success((Object)ICondition.IContext.EMPTY);
            }
            ConditionalOps conditionalOps = (ConditionalOps)((Object)ops);
            return DataResult.success((Object)conditionalOps.context);
        });
    }

    public static <T> Codec<Optional<T>> createConditionalCodec(Codec<T> ownerCodec) {
        return ConditionalOps.createConditionalCodec(ownerCodec, DEFAULT_CONDITIONS_KEY);
    }

    public static <T> Codec<Optional<T>> createConditionalCodec(Codec<T> ownerCodec, String conditionalsKey) {
        return ConditionalOps.createConditionalCodecWithConditions(ownerCodec, conditionalsKey).xmap(r -> r.map(WithConditions::carrier), r -> r.map(i -> new WithConditions<Object>(List.of(), i)));
    }

    public static <T> Codec<List<T>> decodeListWithElementConditions(Codec<T> ownerCodec) {
        return Codec.of((Encoder)ownerCodec.listOf(), NeoForgeExtraCodecs.listWithOptionalElements(ConditionalOps.createConditionalCodec(ownerCodec)));
    }

    public static <T> Codec<Optional<WithConditions<T>>> createConditionalCodecWithConditions(Codec<T> ownerCodec) {
        return ConditionalOps.createConditionalCodecWithConditions(ownerCodec, DEFAULT_CONDITIONS_KEY);
    }

    public static <T> Codec<Optional<WithConditions<T>>> createConditionalCodecWithConditions(Codec<T> ownerCodec, String conditionalsKey) {
        return Codec.of(new ConditionalEncoder<T>(conditionalsKey, ICondition.LIST_CODEC, ownerCodec), new ConditionalDecoder<T>(conditionalsKey, ICondition.LIST_CODEC, (Codec<ICondition.IContext>)ConditionalOps.retrieveContext().codec(), ownerCodec));
    }

    private static final class ConditionalEncoder<A>
    implements Encoder<Optional<WithConditions<A>>> {
        private final String conditionalsPropertyKey;
        public final Codec<List<ICondition>> conditionsCodec;
        private final Encoder<A> innerCodec;

        private ConditionalEncoder(String conditionalsPropertyKey, Codec<List<ICondition>> conditionsCodec, Encoder<A> innerCodec) {
            this.conditionalsPropertyKey = conditionalsPropertyKey;
            this.conditionsCodec = conditionsCodec;
            this.innerCodec = innerCodec;
        }

        public <T> DataResult<T> encode(Optional<WithConditions<A>> input, DynamicOps<T> ops, T prefix) {
            if (ops.compressMaps()) {
                return DataResult.error(() -> "Cannot use ConditionalCodec with compressing DynamicOps");
            }
            if (input.isEmpty()) {
                return DataResult.error(() -> "Cannot encode empty Optional with a ConditionalEncoder. We don't know what to encode to!");
            }
            WithConditions<A> withConditions = input.get();
            if (withConditions.conditions().isEmpty()) {
                return this.innerCodec.encode(withConditions.carrier(), ops, prefix);
            }
            RecordBuilder recordBuilder = ops.mapBuilder();
            recordBuilder.add(this.conditionalsPropertyKey, this.conditionsCodec.encodeStart(ops, withConditions.conditions()));
            DataResult encodedInner = this.innerCodec.encodeStart(ops, withConditions.carrier());
            return encodedInner.flatMap(inner -> ops.getMap(inner).map(innerMap -> {
                if (innerMap.get(this.conditionalsPropertyKey) != null || innerMap.get(ConditionalOps.CONDITIONAL_VALUE_KEY) != null) {
                    return DataResult.error(() -> "Cannot wrap a value that already uses the condition or value key with a ConditionalCodec.");
                }
                innerMap.entries().forEach(pair -> recordBuilder.add(pair.getFirst(), pair.getSecond()));
                return recordBuilder.build(prefix);
            }).result().orElseGet(() -> {
                recordBuilder.add(ConditionalOps.CONDITIONAL_VALUE_KEY, inner);
                return recordBuilder.build(prefix);
            }));
        }

        public String toString() {
            return "Conditional[" + this.innerCodec + "]";
        }
    }

    private static final class ConditionalDecoder<A>
    implements Decoder<Optional<WithConditions<A>>> {
        private final String conditionalsPropertyKey;
        public final Codec<List<ICondition>> conditionsCodec;
        private final Codec<ICondition.IContext> contextCodec;
        private final Decoder<A> innerCodec;

        private ConditionalDecoder(String conditionalsPropertyKey, Codec<List<ICondition>> conditionsCodec, Codec<ICondition.IContext> contextCodec, Decoder<A> innerCodec) {
            this.conditionalsPropertyKey = conditionalsPropertyKey;
            this.conditionsCodec = conditionsCodec;
            this.contextCodec = contextCodec;
            this.innerCodec = innerCodec;
        }

        public <T> DataResult<Pair<Optional<WithConditions<A>>, T>> decode(DynamicOps<T> ops, T input) {
            if (ops.compressMaps()) {
                return DataResult.error(() -> "Cannot use ConditionalCodec with compressing DynamicOps");
            }
            return ops.getMap(input).map(inputMap -> {
                Object conditionsDataCarrier = inputMap.get(this.conditionalsPropertyKey);
                if (conditionsDataCarrier == null) {
                    return this.innerCodec.decode(ops, input).map(result -> result.mapFirst(carrier -> Optional.of(new WithConditions<Object>(carrier))));
                }
                return this.conditionsCodec.decode(ops, conditionsDataCarrier).flatMap(conditionsCarrier -> {
                    List conditions = (List)conditionsCarrier.getFirst();
                    DataResult contextDataResult = this.contextCodec.decode(ops, ops.emptyMap());
                    return contextDataResult.flatMap(contextCarrier -> {
                        DataResult innerDecodeResult;
                        ICondition.IContext context = (ICondition.IContext)contextCarrier.getFirst();
                        boolean conditionsMatch = conditions.stream().allMatch(c -> c.test(context));
                        if (!conditionsMatch) {
                            return DataResult.success((Object)Pair.of(Optional.empty(), (Object)input));
                        }
                        Object valueDataCarrier = inputMap.get(ConditionalOps.CONDITIONAL_VALUE_KEY);
                        if (valueDataCarrier != null) {
                            innerDecodeResult = this.innerCodec.decode(ops, valueDataCarrier);
                        } else {
                            Object conditionalsKey = ops.createString(this.conditionalsPropertyKey);
                            Object mapForDecoding = ops.createMap(inputMap.entries().filter(pair -> !pair.getFirst().equals(conditionalsKey)));
                            innerDecodeResult = this.innerCodec.decode(ops, mapForDecoding);
                        }
                        DataResult ret = innerDecodeResult.map(result -> result.mapFirst(carrier -> Optional.of(new WithConditions<Object>(conditions, carrier))));
                        return ret;
                    });
                });
            }).result().orElseGet(() -> this.innerCodec.decode(ops, input).map(result -> result.mapFirst(carrier -> Optional.of(new WithConditions<Object>(carrier)))));
        }
    }
}

