/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.BaseMapCodec;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;

public class LenientUnboundedMapCodec<K, V>
implements BaseMapCodec<K, V>,
Codec<Map<K, V>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Codec<K> keyCodec;
    private final Codec<V> elementCodec;

    public LenientUnboundedMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        this.keyCodec = keyCodec;
        this.elementCodec = elementCodec;
    }

    public Codec<K> keyCodec() {
        return this.keyCodec;
    }

    public Codec<V> elementCodec() {
        return this.elementCodec;
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        ImmutableMap.Builder read = ImmutableMap.builder();
        input.entries().forEach(pair -> {
            DataResult k = this.keyCodec().parse(ops, pair.getFirst());
            DataResult v = this.elementCodec().parse(ops, pair.getSecond());
            DataResult entry = k.apply2stable(Pair::of, v);
            entry.error().ifPresent(e -> LOGGER.error("Failed to decode key {} for value {}: {}", new Object[]{k, v, e}));
            entry.result().ifPresent(e -> read.put(e.getFirst(), e.getSecond()));
        });
        ImmutableMap elements = read.build();
        return DataResult.success((Object)elements);
    }

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(ops, (Object)map)).map(r -> Pair.of((Object)r, (Object)input));
    }

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LenientUnboundedMapCodec that = (LenientUnboundedMapCodec)o;
        return Objects.equals(this.keyCodec, that.keyCodec) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.keyCodec, this.elementCodec);
    }

    public String toString() {
        return "LenientUnboundedMapCodec[" + this.keyCodec + " -> " + this.elementCodec + "]";
    }
}

