/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaInventoryCodeHooks {
    @Nullable
    public static Boolean extractHook(Level level, Hopper dest) {
        return VanillaInventoryCodeHooks.getSourceItemHandler(level, dest).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.isEmpty()) continue;
                for (int j = 0; j < dest.getContainerSize(); ++j) {
                    ItemStack destStack = dest.getItem(j);
                    if (!dest.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= dest.getMaxStackSize() || !ItemHandlerHelper.canItemStacksStack(extractItem, destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.isEmpty()) {
                        dest.setItem(j, extractItem);
                    } else {
                        destStack.grow(1);
                        dest.setItem(j, destStack);
                    }
                    dest.setChanged();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean dropperInsertHook(Level level, BlockPos pos, DispenserBlockEntity dropper, int slot, @NotNull ItemStack stack) {
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)DropperBlock.FACING);
        return VanillaInventoryCodeHooks.getAttachedItemHandler(level, pos, facing).map(destinationResult -> {
            ItemStack dispensedStack;
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots((BlockEntity)dropper, destination, itemHandler, dispensedStack = stack.copy().split(1));
            if (remainder.isEmpty()) {
                remainder = stack.copy();
                remainder.shrink(1);
            } else {
                remainder = stack.copy();
            }
            dropper.setItem(slot, remainder);
            return false;
        }).orElse(true);
    }

    public static boolean insertHook(HopperBlockEntity hopper) {
        Direction hopperFacing = (Direction)hopper.getBlockState().getValue((Property)HopperBlock.FACING);
        return VanillaInventoryCodeHooks.getAttachedItemHandler(hopper.getLevel(), hopper.getBlockPos(), hopperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (VanillaInventoryCodeHooks.isFull(itemHandler)) {
                return false;
            }
            for (int i = 0; i < hopper.getContainerSize(); ++i) {
                if (hopper.getItem(i).isEmpty()) continue;
                ItemStack originalSlotContents = hopper.getItem(i).copy();
                ItemStack insertStack = hopper.removeItem(i, 1);
                ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots((BlockEntity)hopper, destination, itemHandler, insertStack);
                if (remainder.isEmpty()) {
                    return true;
                }
                hopper.setItem(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = VanillaInventoryCodeHooks.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).isEmpty()) {
            HopperBlockEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = VanillaInventoryCodeHooks.isEmpty(destInventory);
            if (itemstack.isEmpty()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.EMPTY;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack(itemstack, stack)) {
                int originalSize = stack.getCount();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).getCount();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof HopperBlockEntity && !(destinationHopper = (HopperBlockEntity)destination).isOnCustomCooldown()) {
                int k = 0;
                if (source instanceof HopperBlockEntity && destinationHopper.getLastUpdateTime() >= ((HopperBlockEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationHopper.setCooldown(8 - k);
            }
        }
        return stack;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    private static Optional<Pair<IItemHandler, Object>> getAttachedItemHandler(Level level, BlockPos pos, Direction direction) {
        return VanillaInventoryCodeHooks.getItemHandlerAt(level, (double)(pos.getX() + direction.getStepX()) + 0.5, (double)(pos.getY() + direction.getStepY()) + 0.5, (double)(pos.getZ() + direction.getStepZ()) + 0.5, direction.getOpposite());
    }

    private static Optional<Pair<IItemHandler, Object>> getSourceItemHandler(Level level, Hopper hopper) {
        return VanillaInventoryCodeHooks.getItemHandlerAt(level, hopper.getLevelX(), hopper.getLevelY() + 1.0, hopper.getLevelZ(), Direction.DOWN);
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandlerAt(Level worldIn, double x, double y, double z, Direction side) {
        Entity entity;
        IItemHandler entityCap;
        BlockPos blockpos;
        BlockState state;
        BlockEntity blockEntity = (state = worldIn.getBlockState(blockpos = BlockPos.containing((double)x, (double)y, (double)z))).hasBlockEntity() ? worldIn.getBlockEntity(blockpos) : null;
        IItemHandler blockCap = (IItemHandler)worldIn.getCapability(Capabilities.ItemHandler.BLOCK, blockpos, state, blockEntity, (Object)side);
        if (blockCap != null) {
            return Optional.of(ImmutablePair.of((Object)blockCap, (Object)blockEntity));
        }
        List list = worldIn.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.ENTITY_STILL_ALIVE);
        if (!list.isEmpty() && (entityCap = (IItemHandler)(entity = (Entity)list.get(worldIn.random.nextInt(list.size()))).getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side)) != null) {
            return Optional.of(ImmutablePair.of((Object)entityCap, (Object)entity));
        }
        return Optional.empty();
    }
}

