/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.simple;

import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.neoforged.neoforge.network.INetworkDirection;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.NetworkInstance;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.PlayNetworkDirection;
import net.neoforged.neoforge.network.simple.IndexedMessageCodec;
import net.neoforged.neoforge.network.simple.MessageFunctions;
import net.neoforged.neoforge.network.simple.SimpleLoginMessage;
import net.neoforged.neoforge.network.simple.SimpleMessage;

public class SimpleChannel {
    private final NetworkInstance instance;
    private final IndexedMessageCodec indexedCodec;
    private final Optional<Consumer<NetworkEvent.ChannelRegistrationChangeEvent>> registryChangeConsumer;
    private final List<LoginPacketEntry> loginPackets = new ArrayList<LoginPacketEntry>();

    public SimpleChannel(NetworkInstance instance) {
        this(instance, Optional.empty());
    }

    private SimpleChannel(NetworkInstance instance, Optional<Consumer<NetworkEvent.ChannelRegistrationChangeEvent>> registryChangeNotify) {
        this.instance = instance;
        this.indexedCodec = new IndexedMessageCodec(instance);
        instance.addListener(this::networkEventListener);
        instance.addGatherListener(this::networkLoginGather);
        this.registryChangeConsumer = registryChangeNotify;
    }

    public SimpleChannel(NetworkInstance instance, Consumer<NetworkEvent.ChannelRegistrationChangeEvent> registryChangeNotify) {
        this(instance, Optional.of(registryChangeNotify));
    }

    private void networkLoginGather(NetworkEvent.GatherLoginPayloadsEvent gatherEvent) {
        this.loginPackets.forEach(packetGenerator -> packetGenerator.generator.generate(gatherEvent.isLocal()).forEach(p -> {
            FriendlyByteBuf pb = new FriendlyByteBuf(Unpooled.buffer());
            this.indexedCodec.build(p.msg(), pb);
            gatherEvent.add(pb, this.instance.getChannelName(), p.context(), packetGenerator.needsResponse);
        }));
    }

    private void networkEventListener(NetworkEvent networkEvent) {
        if (networkEvent instanceof NetworkEvent.ChannelRegistrationChangeEvent) {
            this.registryChangeConsumer.ifPresent(l -> l.accept((NetworkEvent.ChannelRegistrationChangeEvent)networkEvent));
        } else {
            this.indexedCodec.consume(networkEvent.getPayload(), networkEvent.getLoginIndex(), networkEvent.getSource());
        }
    }

    public <MSG> int encodeMessage(MSG message, FriendlyByteBuf target) {
        return this.indexedCodec.build(message, target);
    }

    public <MSG> IndexedMessageCodec.MessageHandler<MSG> registerMessage(int index, Class<MSG> messageType, MessageFunctions.MessageEncoder<MSG> encoder, MessageFunctions.MessageDecoder<MSG> decoder, MessageFunctions.MessageConsumer<MSG> messageConsumer) {
        return this.registerMessage(index, messageType, encoder, decoder, messageConsumer, Optional.empty());
    }

    public <MSG> IndexedMessageCodec.MessageHandler<MSG> registerMessage(int index, Class<MSG> messageType, MessageFunctions.MessageEncoder<MSG> encoder, MessageFunctions.MessageDecoder<MSG> decoder, MessageFunctions.MessageConsumer<MSG> messageConsumer, Optional<INetworkDirection<?>> networkDirection) {
        return this.indexedCodec.addCodecIndex(index, messageType, encoder, decoder, messageConsumer, networkDirection);
    }

    private <MSG> INetworkDirection.PacketData toBuffer(MSG msg) {
        FriendlyByteBuf bufIn = new FriendlyByteBuf(Unpooled.buffer());
        int index = this.encodeMessage(msg, bufIn);
        return new INetworkDirection.PacketData(bufIn, index);
    }

    public <MSG> void sendToServer(MSG message) {
        this.sendTo(message, Minecraft.getInstance().getConnection().getConnection(), PlayNetworkDirection.PLAY_TO_SERVER);
    }

    public <MSG> void sendTo(MSG message, Connection manager, PlayNetworkDirection direction) {
        manager.send(this.toVanillaPacket(message, direction));
    }

    public <MSG> void send(PacketDistributor.PacketTarget target, MSG message) {
        target.send(this.toVanillaPacket(message, target.getDirection()));
    }

    public <MSG> Packet<?> toVanillaPacket(MSG message, PlayNetworkDirection direction) {
        return direction.buildPacket(this.toBuffer(message), this.instance.getChannelName());
    }

    public <MSG> void reply(MSG msgToReply, NetworkEvent.Context context) {
        context.getPacketDispatcher().sendPacket(this.instance.getChannelName(), this.toBuffer(msgToReply).buffer());
    }

    public boolean isRemotePresent(Connection manager) {
        return this.instance.isRemotePresent(manager);
    }

    public <M> MessageBuilder<M> messageBuilder(Class<M> type, int id) {
        return MessageBuilder.forType(this, type, id, null);
    }

    public <M> MessageBuilder<M> messageBuilder(Class<M> type, int id, INetworkDirection<?> direction) {
        return MessageBuilder.forType(this, type, id, direction);
    }

    public <M extends SimpleMessage> MessageBuilder<M> simpleMessageBuilder(Class<M> type, int id) {
        return this.simpleMessageBuilder(type, id, null);
    }

    public <M extends SimpleMessage> MessageBuilder<M> simpleMessageBuilder(Class<M> type, int id, INetworkDirection<?> direction) {
        return this.messageBuilder(type, id, direction).consumerNetworkThread((msg, context) -> {
            msg.handleNetworkThread(context);
            context.enqueueWork(() -> msg.handleMainThread(context));
        }).encoder(SimpleMessage::encode);
    }

    public <M extends SimpleLoginMessage> MessageBuilder<M> simpleLoginMessageBuilder(Class<M> type, int id) {
        return this.simpleLoginMessageBuilder(type, id, null);
    }

    public <M extends SimpleLoginMessage> MessageBuilder<M> simpleLoginMessageBuilder(Class<M> type, int id, INetworkDirection<?> direction) {
        return this.simpleMessageBuilder(type, id, direction).loginIndex(SimpleLoginMessage::getLoginIndex, SimpleLoginMessage::setLoginIndex);
    }

    public static class MessageBuilder<MSG> {
        private SimpleChannel channel;
        private Class<MSG> type;
        private int id;
        private MessageFunctions.MessageEncoder<MSG> encoder;
        private MessageFunctions.MessageDecoder<MSG> decoder;
        private MessageFunctions.MessageConsumer<MSG> consumer;
        private MessageFunctions.LoginIndexGetter<MSG> loginIndexGetter;
        private MessageFunctions.LoginIndexSetter<MSG> loginIndexSetter;
        private MessageFunctions.LoginPacketGenerator<MSG> loginPacketGenerators;
        private Optional<INetworkDirection<?>> networkDirection;
        private boolean needsResponse = true;

        private static <MSG> MessageBuilder<MSG> forType(SimpleChannel channel, Class<MSG> type, int id, INetworkDirection<?> playNetworkDirection) {
            MessageBuilder<MSG> builder = new MessageBuilder<MSG>();
            builder.channel = channel;
            builder.id = id;
            builder.type = type;
            builder.networkDirection = Optional.ofNullable(playNetworkDirection);
            return builder;
        }

        public MessageBuilder<MSG> encoder(MessageFunctions.MessageEncoder<MSG> encoder) {
            this.encoder = encoder;
            return this;
        }

        public MessageBuilder<MSG> decoder(MessageFunctions.MessageDecoder<MSG> decoder) {
            this.decoder = decoder;
            return this;
        }

        public MessageBuilder<MSG> loginIndex(MessageFunctions.LoginIndexGetter<MSG> loginIndexGetter, MessageFunctions.LoginIndexSetter<MSG> loginIndexSetter) {
            this.loginIndexGetter = loginIndexGetter;
            this.loginIndexSetter = loginIndexSetter;
            return this;
        }

        public MessageBuilder<MSG> buildLoginPacketList(MessageFunctions.LoginPacketGenerator<MSG> loginPacketGenerators) {
            this.loginPacketGenerators = loginPacketGenerators;
            return this;
        }

        public MessageBuilder<MSG> markAsLoginPacket() {
            this.loginPacketGenerators = isLocal -> {
                try {
                    return Collections.singletonList(new MessageFunctions.LoginPacket<MSG>(this.type.getName(), this.type.getConstructor(new Class[0]).newInstance(new Object[0])));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Inaccessible no-arg constructor for message " + this.type.getName(), e);
                }
            };
            return this;
        }

        public MessageBuilder<MSG> noResponse() {
            this.needsResponse = false;
            return this;
        }

        public MessageBuilder<MSG> consumerNetworkThread(MessageFunctions.MessageConsumer<MSG> consumer) {
            this.consumer = consumer;
            return this;
        }

        public MessageBuilder<MSG> consumerMainThread(MessageFunctions.MessageConsumer<MSG> consumer) {
            this.consumer = (msg, context) -> context.enqueueWork(() -> consumer.handle(msg, context));
            return this;
        }

        public void add() {
            Objects.requireNonNull(this.consumer, () -> "Message of type " + this.type.getName() + " is missing a handler!");
            IndexedMessageCodec.MessageHandler<Object> message = this.channel.registerMessage(this.id, this.type, this.encoder, this.decoder, (msg, context) -> {
                context.setPacketHandled(true);
                this.consumer.handle(msg, context);
            }, this.networkDirection);
            if (this.loginIndexSetter != null) {
                message.setLoginIndexSetter(this.loginIndexSetter);
            }
            if (this.loginIndexGetter != null) {
                if (!IntSupplier.class.isAssignableFrom(this.type)) {
                    throw new IllegalArgumentException("Login packet type that does not supply an index as an IntSupplier");
                }
                message.setLoginIndexGetter(this.loginIndexGetter);
            }
            if (this.loginPacketGenerators != null) {
                this.channel.loginPackets.add(new LoginPacketEntry(this.loginPacketGenerators, this.needsResponse));
            }
        }
    }

    private record LoginPacketEntry(MessageFunctions.LoginPacketGenerator<?> generator, boolean needsResponse) {
    }
}

