/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.custom.payload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.ICustomPacketPayloadWithBuffer;

public record SimplePayload(FriendlyByteBuf payload, ResourceLocation id, int packetIndex) implements ICustomPacketPayloadWithBuffer
{
    public SimplePayload(byte[] payload, ResourceLocation id, int packetIndex) {
        this(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload)), id, packetIndex);
    }

    public static SimplePayload outbound(byte[] payload, int packetIndex, ResourceLocation id) {
        return new SimplePayload(payload, id, packetIndex);
    }

    public static SimplePayload outbound(FriendlyByteBuf byteBuf, int packetIndex, ResourceLocation id) {
        return new SimplePayload(byteBuf, id, packetIndex);
    }

    public static SimplePayload inbound(FriendlyByteBuf byteBuf, ResourceLocation id) {
        byte[] payload = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(payload);
        FriendlyByteBuf innerBuf = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])payload));
        return new SimplePayload(innerBuf, id, innerBuf.readVarInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.packetIndex);
        buf.writeBytes(this.payload.slice());
    }

    @Override
    public FriendlyByteBuf buffer() {
        return new FriendlyByteBuf(Unpooled.copiedBuffer((ByteBuf)this.payload));
    }
}

