/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.resource;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.ModLoadingWarning;
import net.neoforged.neoforge.resource.EmptyPackResources;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ResourcePackLoader {
    public static final String MOD_DATA_ID = "mod_data";
    public static final String MOD_RESOURCES_ID = "mod_resources";
    private static Map<IModFile, Pack.ResourcesSupplier> modResourcePacks;
    private static final Logger LOGGER;

    public static Optional<Pack.ResourcesSupplier> getPackFor(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(IModFileInfo::getFile).map(mf -> modResourcePacks.get(mf));
    }

    public static void loadResourcePacks(PackRepository resourcePacks, Function<Map<IModFile, Pack.ResourcesSupplier>, RepositorySource> packFinder) {
        ResourcePackLoader.findResourcePacks();
        resourcePacks.addPackFinder(packFinder.apply(modResourcePacks));
    }

    private static synchronized void findResourcePacks() {
        if (modResourcePacks == null) {
            modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(mf -> Pair.of((Object)mf, (Object)ResourcePackLoader.createPackForMod(mf))).collect(Collectors.toMap(p -> ((IModFileInfo)p.getFirst()).getFile(), Pair::getSecond, (u, v) -> {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Duplicate key %s", u));
            }, LinkedHashMap::new));
        }
    }

    public static RepositorySource buildPackFinder(Map<IModFile, Pack.ResourcesSupplier> modResourcePacks, PackType packType) {
        return packAcceptor -> ResourcePackLoader.packFinder(modResourcePacks, packAcceptor, packType);
    }

    private static void packFinder(Map<IModFile, Pack.ResourcesSupplier> modResourcePacks, Consumer<Pack> packAcceptor, PackType packType) {
        ArrayList<Pack> hiddenPacks = new ArrayList<Pack>();
        for (Map.Entry<IModFile, Pack.ResourcesSupplier> e : modResourcePacks.entrySet()) {
            String packName;
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if ("minecraft".equals(mod.getModId())) continue;
            String name = "mod:" + mod.getModId();
            Pack modPack = Pack.readMetaAndCreate((String)name, (Component)Component.literal((String)((packName = mod.getOwningFile().getFile().getFileName()).isEmpty() ? "[unnamed]" : packName)), (boolean)false, (Pack.ResourcesSupplier)e.getValue(), (PackType)packType, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT);
            if (modPack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            if (packType == PackType.CLIENT_RESOURCES && mod.getOwningFile().showAsResourcePack() || packType == PackType.SERVER_DATA && mod.getOwningFile().showAsDataPack()) {
                packAcceptor.accept(modPack);
                continue;
            }
            hiddenPacks.add(modPack.hidden());
        }
        packAcceptor.accept(ResourcePackLoader.makePack(packType, hiddenPacks));
    }

    private static Pack makePack(PackType packType, ArrayList<Pack> hiddenPacks) {
        String id = packType == PackType.CLIENT_RESOURCES ? MOD_RESOURCES_ID : MOD_DATA_ID;
        String name = packType == PackType.CLIENT_RESOURCES ? "Mod Resources" : "Mod Data";
        String descriptionKey = packType == PackType.CLIENT_RESOURCES ? "fml.resources.modresources" : "fml.resources.moddata";
        return Pack.readMetaAndCreate((String)id, (Component)Component.literal((String)name), (boolean)true, (Pack.ResourcesSupplier)new EmptyPackResources.EmptyResourcesSupplier(new PackMetadataSection((Component)Component.translatable((String)descriptionKey, (Object[])new Object[]{hiddenPacks.size()}), SharedConstants.getCurrentVersion().getPackVersion(packType)), false), (PackType)packType, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT).withChildren(hiddenPacks);
    }

    @NotNull
    public static Pack.ResourcesSupplier createPackForMod(IModFileInfo mf) {
        return new PathPackResources.PathResourcesSupplier(mf.getFile().getSecureJar().getRootPath(), true);
    }

    public static List<String> getDataPackNames() {
        ArrayList<String> ids = new ArrayList<String>(ModList.get().getModFiles().stream().filter(IModFileInfo::showAsDataPack).map(IModFileInfo::getFile).map(mf -> "mod:" + ((IModInfo)mf.getModInfos().get(0)).getModId()).filter(n -> !n.equals("mod:minecraft")).toList());
        ids.add(MOD_DATA_ID);
        return ids;
    }

    public static <V> Comparator<Map.Entry<String, V>> getSorter(PackType packType) {
        ArrayList<String> order = new ArrayList<String>();
        order.add("vanilla");
        if (packType == PackType.CLIENT_RESOURCES) {
            order.add(MOD_RESOURCES_ID);
        } else {
            order.add(MOD_DATA_ID);
        }
        ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(e -> ((IModInfo)e.getMods().get(0)).getModId()).map(e -> "mod:" + e).forEach(order::add);
        Object2IntOpenHashMap order_f = new Object2IntOpenHashMap(order.size());
        for (int x = 0; x < order.size(); ++x) {
            order_f.put((Object)((String)order.get(x)), x);
        }
        return (arg_0, arg_1) -> ResourcePackLoader.lambda$getSorter$13((Object2IntMap)order_f, arg_0, arg_1);
    }

    private static /* synthetic */ int lambda$getSorter$13(Object2IntMap order_f, Map.Entry e1, Map.Entry e2) {
        int i2;
        String s1 = (String)e1.getKey();
        String s2 = (String)e2.getKey();
        int i1 = order_f.getOrDefault((Object)s1, -1);
        if (i1 == (i2 = order_f.getOrDefault((Object)s2, -1)) && i1 == -1) {
            return s1.compareTo(s2);
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return i2 - i1;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

