/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.neoforge.common.I18nExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LanguageHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, String> defaultLanguageTable = new HashMap<String, String>();
    private static Map<String, String> modTable = new HashMap<String, String>();

    public static void captureLanguageMap(Map<String, String> table) {
        defaultLanguageTable = table;
        if (!modTable.isEmpty()) {
            defaultLanguageTable.putAll(modTable);
        }
    }

    private static void loadLanguage(String langName, MinecraftServer server) {
        String langFile = String.format(Locale.ROOT, "lang/%s.json", langName);
        CloseableResourceManager resourceManager = server.getServerResources().resourceManager();
        MultiPackResourceManager clientResources = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, resourceManager.listPacks().toList());
        int loaded = 0;
        for (String namespace : clientResources.getNamespaces()) {
            try {
                ResourceLocation langResource = new ResourceLocation(namespace, langFile);
                for (Resource resource : clientResources.getResourceStack(langResource)) {
                    InputStream stream = resource.open();
                    try {
                        Language.loadFromJson((InputStream)stream, (key, value) -> modTable.put((String)key, (String)value));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                ++loaded;
            }
            catch (Exception exception) {
                LOGGER.warn("Skipped language file: {}:{}", (Object)namespace, (Object)langFile, (Object)exception);
            }
        }
        LOGGER.debug("Loaded {} language files for {}", (Object)loaded, (Object)langName);
    }

    @Deprecated(forRemoval=true, since="1.20.4")
    public static void loadForgeAndMCLangs() {
        LanguageHook.loadBuiltinLanguages();
    }

    public static void loadBuiltinLanguages() {
        InputStream input;
        modTable = new HashMap<String, String>(5000);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            input = classLoader.getResourceAsStream("assets/minecraft/lang/en_us.json");
            try {
                assert (input != null);
                Language.loadFromJson((InputStream)input, (key, value) -> modTable.put((String)key, (String)value));
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load built-in language file for Minecraft", (Throwable)exception);
        }
        try {
            input = classLoader.getResourceAsStream("assets/neoforge/lang/en_us.json");
            try {
                assert (input != null);
                Language.loadFromJson((InputStream)input, (key, value) -> modTable.put((String)key, (String)value));
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load built-in language file for NeoForge", (Throwable)exception);
        }
        defaultLanguageTable.putAll(modTable);
        I18nExtension.loadLanguageData(modTable);
    }

    static void loadModLanguages(MinecraftServer server) {
        modTable = new HashMap<String, String>(5000);
        LanguageHook.loadLanguage("en_us", server);
        defaultLanguageTable.putAll(modTable);
        I18nExtension.loadLanguageData(modTable);
    }
}

