/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.registries.BaseMappedRegistry;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class NewRegistryEvent
extends Event
implements IModBusEvent {
    private final List<Registry<?>> registries = new ArrayList();

    NewRegistryEvent() {
    }

    public <T> Registry<T> create(RegistryBuilder<T> builder) {
        Registry<T> registry = builder.create();
        this.register(registry);
        return registry;
    }

    public <T> void register(Registry<T> registry) {
        this.registries.add(registry);
    }

    void fill() {
        ((BaseMappedRegistry)BuiltInRegistries.REGISTRY).unfreeze();
        for (Registry<?> registry : this.registries) {
            this.registerToRootRegistry(registry);
        }
        ((WritableRegistry)BuiltInRegistries.REGISTRY).freeze();
    }

    private void registerToRootRegistry(Registry<?> registry) {
        ResourceLocation registryName = registry.key().location();
        if (BuiltInRegistries.REGISTRY.containsKey(registryName)) {
            throw new IllegalStateException("Attempted duplicate registration of registry " + String.valueOf(registryName));
        }
        ((WritableRegistry)BuiltInRegistries.REGISTRY).register(registry.key(), registry, Lifecycle.stable());
    }
}

