/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.ConfigurationPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsPayload;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsReplyPayload;
import net.neoforged.neoforge.network.payload.RegistryDataMapSyncPayload;
import net.neoforged.neoforge.registries.BaseMappedRegistry;
import net.neoforged.neoforge.registries.RegistryManager;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ClientRegistryManager {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <R> void handleDataMapSync(RegistryDataMapSyncPayload<R> payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            BaseMappedRegistry registry = (BaseMappedRegistry)Minecraft.getInstance().level.registryAccess().registryOrThrow(payload.registryKey());
            registry.dataMaps.clear();
            payload.dataMaps().forEach((attachKey, maps) -> registry.dataMaps.put(RegistryManager.getDataMap(payload.registryKey(), attachKey), Collections.unmodifiableMap(maps)));
        }).exceptionally(ex -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"neoforge.network.data_maps.failed", (Object[])new Object[]{payload.registryKey().location(), ex.getMessage()}));
            LOGGER.error("Failed to handle registry data map sync: ", ex);
            return null;
        });
    }

    public static void handleKnownDataMaps(KnownRegistryDataMapsPayload payload, ConfigurationPayloadContext context) {
        record MandatoryEntry(ResourceKey<Registry<?>> registry, ResourceLocation id) {
        }
        Sets.SetView missingTheir;
        HashSet ourMandatory = new HashSet();
        RegistryManager.getDataMaps().forEach((reg, values) -> values.values().forEach(attach -> {
            if (attach.mandatorySync()) {
                ourMandatory.add(new MandatoryEntry((ResourceKey<Registry<?>>)reg, attach.id()));
            }
        }));
        HashSet theirMandatory = new HashSet();
        payload.dataMaps().forEach((reg, values) -> values.forEach(attach -> {
            if (attach.mandatory()) {
                theirMandatory.add(new MandatoryEntry((ResourceKey<Registry<?>>)reg, attach.id()));
            }
        }));
        ArrayList<MutableComponent> messages = new ArrayList<MutableComponent>();
        Sets.SetView missingOur = Sets.difference(ourMandatory, theirMandatory);
        if (!missingOur.isEmpty()) {
            messages.add(Component.translatable((String)"neoforge.network.data_maps.missing_our", (Object[])new Object[]{Component.literal((String)missingOur.stream().map(e -> String.valueOf(e.id()) + " (" + String.valueOf(e.registry().location()) + ")").collect(Collectors.joining(", "))).withStyle(ChatFormatting.GOLD)}));
        }
        if (!(missingTheir = Sets.difference(theirMandatory, ourMandatory)).isEmpty()) {
            messages.add(Component.translatable((String)"neoforge.network.data_maps.missing_their", (Object[])new Object[]{Component.literal((String)missingTheir.stream().map(e -> String.valueOf(e.id()) + " (" + String.valueOf(e.registry().location()) + ")").collect(Collectors.joining(", "))).withStyle(ChatFormatting.GOLD)}));
        }
        if (!messages.isEmpty()) {
            MutableComponent message = Component.empty();
            Iterator itr = messages.iterator();
            while (itr.hasNext()) {
                message = message.append((Component)itr.next());
                if (!itr.hasNext()) continue;
                message = message.append("\n");
            }
            context.packetHandler().disconnect((Component)message);
            return;
        }
        HashMap known = new HashMap();
        RegistryManager.getDataMaps().forEach((key, vals) -> known.put((ResourceKey<Registry<?>>)key, (Collection<ResourceLocation>)vals.keySet()));
        context.replyHandler().send(new KnownRegistryDataMapsReplyPayload(known));
    }
}

