/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class RegistrationFailedException
extends RuntimeException {
    private final ResourceLocation id;
    private final String namespace;
    private final Reason reason;

    @ApiStatus.Internal
    public RegistrationFailedException(ResourceLocation id, String namespace, Reason reason) {
        super(reason.format(id, namespace));
        this.id = id;
        this.namespace = namespace;
        this.reason = reason;
        if (reason == Reason.UNKNOWN) {
            throw new IllegalArgumentException("Reason can not be unknown. Supply a throwing reason for the exception.");
        }
    }

    @ApiStatus.Internal
    public RegistrationFailedException(ResourceLocation id, String namespace, Throwable throwable) {
        super(Reason.UNKNOWN.format(id, namespace), throwable);
        this.id = id;
        this.namespace = namespace;
        this.reason = Reason.UNKNOWN;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason implements ReasonFormatter
    {
        DUPLICATE_ID((id, namespace) -> "Duplicate payload id " + String.valueOf(id) + " for payload in namespace " + namespace + "."),
        INVALID_NAMESPACE((id, namespace) -> "Try registering payload in namespace " + namespace + " for payload with id " + String.valueOf(id) + "."),
        INVALID_REGISTRAR((id, namespace) -> "Invalid registrar. It can not be used to register payloads."),
        UNKNOWN((id, namespace) -> "General payload registration failure for payload with id " + String.valueOf(id) + " in namespace " + namespace + ".");

        private final ReasonFormatter formatter;

        private Reason(ReasonFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public String format(ResourceLocation id, String namespace) {
            return this.formatter.format(id, namespace);
        }
    }

    @FunctionalInterface
    private static interface ReasonFormatter {
        public String format(ResourceLocation var1, String var2);
    }
}

