/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.world.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.common.world.chunk.TicketSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
public class ForcedChunkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    static final TicketType<TicketOwner<BlockPos>> BLOCK = TicketType.create((String)"neoforge:block", Comparator.comparing(info -> info));
    static final TicketType<TicketOwner<BlockPos>> BLOCK_TICKING = TicketType.create((String)"neoforge:block_ticking", Comparator.comparing(info -> info));
    static final TicketType<TicketOwner<UUID>> ENTITY = TicketType.create((String)"neoforge:entity", Comparator.comparing(info -> info));
    static final TicketType<TicketOwner<UUID>> ENTITY_TICKING = TicketType.create((String)"neoforge:entity_ticking", Comparator.comparing(info -> info));
    private static boolean initialised = false;
    private static Map<ResourceLocation, TicketController> controllers = Map.of();

    @ApiStatus.Internal
    public static synchronized void init() {
        if (initialised) {
            throw new UnsupportedOperationException("Cannot init ticket controllers multiple times!");
        }
        initialised = true;
        HashMap controllers = new HashMap();
        ModLoader.get().postEvent((Event)new RegisterTicketControllersEvent(controller -> {
            if (controllers.containsKey(controller.id())) {
                throw new IllegalArgumentException("Attempted to register two controllers with the same ID " + String.valueOf(controller.id()));
            }
            controllers.put(controller.id(), controller);
        }));
        ForcedChunkManager.controllers = Map.copyOf(controllers);
    }

    public static boolean hasForcedChunks(ServerLevel level) {
        ForcedChunksSavedData data = (ForcedChunksSavedData)level.getDataStorage().get(new SavedData.Factory(ForcedChunksSavedData::new, ForcedChunksSavedData::load), "chunks");
        if (data == null) {
            return false;
        }
        return !data.getChunks().isEmpty() || !data.getBlockForcedChunks().isEmpty() || !data.getEntityForcedChunks().isEmpty();
    }

    static <T extends Comparable<? super T>> boolean forceChunk(ServerLevel level, ResourceLocation id, T owner, int chunkX, int chunkZ, boolean add, boolean ticking, TicketType<TicketOwner<T>> type, Function<ForcedChunksSavedData, TicketTracker<T>> ticketGetter) {
        boolean success;
        if (!controllers.containsKey(id)) {
            throw new IllegalArgumentException("Controller with ID " + String.valueOf(id) + " is not registered!");
        }
        ForcedChunksSavedData saveData = (ForcedChunksSavedData)level.getDataStorage().computeIfAbsent(ForcedChunksSavedData.factory(), "chunks");
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        long chunk = pos.toLong();
        TicketTracker<T> tickets = ticketGetter.apply(saveData);
        TicketOwner<T> ticketOwner = new TicketOwner<T>(id, owner);
        if (add) {
            success = tickets.add(ticketOwner, chunk, ticking);
            if (success) {
                level.getChunk(chunkX, chunkZ);
            }
        } else {
            success = tickets.remove(ticketOwner, chunk, ticking);
        }
        if (success) {
            saveData.setDirty(true);
            ForcedChunkManager.forceChunk(level, pos, type, ticketOwner, add, ticking);
        }
        return success;
    }

    private static <T extends Comparable<? super T>> void forceChunk(ServerLevel level, ChunkPos pos, TicketType<TicketOwner<T>> type, TicketOwner<T> owner, boolean add, boolean ticking) {
        if (add) {
            level.getChunkSource().addRegionTicket(type, pos, 2, owner, ticking);
        } else {
            level.getChunkSource().removeRegionTicket(type, pos, 2, owner, ticking);
        }
    }

    @ApiStatus.Internal
    public static void reinstatePersistentChunks(ServerLevel level, ForcedChunksSavedData saveData) {
        List<Map.Entry> controllers = ForcedChunkManager.controllers.entrySet().stream().filter(c -> ((TicketController)c.getValue()).callback() != null).toList();
        if (!controllers.isEmpty()) {
            Map blockTickets = ForcedChunkManager.gatherTicketsById(saveData.getBlockForcedChunks());
            Map entityTickets = ForcedChunkManager.gatherTicketsById(saveData.getEntityForcedChunks());
            controllers.forEach(value -> {
                boolean hasBlockTicket = blockTickets.containsKey(value.getKey());
                boolean hasEntityTicket = entityTickets.containsKey(value.getKey());
                if (hasBlockTicket || hasEntityTicket) {
                    Map<BlockPos, TicketSet> ownedBlockTickets = hasBlockTicket ? Collections.unmodifiableMap((Map)blockTickets.get(value.getKey())) : Collections.emptyMap();
                    Map<UUID, TicketSet> ownedEntityTickets = hasEntityTicket ? Collections.unmodifiableMap((Map)entityTickets.get(value.getKey())) : Collections.emptyMap();
                    ((TicketController)value.getValue()).callback().validateTickets(level, new TicketHelper(saveData, (ResourceLocation)value.getKey(), ownedBlockTickets, ownedEntityTickets));
                }
            });
        }
        ForcedChunkManager.reinstatePersistentChunks(level, BLOCK, saveData.getBlockForcedChunks().chunks, false);
        ForcedChunkManager.reinstatePersistentChunks(level, BLOCK_TICKING, saveData.getBlockForcedChunks().tickingChunks, true);
        ForcedChunkManager.reinstatePersistentChunks(level, ENTITY, saveData.getEntityForcedChunks().chunks, false);
        ForcedChunkManager.reinstatePersistentChunks(level, ENTITY_TICKING, saveData.getEntityForcedChunks().tickingChunks, true);
    }

    private static <T extends Comparable<? super T>> Map<ResourceLocation, Map<T, TicketSet>> gatherTicketsById(TicketTracker<T> tickets) {
        HashMap<ResourceLocation, Map<T, TicketSet>> modSortedOwnedChunks = new HashMap<ResourceLocation, Map<T, TicketSet>>();
        ForcedChunkManager.gatherTicketsById(tickets.chunks, TicketSet::nonTicking, modSortedOwnedChunks);
        ForcedChunkManager.gatherTicketsById(tickets.tickingChunks, TicketSet::ticking, modSortedOwnedChunks);
        return modSortedOwnedChunks;
    }

    private static <T extends Comparable<? super T>> void gatherTicketsById(Map<TicketOwner<T>, LongSet> tickets, Function<TicketSet, LongSet> typeGetter, Map<ResourceLocation, Map<T, TicketSet>> modSortedOwnedChunks) {
        tickets.forEach((owner, values) -> {
            TicketSet pair = modSortedOwnedChunks.computeIfAbsent(owner.id, modId -> new HashMap()).computeIfAbsent(owner.owner, o -> new TicketSet((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet()));
            ((LongSet)typeGetter.apply(pair)).addAll((LongCollection)values);
        });
    }

    private static <T extends Comparable<? super T>> void reinstatePersistentChunks(ServerLevel level, TicketType<TicketOwner<T>> type, Map<TicketOwner<T>, LongSet> tickets, boolean ticking) {
        tickets.forEach((owner, values) -> {
            LongIterator longIterator = values.iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                ForcedChunkManager.forceChunk(level, new ChunkPos(chunk), type, owner, true, ticking);
            }
        });
    }

    @ApiStatus.Internal
    public static void writeModForcedChunks(CompoundTag nbt, TicketTracker<BlockPos> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        if (!blockForcedChunks.isEmpty() || !entityForcedChunks.isEmpty()) {
            HashMap<ResourceLocation, Long2ObjectMap<CompoundTag>> forcedEntries = new HashMap<ResourceLocation, Long2ObjectMap<CompoundTag>>();
            ForcedChunkManager.writeForcedChunkOwners(forcedEntries, blockForcedChunks, "Blocks", 10, (T pos, ListTag forcedBlocks) -> forcedBlocks.add((Object)NbtUtils.writeBlockPos((BlockPos)pos)));
            ForcedChunkManager.writeForcedChunkOwners(forcedEntries, entityForcedChunks, "Entities", 11, (T uuid, ListTag forcedEntities) -> forcedEntities.add((Object)NbtUtils.createUUID((UUID)uuid)));
            ListTag forcedChunks = new ListTag();
            for (Map.Entry entry : forcedEntries.entrySet()) {
                CompoundTag forcedEntry = new CompoundTag();
                forcedEntry.putString("Controller", ((ResourceLocation)entry.getKey()).toString());
                ListTag modForced = new ListTag();
                modForced.addAll((Collection)((Long2ObjectMap)entry.getValue()).values());
                forcedEntry.put("ModForced", (Tag)modForced);
                forcedChunks.add((Object)forcedEntry);
            }
            nbt.put("ModForced", (Tag)forcedChunks);
        }
    }

    private static <T extends Comparable<? super T>> void writeForcedChunkOwners(Map<ResourceLocation, Long2ObjectMap<CompoundTag>> forcedEntries, TicketTracker<T> tracker, String listKey, int listType, BiConsumer<T, ListTag> ownerWriter) {
        ForcedChunkManager.writeForcedChunkOwners(forcedEntries, tracker.chunks, listKey, listType, ownerWriter);
        ForcedChunkManager.writeForcedChunkOwners(forcedEntries, tracker.tickingChunks, "Ticking" + listKey, listType, ownerWriter);
    }

    private static <T extends Comparable<? super T>> void writeForcedChunkOwners(Map<ResourceLocation, Long2ObjectMap<CompoundTag>> forcedEntries, Map<TicketOwner<T>, LongSet> forcedChunks, String listKey, int listType, BiConsumer<T, ListTag> ownerWriter) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : forcedChunks.entrySet()) {
            Long2ObjectMap modForced = forcedEntries.computeIfAbsent(entry.getKey().id, modId -> new Long2ObjectOpenHashMap());
            LongIterator longIterator = entry.getValue().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                CompoundTag modEntry = (CompoundTag)modForced.computeIfAbsent(chunk, chunkPos -> {
                    CompoundTag baseEntry = new CompoundTag();
                    baseEntry.putLong("Chunk", chunkPos);
                    return baseEntry;
                });
                ListTag ownerList = modEntry.getList(listKey, listType);
                ownerWriter.accept(entry.getKey().owner, ownerList);
                modEntry.put(listKey, (Tag)ownerList);
            }
        }
    }

    @ApiStatus.Internal
    public static void readModForcedChunks(CompoundTag nbt, TicketTracker<BlockPos> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        ListTag forcedChunks = nbt.getList("ModForced", 10);
        for (int i = 0; i < forcedChunks.size(); ++i) {
            CompoundTag forcedEntry = forcedChunks.getCompound(i);
            ResourceLocation controllerId = forcedEntry.contains("Controller", 8) ? new ResourceLocation(forcedEntry.getString("Controller")) : new ResourceLocation(forcedEntry.getString("Mod"), "default");
            if (controllers.containsKey(controllerId)) {
                ListTag modForced = forcedEntry.getList("ModForced", 10);
                for (int j = 0; j < modForced.size(); ++j) {
                    CompoundTag modEntry = modForced.getCompound(j);
                    long chunkPos = modEntry.getLong("Chunk");
                    ForcedChunkManager.readBlockForcedChunks(controllerId, chunkPos, modEntry, "Blocks", blockForcedChunks.chunks);
                    ForcedChunkManager.readBlockForcedChunks(controllerId, chunkPos, modEntry, "TickingBlocks", blockForcedChunks.tickingChunks);
                    ForcedChunkManager.readEntityForcedChunks(controllerId, chunkPos, modEntry, "Entities", entityForcedChunks.chunks);
                    ForcedChunkManager.readEntityForcedChunks(controllerId, chunkPos, modEntry, "TickingEntities", entityForcedChunks.tickingChunks);
                }
                continue;
            }
            LOGGER.warn("Found chunk loading data for controller id {} which is currently not available or active - it will be removed from the level save.", (Object)controllerId);
        }
    }

    private static void readBlockForcedChunks(ResourceLocation controllerId, long chunkPos, CompoundTag modEntry, String key, Map<TicketOwner<BlockPos>, LongSet> blockForcedChunks) {
        ListTag forcedBlocks = modEntry.getList(key, 10);
        for (int k = 0; k < forcedBlocks.size(); ++k) {
            blockForcedChunks.computeIfAbsent(new TicketOwner<BlockPos>(controllerId, NbtUtils.readBlockPos((CompoundTag)forcedBlocks.getCompound(k))), owner -> new LongOpenHashSet()).add(chunkPos);
        }
    }

    private static void readEntityForcedChunks(ResourceLocation controllerId, long chunkPos, CompoundTag modEntry, String key, Map<TicketOwner<UUID>, LongSet> entityForcedChunks) {
        ListTag forcedEntities = modEntry.getList(key, 11);
        for (Tag uuid : forcedEntities) {
            entityForcedChunks.computeIfAbsent(new TicketOwner<UUID>(controllerId, NbtUtils.loadUUID((Tag)uuid)), owner -> new LongOpenHashSet()).add(chunkPos);
        }
    }

    public static class TicketTracker<T extends Comparable<? super T>> {
        final Map<TicketOwner<T>, LongSet> chunks = new HashMap<TicketOwner<T>, LongSet>();
        final Map<TicketOwner<T>, LongSet> tickingChunks = new HashMap<TicketOwner<T>, LongSet>();

        public Map<TicketOwner<T>, LongSet> getChunks() {
            return Collections.unmodifiableMap(this.chunks);
        }

        public Map<TicketOwner<T>, LongSet> getTickingChunks() {
            return Collections.unmodifiableMap(this.tickingChunks);
        }

        public boolean isEmpty() {
            return this.chunks.isEmpty() && this.tickingChunks.isEmpty();
        }

        private Map<TicketOwner<T>, LongSet> getTickets(boolean ticking) {
            return ticking ? this.tickingChunks : this.chunks;
        }

        public boolean remove(TicketOwner<T> owner, long chunk, boolean ticking) {
            LongSet ticketChunks;
            Map<TicketOwner<T>, LongSet> tickets = this.getTickets(ticking);
            if (tickets.containsKey(owner) && (ticketChunks = tickets.get(owner)).remove(chunk)) {
                if (ticketChunks.isEmpty()) {
                    tickets.remove(owner);
                }
                return true;
            }
            return false;
        }

        private boolean add(TicketOwner<T> owner, long chunk, boolean ticking) {
            return this.getTickets(ticking).computeIfAbsent(owner, o -> new LongOpenHashSet()).add(chunk);
        }
    }

    static class TicketOwner<T extends Comparable<? super T>>
    implements Comparable<TicketOwner<T>> {
        private final ResourceLocation id;
        private final T owner;

        TicketOwner(ResourceLocation id, T owner) {
            this.id = id;
            this.owner = owner;
        }

        @Override
        public int compareTo(TicketOwner<T> other) {
            int res = this.id.compareTo(other.id);
            return res == 0 ? this.owner.compareTo(other.owner) : res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TicketOwner that = (TicketOwner)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.owner, that.owner);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.owner);
        }
    }
}

