/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ItemExistsCondition
implements ICondition {
    public static Codec<ItemExistsCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("item").forGetter(ItemExistsCondition::getItem)).apply((Applicative)builder, ItemExistsCondition::new));
    private final ResourceLocation item;

    public ItemExistsCondition(String location) {
        this(new ResourceLocation(location));
    }

    public ItemExistsCondition(String namespace, String path) {
        this(new ResourceLocation(namespace, path));
    }

    public ItemExistsCondition(ResourceLocation item) {
        this.item = item;
    }

    @Override
    public boolean test(ICondition.IContext context) {
        return BuiltInRegistries.ITEM.containsKey(this.item);
    }

    @Override
    public Codec<? extends ICondition> codec() {
        return CODEC;
    }

    public ResourceLocation getItem() {
        return this.item;
    }

    public String toString() {
        return "item_exists(\"" + String.valueOf(this.item) + "\")";
    }
}

