/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.RenderTypeGroup;
import org.jetbrains.annotations.ApiStatus;

public class RegisterNamedRenderTypesEvent
extends Event
implements IModBusEvent {
    private final Map<ResourceLocation, RenderTypeGroup> renderTypes;

    @ApiStatus.Internal
    public RegisterNamedRenderTypesEvent(Map<ResourceLocation, RenderTypeGroup> renderTypes) {
        this.renderTypes = renderTypes;
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public void register(String name, RenderType blockRenderType, RenderType entityRenderType) {
        this.register(new ResourceLocation(ModLoadingContext.get().getActiveNamespace(), name), blockRenderType, entityRenderType, entityRenderType);
    }

    public void register(ResourceLocation key, RenderType blockRenderType, RenderType entityRenderType) {
        this.register(key, blockRenderType, entityRenderType, entityRenderType);
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public void register(String name, RenderType blockRenderType, RenderType entityRenderType, RenderType fabulousEntityRenderType) {
        this.register(new ResourceLocation(ModLoadingContext.get().getActiveNamespace(), name), blockRenderType, entityRenderType, fabulousEntityRenderType);
    }

    public void register(ResourceLocation key, RenderType blockRenderType, RenderType entityRenderType, RenderType fabulousEntityRenderType) {
        Preconditions.checkArgument((!this.renderTypes.containsKey(key) ? 1 : 0) != 0, (Object)("Render type already registered: " + String.valueOf(key)));
        Preconditions.checkArgument((blockRenderType.format() == DefaultVertexFormat.BLOCK ? 1 : 0) != 0, (Object)"The block render type must use the BLOCK vertex format.");
        Preconditions.checkArgument((blockRenderType.getChunkLayerId() >= 0 ? 1 : 0) != 0, (Object)"Only chunk render types can be used for block rendering. Query RenderType#chunkBufferLayers() for a list.");
        Preconditions.checkArgument((entityRenderType.format() == DefaultVertexFormat.NEW_ENTITY ? 1 : 0) != 0, (Object)"The entity render type must use the NEW_ENTITY vertex format.");
        Preconditions.checkArgument((fabulousEntityRenderType.format() == DefaultVertexFormat.NEW_ENTITY ? 1 : 0) != 0, (Object)"The fabulous entity render type must use the NEW_ENTITY vertex format.");
        this.renderTypes.put(key, new RenderTypeGroup(blockRenderType, entityRenderType, fabulousEntityRenderType));
    }
}

